/*
 * Decompiled with CFR 0.152.
 */
package com.nemonotfound.nemoscarpentry.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9696;

public class CarpentryRecipe
implements class_1860<class_9696> {
    private final class_1799 result;
    private final List<Pair<class_1856, Integer>> ingredientPairs;
    private final String tool;

    public CarpentryRecipe(class_1799 result, List<Pair<class_1856, Integer>> ingredientPairs, String tool) {
        this.result = result;
        this.ingredientPairs = ingredientPairs;
        this.tool = tool;
    }

    public boolean matches(class_9696 inventory, class_1937 world) {
        return ((class_1856)this.ingredientPairs.get(0).getFirst()).method_8093(inventory.method_59984(0));
    }

    public class_1799 craft(class_9696 inventory, class_7225.class_7874 lookup) {
        return this.result.method_7972();
    }

    public List<Pair<class_1856, Integer>> getIngredientPairs() {
        return this.ingredientPairs;
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_1799 method_8110(class_7225.class_7874 registriesLookup) {
        return this.result;
    }

    public class_1865<?> method_8119() {
        return Serializer.INSTANCE;
    }

    public class_3956<?> method_17716() {
        return Type.INSTANCE;
    }

    public String getTool() {
        return this.tool;
    }

    public static class Serializer
    implements class_1865<CarpentryRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final MapCodec<CarpentryRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Serializer.getResultStackCodec().forGetter(recipe -> recipe.result), (App)Serializer.validateAmount((Codec<Pair<class_1856, Integer>>)Codec.pair((Codec)class_1856.field_46096, (Codec)Codec.INT.optionalFieldOf("itemCount", (Object)1).codec())).fieldOf("ingredients").forGetter(CarpentryRecipe::getIngredientPairs), (App)Codec.STRING.optionalFieldOf("tool", (Object)"none").forGetter(recipe -> recipe.tool)).apply((Applicative)instance, CarpentryRecipe::new));
        private final class_9139<class_9129, CarpentryRecipe> packetCodec = class_9139.method_56437(this::write, this::read);
        public static final String ID = "carpentry";
        private static final int maxIngredients = 2;

        private static MapCodec<class_1799> getResultStackCodec() {
            return RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_7923.field_41178.method_39673().fieldOf("result").forGetter(class_1799::method_7909), (App)Codec.INT.fieldOf("count").forGetter(class_1799::method_7947)).apply((Applicative)instance, class_1799::new));
        }

        private static Codec<List<Pair<class_1856, Integer>>> validateAmount(Codec<Pair<class_1856, Integer>> delegate) {
            return delegate.listOf().validate(list -> list.size() > 2 ? DataResult.error(() -> "Recipe has too many ingredients!") : DataResult.success((Object)list)).validate(list -> list.isEmpty() ? DataResult.error(() -> "Recipe has no ingredients!") : DataResult.success((Object)list));
        }

        public MapCodec<CarpentryRecipe> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, CarpentryRecipe> method_56104() {
            return this.packetCodec;
        }

        public CarpentryRecipe read(class_9129 buf) {
            class_2371 ingredientPairs = class_2371.method_10211();
            int ingredientCount = buf.readInt();
            class_1856 firstIngredient = (class_1856)class_1856.field_48355.decode((Object)buf);
            int firstIngredientCount = buf.readInt();
            ingredientPairs.add((Object)Pair.of((Object)firstIngredient, (Object)firstIngredientCount));
            if (ingredientCount == 2) {
                class_1856 secondIngredient = (class_1856)class_1856.field_48355.decode((Object)buf);
                int secondIngredientCount = buf.readInt();
                ingredientPairs.add((Object)Pair.of((Object)secondIngredient, (Object)secondIngredientCount));
            }
            class_1799 result = (class_1799)class_1799.field_48349.decode((Object)buf);
            String tool = buf.method_19772();
            return new CarpentryRecipe(result, (List<Pair<class_1856, Integer>>)ingredientPairs, tool);
        }

        public void write(class_9129 buf, CarpentryRecipe recipe) {
            List<Pair<class_1856, Integer>> ingredientPairs = recipe.getIngredientPairs();
            buf.method_53002(ingredientPairs.size());
            for (Pair<class_1856, Integer> ingredientPair : recipe.getIngredientPairs()) {
                class_1856.field_48355.encode((Object)buf, (Object)((class_1856)ingredientPair.getFirst()));
                buf.method_53002(((Integer)ingredientPair.getSecond()).intValue());
            }
            class_1799.field_48349.encode((Object)buf, (Object)recipe.result);
            buf.method_10814(recipe.getTool());
        }
    }

    public static class Type
    implements class_3956<CarpentryRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "carpentry";
    }
}

