/*
 * Decompiled with CFR 0.152.
 */
package com.nemonotfound.nemoscarpentry.screen;

import com.nemonotfound.nemoscarpentry.recipe.CarpentryRecipe;
import com.nemonotfound.nemoscarpentry.screen.CarpentryScreenHandler;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_465;
import net.minecraft.class_7225;
import net.minecraft.class_8786;

@Environment(value=EnvType.CLIENT)
public class CarpentryScreen
extends class_465<CarpentryScreenHandler> {
    private static final class_2960 TEXTURE = class_2960.method_60655((String)"nemos-carpentry", (String)"textures/gui/container/carpenters_workbench.png");
    private float scrollAmount;
    private int scrollOffset;
    private boolean mouseClicked;
    private boolean hasAvailableRecipes;

    public CarpentryScreen(CarpentryScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
        handler.setContentsChangedListener(this::onInventoryChange);
        --this.field_25268;
    }

    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        context.method_25302(TEXTURE, this.field_2776, this.field_2800, 0, 0, this.field_2792, this.field_2779);
        this.drawScroll(context);
        this.drawToolSlots(context);
        this.renderRecipeBackground(context, mouseX, mouseY, this.field_2776 + 52, this.field_2800 + 14, this.scrollOffset + 12);
        this.renderRecipeIcons(context, this.field_2776 + 52, this.field_2800 + 14, this.scrollOffset + 12);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        this.method_2380(context, mouseX, mouseY);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.mouseClicked = false;
        if (this.hasAvailableRecipes) {
            int i = this.field_2776 + 52;
            int j = this.field_2800 + 14;
            int k = this.scrollOffset + 12;
            for (int l = this.scrollOffset; l < k; ++l) {
                int m = l - this.scrollOffset;
                double d = mouseX - (double)(i + m % 4 * 16);
                double e = mouseY - (double)(j + m / 4 * 18);
                if (!(d >= 0.0) || !(e >= 0.0) || !(d < 16.0) || !(e < 18.0) || !((CarpentryScreenHandler)this.field_2797).method_7604((class_1657)this.field_22787.field_1724, l)) continue;
                if (((CarpentryScreenHandler)this.field_2797).getAvailableRecipeCount() > l) {
                    if (!((CarpentryScreenHandler)this.field_2797).canCraftSelectedRecipe()) {
                        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_17711, (float)4.0f));
                    } else {
                        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_17711, (float)1.0f));
                    }
                }
                this.field_22787.field_1761.method_2900(((CarpentryScreenHandler)this.field_2797).field_7763, l);
                return true;
            }
            i = this.field_2776 + 119;
            j = this.field_2800 + 9;
            if (mouseX >= (double)i && mouseX < (double)(i + 12) && mouseY >= (double)j && mouseY < (double)(j + 54)) {
                this.mouseClicked = true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    protected boolean method_2381(double mouseX, double mouseY, int left, int top, int button) {
        return mouseX < (double)left - 22.0 || mouseY < (double)top || mouseX >= (double)(left + this.field_2792) || mouseY >= (double)(top + this.field_2779);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.mouseClicked && this.shouldScroll()) {
            int i = this.field_2800 + 14;
            int j = i + 54;
            this.scrollAmount = ((float)mouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.scrollAmount = class_3532.method_15363((float)this.scrollAmount, (float)0.0f, (float)1.0f);
            this.scrollOffset = (int)((double)(this.scrollAmount * (float)this.getMaxScroll()) + 0.5) * 4;
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.shouldScroll()) {
            int i = this.getMaxScroll();
            float f = (float)verticalAmount / (float)i;
            this.scrollAmount = class_3532.method_15363((float)(this.scrollAmount - f), (float)0.0f, (float)1.0f);
            this.scrollOffset = (int)((double)(this.scrollAmount * (float)i) + 0.5) * 4;
        }
        return true;
    }

    protected void method_2380(class_332 context, int x, int y) {
        super.method_2380(context, x, y);
        int i = this.field_2776 + 52;
        int j = this.field_2800 + 14;
        int k = this.scrollOffset + 12;
        List<class_8786<CarpentryRecipe>> list = ((CarpentryScreenHandler)this.field_2797).getAvailableRecipes();
        for (int l = this.scrollOffset; l < k && l < ((CarpentryScreenHandler)this.field_2797).getAvailableRecipeCount(); ++l) {
            int m = l - this.scrollOffset;
            int n = i + m % 4 * 16;
            int o = j + m / 4 * 18 + 2;
            if (x < n || x >= n + 16 || y < o || y >= o + 18) continue;
            context.method_51446(this.field_22793, ((CarpentryRecipe)list.get(l).comp_1933()).method_8110((class_7225.class_7874)this.field_22787.field_1687.method_30349()), x, y);
        }
    }

    private void renderRecipeBackground(class_332 context, int mouseX, int mouseY, int x, int y, int scrollOffset) {
        for (int i = this.scrollOffset; i < scrollOffset && i < ((CarpentryScreenHandler)this.field_2797).getAvailableRecipeCount(); ++i) {
            int j = i - this.scrollOffset;
            int k = x + j % 4 * 16;
            int l = j / 4;
            int m = y + l * 18 + 2;
            int n = this.field_2779;
            if (i == ((CarpentryScreenHandler)this.field_2797).getSelectedRecipe()) {
                n += 54;
            } else if (mouseX >= k && mouseY >= m && mouseX < k + 16 && mouseY < m + 18) {
                n += 36;
            }
            if (!((CarpentryScreenHandler)this.field_2797).canCraftRecipe(i)) {
                n += 18;
            }
            context.method_25302(TEXTURE, k, m - 1, 0, n, 16, 18);
        }
    }

    private void renderRecipeIcons(class_332 context, int x, int y, int scrollOffset) {
        List<class_8786<CarpentryRecipe>> list = ((CarpentryScreenHandler)this.field_2797).getAvailableRecipes();
        for (int i = this.scrollOffset; i < scrollOffset && i < ((CarpentryScreenHandler)this.field_2797).getAvailableRecipeCount(); ++i) {
            int j = i - this.scrollOffset;
            int k = x + j % 4 * 16;
            int l = j / 4;
            int m = y + l * 18 + 2;
            context.method_51427(((CarpentryRecipe)list.get(i).comp_1933()).method_8110((class_7225.class_7874)this.field_22787.field_1687.method_30349()), k, m);
        }
    }

    private void drawScroll(class_332 context) {
        int scrollOffset = (int)(41.0f * this.scrollAmount);
        context.method_25302(TEXTURE, this.field_2776 + 119, this.field_2800 + 15 + scrollOffset, 176 + (this.shouldScroll() ? 0 : 12), 0, 12, 15);
    }

    private void drawToolSlots(class_332 context) {
        context.method_25302(TEXTURE, this.field_2776 - 21, this.field_2800 + 13, 176, 15, 18, 18);
        context.method_25302(TEXTURE, this.field_2776 - 21, this.field_2800 + 36, 176, 15, 18, 18);
        context.method_25302(TEXTURE, this.field_2776 - 21, this.field_2800 + 59, 176, 15, 18, 18);
        context.method_25302(TEXTURE, this.field_2776 - 21, this.field_2800 + 82, 176, 15, 18, 18);
    }

    private boolean shouldScroll() {
        return ((CarpentryScreenHandler)this.field_2797).getAvailableRecipeCount() > 12;
    }

    protected int getMaxScroll() {
        return (((CarpentryScreenHandler)this.field_2797).getAvailableRecipeCount() + 4 - 1) / 4 - 3;
    }

    private void onInventoryChange() {
        this.hasAvailableRecipes = ((CarpentryScreenHandler)this.field_2797).hasAvailableRecipes();
        if (!this.hasAvailableRecipes) {
            this.scrollAmount = 0.0f;
            this.scrollOffset = 0;
        }
    }
}

