/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.worldgen;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.DeferredObject;
import net.blay09.mods.balm.api.event.server.ServerReloadedEvent;
import net.blay09.mods.balm.api.event.server.ServerStartedEvent;
import net.blay09.mods.balm.api.world.BalmWorldGen;
import net.blay09.mods.balm.api.world.BiomePredicate;
import net.blay09.mods.waystones.block.ModBlocks;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.config.WaystonesConfigData;
import net.blay09.mods.waystones.config.WorldGenStyle;
import net.blay09.mods.waystones.mixin.StructureTemplatePoolAccessor;
import net.blay09.mods.waystones.tag.ModBiomeTags;
import net.blay09.mods.waystones.worldgen.WaystoneFeature;
import net.blay09.mods.waystones.worldgen.WaystonePlacement;
import net.blay09.mods.waystones.worldgen.WaystoneStructurePoolElement;
import net.minecraft.class_1959;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_3111;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_5188;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5497;
import net.minecraft.class_6798;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import net.minecraft.class_7924;

public class ModWorldGen {
    private static final class_2960 waystone = class_2960.method_60655((String)"waystones", (String)"waystone");
    private static final class_2960 mossyWaystone = class_2960.method_60655((String)"waystones", (String)"mossy_waystone");
    private static final class_2960 sandyWaystone = class_2960.method_60655((String)"waystones", (String)"sandy_waystone");
    private static final class_2960 blackstoneWaystone = class_2960.method_60655((String)"waystones", (String)"blackstone_waystone");
    private static final class_2960 deepslateWaystone = class_2960.method_60655((String)"waystones", (String)"deepslate_waystone");
    private static final class_2960 endStoneWaystone = class_2960.method_60655((String)"waystones", (String)"end_stone_waystone");
    private static final class_2960 villageWaystoneStructure = class_2960.method_60655((String)"waystones", (String)"village/common/waystone");
    private static final class_2960 desertVillageWaystoneStructure = class_2960.method_60655((String)"waystones", (String)"village/desert/waystone");
    private static final class_5321<class_5497> EMPTY_PROCESSOR_LIST_KEY = class_5321.method_29179((class_5321)class_7924.field_41247, (class_2960)class_2960.method_60655((String)"minecraft", (String)"empty"));
    public static DeferredObject<class_6798<WaystonePlacement>> waystonePlacement;

    public static void initialize(BalmWorldGen worldGen) {
        worldGen.registerFeature(waystone, () -> new WaystoneFeature((Codec<class_3111>)class_3111.field_24893, ModBlocks.waystone.method_9564()));
        worldGen.registerFeature(mossyWaystone, () -> new WaystoneFeature((Codec<class_3111>)class_3111.field_24893, ModBlocks.mossyWaystone.method_9564()));
        worldGen.registerFeature(sandyWaystone, () -> new WaystoneFeature((Codec<class_3111>)class_3111.field_24893, ModBlocks.sandyWaystone.method_9564()));
        worldGen.registerFeature(blackstoneWaystone, () -> new WaystoneFeature((Codec<class_3111>)class_3111.field_24893, ModBlocks.blackstoneWaystone.method_9564()));
        worldGen.registerFeature(deepslateWaystone, () -> new WaystoneFeature((Codec<class_3111>)class_3111.field_24893, ModBlocks.deepslateWaystone.method_9564()));
        worldGen.registerFeature(endStoneWaystone, () -> new WaystoneFeature((Codec<class_3111>)class_3111.field_24893, ModBlocks.endStoneWaystone.method_9564()));
        waystonePlacement = worldGen.registerPlacementModifier(ModWorldGen.id("waystone"), () -> () -> WaystonePlacement.CODEC);
        worldGen.addFeatureToBiomes(ModWorldGen.matchesTag(ModBiomeTags.IS_DESERT), class_2893.class_2895.field_13178, ModWorldGen.getWaystoneFeature(WorldGenStyle.SANDY));
        worldGen.addFeatureToBiomes(ModWorldGen.matchesTag((class_6862<class_1959>)class_6908.field_36516), class_2893.class_2895.field_13178, ModWorldGen.getWaystoneFeature(WorldGenStyle.MOSSY));
        worldGen.addFeatureToBiomes(ModWorldGen.matchesTag(ModBiomeTags.IS_SWAMP), class_2893.class_2895.field_13178, ModWorldGen.getWaystoneFeature(WorldGenStyle.MOSSY));
        worldGen.addFeatureToBiomes(ModWorldGen.matchesTag(ModBiomeTags.IS_MUSHROOM), class_2893.class_2895.field_13178, ModWorldGen.getWaystoneFeature(WorldGenStyle.MOSSY));
        worldGen.addFeatureToBiomes(ModWorldGen.matchesTag((class_6862<class_1959>)class_6908.field_36518), class_2893.class_2895.field_13178, ModWorldGen.getWaystoneFeature(WorldGenStyle.BLACKSTONE));
        worldGen.addFeatureToBiomes(ModWorldGen.matchesTag((class_6862<class_1959>)class_6908.field_37394), class_2893.class_2895.field_13178, ModWorldGen.getWaystoneFeature(WorldGenStyle.END_STONE));
        worldGen.addFeatureToBiomes(ModWorldGen.matchesNeitherTag(List.of(ModBiomeTags.IS_SWAMP, ModBiomeTags.IS_DESERT, class_6908.field_36516, ModBiomeTags.IS_MUSHROOM, class_6908.field_36518, class_6908.field_37394)), class_2893.class_2895.field_13178, ModWorldGen.getWaystoneFeature(WorldGenStyle.DEFAULT));
        Balm.getEvents().onEvent(ServerStartedEvent.class, event -> ModWorldGen.setupDynamicRegistries((class_5455)event.getServer().method_30611()));
        Balm.getEvents().onEvent(ServerReloadedEvent.class, event -> ModWorldGen.setupDynamicRegistries((class_5455)event.getServer().method_30611()));
    }

    private static BiomePredicate matchesTag(class_6862<class_1959> tag) {
        return (resourceLocation, biome) -> biome.method_40220(tag);
    }

    private static BiomePredicate matchesNeitherTag(List<class_6862<class_1959>> tags) {
        return (resourceLocation, biome) -> {
            for (class_6862 tag : tags) {
                if (!biome.method_40220(tag)) continue;
                return false;
            }
            return true;
        };
    }

    private static class_2960 id(String name) {
        return class_2960.method_60655((String)"waystones", (String)name);
    }

    private static class_2960 getWaystoneFeature(WorldGenStyle biomeWorldGenStyle) {
        WorldGenStyle worldGenStyle = WaystonesConfig.getActive().worldGen.wildWaystoneStyle;
        return switch (worldGenStyle) {
            case WorldGenStyle.MOSSY -> mossyWaystone;
            case WorldGenStyle.SANDY -> sandyWaystone;
            case WorldGenStyle.BLACKSTONE -> blackstoneWaystone;
            case WorldGenStyle.DEEPSLATE -> deepslateWaystone;
            case WorldGenStyle.END_STONE -> endStoneWaystone;
            case WorldGenStyle.BIOME -> {
                switch (biomeWorldGenStyle) {
                    case SANDY: {
                        yield sandyWaystone;
                    }
                    case MOSSY: {
                        yield mossyWaystone;
                    }
                    case BLACKSTONE: {
                        yield blackstoneWaystone;
                    }
                    case DEEPSLATE: {
                        yield deepslateWaystone;
                    }
                    case END_STONE: {
                        yield endStoneWaystone;
                    }
                }
                yield waystone;
            }
            default -> waystone;
        };
    }

    public static void setupDynamicRegistries(class_5455 registryAccess) {
        if (WaystonesConfig.getActive().worldGen.spawnInVillages != WaystonesConfigData.VillageWaystoneGeneration.DISABLED) {
            ModWorldGen.addWaystoneStructureToVillageConfig(registryAccess, "village/plains/houses", villageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(registryAccess, "village/snowy/houses", villageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(registryAccess, "village/savanna/houses", villageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(registryAccess, "village/desert/houses", desertVillageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(registryAccess, "village/taiga/houses", villageWaystoneStructure, 1);
        }
    }

    private static void addWaystoneStructureToVillageConfig(class_5455 registryAccess, String villagePiece, class_2960 waystoneStructure, int weight) {
        class_3785 pool;
        class_6880.class_6883 emptyProcessorList = registryAccess.method_30530(class_7924.field_41247).method_40290(EMPTY_PROCESSOR_LIST_KEY);
        class_5188 piece = (class_5188)class_3784.method_30426((String)waystoneStructure.toString(), (class_6880)emptyProcessorList).apply(class_3785.class_3786.field_16687);
        if (piece instanceof WaystoneStructurePoolElement) {
            WaystoneStructurePoolElement element = (WaystoneStructurePoolElement)piece;
            element.waystones$setIsWaystone(true);
        }
        if ((pool = (class_3785)registryAccess.method_30530(class_7924.field_41249).method_17966(class_2960.method_60656((String)villagePiece)).orElse(null)) != null) {
            StructureTemplatePoolAccessor poolAccessor = (StructureTemplatePoolAccessor)pool;
            ObjectArrayList listOfPieces = new ObjectArrayList(poolAccessor.getTemplates());
            for (int i = 0; i < weight; ++i) {
                listOfPieces.add((Object)piece);
            }
            poolAccessor.setTemplates((ObjectArrayList<class_3784>)listOfPieces);
            ArrayList<Pair<class_3784, Integer>> listOfWeightedPieces = new ArrayList<Pair<class_3784, Integer>>(poolAccessor.getRawTemplates());
            listOfWeightedPieces.add((Pair<class_3784, Integer>)new Pair((Object)piece, (Object)weight));
            poolAccessor.setRawTemplates(listOfWeightedPieces);
        }
    }
}

