#include "/lib/core.glsl"

#include "/lib/config.glsl"

#ifdef SHARPEN
#endif

/* RENDERTARGETS: 0 */
layout(location = 0) out vec3 outColor0;

uniform sampler2D colortex0;

in VertexData {
	vec2 coord;
} vsh;

float luminance(in vec3 color) {
	return dot(color, vec3(0.2125, 0.7154, 0.0721));
}

void main() {
	immut vec3 color = texture(colortex0, vsh.coord).rgb;

	const ivec2 offsets[4] = ivec2[4](
		ivec2(1, 1),
		ivec2(1, -1),
		ivec2(-1, 1),
		ivec2(-1, -1)
	);

	immut vec3 sum = vec3(
		dot(textureGatherOffsets(colortex0, vsh.coord, offsets), vec4(1.0)),
		dot(textureGatherOffsets(colortex0, vsh.coord, offsets, 1), vec4(1.0)),
		dot(textureGatherOffsets(colortex0, vsh.coord, offsets, 2), vec4(1.0))
	);

	// Gather without offset makes a cool 3D-like effect
	// Maybe use in gbuffers?

	outColor0 = SHARPENING * clamp(dot(color - (sum - color) / 3.0, vec3(0.333333)), -0.003, 0.003) * sqrt(luminance(color)) * normalize(color.rgb + 0.00000001) + color;
}