#include "/lib/core.glsl"

#include "/lib/config.glsl"

#ifdef VOLUMETRIC_LIGHT
#endif

/* RENDERTARGETS: 0 */
layout(location = 0) out vec3 outColor0;

uniform int isEyeInWater, worldTime;
uniform float far, frameTimeCounter, near, rainStrength;
uniform vec3 fogColor, shadowLightPosition, skyColor;
uniform mat4 gbufferModelViewInverse, gbufferProjectionInverse, shadowModelView, shadowProjection;
uniform sampler2D colortex0, depthtex1, noisetex;
uniform sampler2DShadow shadowtex1;

in VertexData {
	vec2 coord;
} vsh;

#include "/lib/distort.glsl"

void main() {
	vec3 color = texture(colortex0, vsh.coord).rgb;

	immut float depth = texture(depthtex1, vsh.coord).r;

	if (depth < 1.0) {
		immut vec3 fog_color = pow(fogColor, vec3(2.4));

		immut float daylight = min(distance(worldTime, 6000.0), 30000.0 - worldTime) / 12000.0;
		immut vec3 light_color = mix(fog_color, max(1.1 - pow(skyColor, vec3(2.4)) - smoothstep(0.4, 0.6, daylight), 0.0), min(daylight + 0.1, 1.0 - rainStrength * 0.9));

		if (length(light_color) * (10.0 + SUNLIGHT - AMBIENT) > 5.0) {
			immut float random = mix(texture(noisetex, vsh.coord * 100.0 + frameTimeCounter * 0.01).r, 0.5, 0.5);

			immut vec4 view = gbufferProjectionInverse * vec4(vec3(vsh.coord, depth) * 2.0 - 1.0, 1.0);
			immut mat4 gbuffer_model_view_to_shadow_projection = shadowProjection * shadowModelView * gbufferModelViewInverse;

			float ray = 0.0;
			const uint samples = 8;

			for (uint i = 1; i <= samples; ++i) {
				immut vec4 sample_pos = view + vec4(0.0, 0.0, 0.0, 0.1 / (i * random));

				ray += texture(shadowtex1, distort((gbuffer_model_view_to_shadow_projection * (sample_pos / sample_pos.w)).xyz) * 0.5 + 0.5);
			}

			float brightness = 0.001 * VL_BASE / samples;

			#if VL_SUN || VL_SKY
				immut float closeness = max(0.0, dot(normalize(view.xyz), normalize(shadowLightPosition)));

				brightness += (0.005 * VL_SUN * pow(closeness, 64) + 0.0005 * VL_SKY * pow(closeness, 2));
			#endif

			color = pow(color, vec3(2.4));
			color += brightness * ray * mix(vec3(1.0), fog_color * 5.0, isEyeInWater * 0.1) * light_color;
			color = pow(color, vec3(1.0 / 2.4));
		}
	}

	outColor0 = color;
}