#include "/lib/core.glsl"

/* RENDERTARGETS: 0 */
layout(location = 0) out vec4 outColor0;

uniform sampler2D gtexture;

#ifndef TRANSLUCENT
	uniform float alphaTestRef;
#endif

in VertexData {
	vec2 coord;
	vec3 color;
} vsh;

void main() {
	immut vec4 color = texture(gtexture, vsh.coord);

	#ifndef TRANSLUCENT
		if (color.a < alphaTestRef) discard;
	#endif

	outColor0 = vec4(color.rgb * vsh.color, color.a);
}