#include "/lib/core.glsl"

#include "/lib/config.glsl"

/* RENDERTARGETS: 0 */
layout(location = 0) out vec4 outColor0;

uniform int renderStage;
uniform vec3 fogColor, skyColor, sunPosition, moonPosition;
uniform mat4 gbufferModelView;

in VertexData {
	vec3 pos, color;
} vsh;

void main() {
	immut vec3 n_view = normalize(vsh.pos);

	immut float height = max(dot(n_view, gbufferModelView[1].xyz), 0.0);
	immut float fog = 0.25 / (height * height + 0.25);
	
	if (renderStage == MC_RENDER_STAGE_STARS) {
		outColor0 = vec4(vsh.color, 0.625 - fog * 0.5);
	} else {
		vec3 color = mix(skyColor, fogColor, fog);

		#if SUN_BLOOM || SKY_BLOOM
			immut float closeness = max(0.0, dot(n_view, normalize(sunPosition))) + max(0.0, dot(n_view, normalize(moonPosition)));

			color += 0.1 * (SUN_BLOOM * pow(closeness, 64) + SKY_BLOOM * pow(closeness, 2));
		#endif

		outColor0 = vec4(color, 1.0);

		// Fixes fog (fix it properly in other places to match the above instead)
		/*
		vec3 sky = skyColor;

		#if SUN_BLOOM || SKY_BLOOM
			immut float closeness = max(0.0, dot(n_view, normalize(sunPosition))) + max(0.0, dot(n_view, normalize(moonPosition)));

			sky += 0.1 * (SUN_BLOOM * pow(closeness, 64) + SKY_BLOOM * pow(closeness, 2));
		#endif

		outColor0 = vec4(mix(sky, fogColor, fog), 1.0);
		*/
	}
}