#include "/lib/core.glsl"

#include "/lib/config.glsl"

/* RENDERTARGETS: 0 */
layout(location = 0) out vec3 outColor0;

uniform float alphaTestRef;
uniform sampler2D gtexture;

in VertexData {
	float fog;
	vec2 coord;
	vec3 color;
} vsh;

#define SUPPORTS_TS
#include "/lib/frag_light.glsl"

void main() {
	immut vec4 rawColor = texture(gtexture, vsh.coord);
	if (rawColor.a < alphaTestRef) discard;

	outColor0 = mix(rawColor.rgb * vsh.color * pow(getLighting(), vec3(1.0 / 2.4)), fogColor, vsh.fog);
}