#include "/lib/core.glsl"

#include "/lib/config.glsl"

layout(early_fragment_tests) in;

/* RENDERTARGETS: 0 */
layout(location = 0) out vec4 outColor0;

uniform sampler2D gtexture;

in VertexData {
	float fog;
	vec2 coord;
	vec4 color;
} vsh;

#include "/lib/frag_light.glsl"

void main() {
	immut vec4 color = texture(gtexture, vsh.coord) * vsh.color;

	outColor0 = vec4(mix(color.rgb * pow(getLighting(), vec3(1.0 / 2.4)), fogColor, vsh.fog), color.a);
}