uniform int worldTime;
uniform float rainStrength;
uniform vec3 fogColor, skyColor;
uniform sampler2D noisetex, shadowcolor0, shadowtex0;
uniform sampler2DShadow shadowtex1;

in ShadowData {
	float diffuse, dist;
	vec3 pos;
} shadow;

vec3 getLighting() {
	const float ambient = AMBIENT * 0.05;

	// maybe avoid distance() here
	immut float daylight = min(distance(worldTime, 6000.0), 30000.0 - worldTime) / 12000.0;
	immut vec3 light_color = mix(pow(fogColor, vec3(2.4)), max(1.1 - pow(skyColor, vec3(2.4)) - smoothstep(0.4, 0.6, daylight), 0.0), min(daylight + 0.1, 1.0 - rainStrength * 0.9));

	// Skip shadows when the contrast between sunlight and ambient light is too low
	if (shadow.dist < 1.0 && length(light_color) * (10.0 + SUNLIGHT - AMBIENT) > 2.5) {
		#ifdef TRANSLUCENT_SHADOWS
		#endif

		#if !defined TRANSLUCENT_SHADOWS || !defined SUPPORTS_TS
			if (shadow.diffuse < 0.0) return ambient.rrr;
		#endif

		const vec2[9] offsets = vec2[9](
			vec2(0.0, 0.0),
			vec2(0.0, 1.0),
			vec2(0.7, 0.7),
			vec2(1.0, 0.0),
			vec2(0.7,-0.7),
			vec2(0.0,-1.0),
			vec2(-0.7,-0.7),
			vec2(-1.0, 0.0),
			vec2(-0.7, 0.7)
		);

		#if SHADOW_BLUR_QUALITY == 0
			const vec2[9] shadow_offsets = offsets;
		#elif SHADOW_BLUR_QUALITY == 1
			const vec2[28] shadow_offsets = vec2[28](
				vec2(-0.533756, 0.5918049),
				vec2(-0.5887652, 0.2827983),
				vec2(-0.1112829, 0.8347653),
				vec2(-0.1763154, 0.4841528),
				vec2(0.14189, 0.3237082),
				vec2(0.2800929, 0.9120663),
				vec2(0.1093863, 0.6212762),
				vec2(-0.9064262, -0.1183883),
				vec2(-0.6078327, -0.178559),
				vec2(-0.357408, 0.1051248),
				vec2(0.6527902, 0.5192569),
				vec2(0.09694252, 0.03230363),
				vec2(-0.674222, -0.7260616),
				vec2(-0.2918845, -0.4964681),
				vec2(-0.7958741, -0.4429268),
				vec2(-0.1453472, -0.204167),
				vec2(0.4898141, 0.1773323),
				vec2(0.9270607, 0.3427289),
				vec2(0.2821047, -0.2190978),
				vec2(-0.8921345, 0.221567),
				vec2(0.7761434, -0.4868898),
				vec2(0.7591619, -0.1604567),
				vec2(0.2184547, -0.7292697),
				vec2(-0.33626, -0.8815288),
				vec2(-0.8542173, 0.5196956),
				vec2(0.03850133, -0.9906212),
				vec2(0.5087105, -0.7317122),
				vec2(0.08914156, -0.438681)
			);
		#else
			const vec2[64] shadow_offsets = vec2[64](
				vec2(0.3834438, -0.8365879),
				vec2(0.2538637, -0.589553),
				vec2(0.6399639, -0.6070346),
				vec2(0.1431894, -0.8152663),
				vec2(0.5930731, -0.7948953),
				vec2(0.6914624, -0.3480401),
				vec2(0.4279022, -0.4768359),
				vec2(0.8242062, -0.508942),
				vec2(0.01053669, -0.4866286),
				vec2(-0.1108985, -0.7414401),
				vec2(0.03328848, -0.9812139),
				vec2(-0.2678958, -0.3206359),
				vec2(0.25712, -0.229964),
				vec2(-0.02783006, -0.2600488),
				vec2(-0.2917352, -0.6411636),
				vec2(-0.4032183, -0.8573055),
				vec2(-0.6612689, -0.7354062),
				vec2(-0.5676314, -0.5411444),
				vec2(-0.2168807, -0.9072415),
				vec2(-0.5580572, -0.09704394),
				vec2(-0.5138885, -0.3027371),
				vec2(-0.1932104, -0.09702744),
				vec2(-0.3822881, -0.01384046),
				vec2(0.8748599, -0.1630837),
				vec2(-0.522255, 0.2585554),
				vec2(-0.749154, -0.08459146),
				vec2(-0.749154, -0.08459146),
				vec2(-0.6647733, 0.129063),
				vec2(-0.8998289, -0.2349087),
				vec2(-0.8098084, -0.5461301),
				vec2(0.5121568, 0.00675085),
				vec2(0.1070659, -0.05260961),
				vec2(0.3009415, 0.1365128),
				vec2(0.5151741, -0.1867349),
				vec2(-0.9284627, -0.007728597),
				vec2(-0.2198475, 0.3018067),
				vec2(-0.07589716, 0.09244914),
				vec2(0.721417, 0.01370876),
				vec2(0.6517887, 0.1998482),
				vec2(0.4209776, 0.3226621),
				vec2(0.9295521, 0.1595292),
				vec2(0.8101555, 0.3356059),
				vec2(0.6216043, 0.4737987),
				vec2(-0.7957394, 0.4460461),
				vec2(-0.578917, 0.5065681),
				vec2(-0.3760341, 0.4722787),
				vec2(0.1558616, 0.3765588),
				vec2(0.4568439, 0.655364),
				vec2(0.08923677, 0.1941438),
				vec2(0.1930917, 0.5782562),
				vec2(-0.07713082, 0.5275764),
				vec2(0.4766026, 0.8639814),
				vec2(-0.7173501, 0.6784452),
				vec2(-0.8751968, 0.2121847),
				vec2(0.8041916, 0.5765353),
				vec2(0.2870654, 0.9436792),
				vec2(0.6502987, 0.7152798),
				vec2(-0.2637711, 0.7050315),
				vec2(-0.03864802, 0.7925433),
				vec2(-0.1051485, 0.9776039),
				vec2(-0.3079708, 0.9433341),
				vec2(-0.5206522, 0.6986488),
				vec2(0.08988898, 0.9506541),
				vec2(0.2821491, 0.7465457)
			);
		#endif

		immut float noise = texture(noisetex, gl_FragCoord.xy / noiseTextureResolution).r;

		immut float noise_cos = cos(noise);
		immut float noise_sin = sin(noise);

		mat2 rotation = mat2(
			noise_cos, -noise_sin,
			noise_sin, noise_cos
		);

		#if VARIABLE_PENUMBRA_SHADOWS
			const mat2 scaled_rotation = rotation * 0.01;

			float blocker;
			const uint pcss_samples = offsets.length();

			for(uint i = 0; i < pcss_samples; ++i) {
				blocker += texture(shadowtex0, scaled_rotation * offsets[i] + shadow.pos.xy).r;
			}

			immut float penumbra = max((shadow.pos.z - blocker / pcss_samples) * VARIABLE_PENUMBRA_SHADOWS * 0.25, MIN_PENUMBRA);
		#else
			const float penumbra = MIN_PENUMBRA;
		#endif

		vec3 sum;

		const uint samples = shadow_offsets.length();

		rotation *= penumbra / samples;

		for(uint i = 0; i < samples; ++i) {
			immut vec2 offset_xy = rotation * shadow_offsets[i] + shadow.pos.xy;
			immut float light = texture(shadowtex1, vec3(offset_xy, shadow.pos.z));

			// what does bool(float) do for negative values?
			// should we use it everywhere instead of float > 0.0 ?
			if (bool(light)) sum += texture(shadowcolor0, offset_xy).rgb * light;
		}

		vec3 sunlight = SUNLIGHT * light_color * mix(sum / samples, vec3(1.0), clamp((shadow.dist - 1.0) / SHADOW_FADE_DIST + 1.0, 0.0, 1.0));

		#if defined TRANSLUCENT_SHADOWS && defined SUPPORTS_TS
			immut float sd = sign(shadow.diffuse);
			sunlight *= (max(sd, 0.0) * 0.09 + 0.01) * sd;
		#else
			sunlight *= 0.1;
		#endif

		return sunlight * min(shadow.diffuse, float(sunlight)) + ambient;
	} else if (shadow.diffuse > 0.0) {
		immut vec3 sunlight = vec3(SUNLIGHT * 0.1) * light_color;

		return sunlight * min(shadow.diffuse, float(sunlight)) + ambient;
	} else return ambient.rrr;
}