#include "/lib/core.glsl"

#include "/lib/config.glsl"

#ifdef PLAYER_SHADOWS
#endif
#ifdef ENTITY_SHADOWS
#endif
#ifdef BLOCK_ENTITY_SHADOWS
#endif

/*
	const bool shadowcolor0Clear = false;
	const bool shadowHardwareFiltering1 = true;
	const int shadowcolor0Format = RGB8;
*/

/* RENDERTARGETS: 0 */
layout(location = 0) out vec3 outColor0;

uniform float alphaTestRef;
uniform sampler2D gtexture;

in VertexData {
	vec2 coord;
	vec4 color;
} vsh;

void main() {
	vec4 color = textureLod(gtexture, vsh.coord, 0.0);
	if (color.a < alphaTestRef) discard;

	color *= vsh.color;

	outColor0 = mix(vec3(1.0), pow(color.rgb, vec3(2.4)), color.a - 10.0 * max(0.0, color.a - 0.9));
}