#include "/lib/core.glsl"

/* RENDERTARGETS: 0 */

#ifdef TRANSLUCENT
	layout(location = 0) out vec4 outColor0;
#else
	layout(location = 0) out vec3 outColor0;
#endif

uniform vec3 fogColor;
uniform sampler2D gtexture;

#ifdef CUTOUT
	uniform float alphaTestRef;
#endif

in VertexData {
	float fog;
	vec2 coord;

	#ifdef TRANSLUCENT
		vec4 color;
	#else
		vec3 color;
	#endif
} vsh;

void main() {
	#ifdef TRANSLUCENT
		vec4 color = texture(gtexture, vsh.coord);
	#elif defined CUTOUT
		immut vec4 raw_color = texture(gtexture, vsh.coord);
		if (raw_color.a < alphaTestRef) discard;

		vec3 color = raw_color.rgb;
	#else
		vec3 color = texture(gtexture, vsh.coord).rgb;
	#endif

	color *= vsh.color;

	color.rgb = mix(color.rgb, fogColor, vsh.fog);

	outColor0 = color;
}