#include "/lib/core.glsl"

#include "/lib/config.glsl"
#include "/lib/lightmap.glsl"

uniform int isEyeInWater;
uniform float blindness, far;
uniform vec3 chunkOffset;
uniform mat4 modelViewMatrix, projectionMatrix;

in vec2 vaUV0;
in vec3 vaPosition;
in vec4 vaColor;

#ifndef ENTITY
	in vec4 at_midBlock, mc_Entity;
#elif defined COLORED
	uniform vec4 entityColor;
#endif

out VertexData {
	float fog;
	vec2 coord;

	#ifdef TRANSLUCENT
		vec4 color;
	#else
		vec3 color;
	#endif
} fsh;

void main() {
	#ifdef TRANSLUCENT
		vec4 color = vaColor;
	#else
		vec3 color = vaColor.rgb;
	#endif

	immut vec4 view = modelViewMatrix * vec4(vaPosition + chunkOffset, 1.0);
	gl_Position = projectionMatrix * view;

	vec3 light = texture(lightmap, lm_coord).rgb;

	#ifndef ENTITY
		light = mix(light, vec3(1.0), clamp((mc_Entity.r - 1.0 + at_midBlock.w) / 15.0, 0.0, 1.0));
	#elif defined COLORED
		color.rgb = mix(color.rgb, entityColor.rgb, entityColor.a);
	#endif

	color.rgb *= mix(AMBIENT * 0.05 * vec3(1.0, 0.6, 0.76), light * 1.5, float(light) - 0.75);

	fsh.coord = vaUV0;
	fsh.color = color;
	fsh.fog = min(pow(length(view.xyz) / far, 10.0 / (FOG + blindness * 5000.0 + pow(isEyeInWater, 4.0) * WATER_FOG)), 1.0);
}