/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.blay09.mods.waystones.api.MutableWaystone;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystoneOrigin;
import net.blay09.mods.waystones.api.WaystoneTypes;
import net.blay09.mods.waystones.api.WaystoneVisibility;
import net.blay09.mods.waystones.tag.ModBlockTags;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8824;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class WaystoneImpl
implements Waystone,
MutableWaystone {
    public static final class_9139<class_9129, Waystone> STREAM_CODEC = class_9139.method_56437(WaystoneImpl::write, WaystoneImpl::read);
    public static final class_9139<class_9129, Collection<Waystone>> LIST_STREAM_CODEC = STREAM_CODEC.method_56433(class_9135.method_56374(ArrayList::new));
    private final class_2960 waystoneType;
    private final UUID waystoneUid;
    private final WaystoneOrigin origin;
    private class_5321<class_1937> dimension;
    private class_2338 pos;
    private class_2561 name = class_2561.method_43473();
    private WaystoneVisibility visibility;
    private UUID ownerUid;

    public WaystoneImpl(class_2960 waystoneType, UUID waystoneUid, class_5321<class_1937> dimension, class_2338 pos, WaystoneOrigin origin, @Nullable UUID ownerUid) {
        this.waystoneType = waystoneType;
        this.waystoneUid = waystoneUid;
        this.dimension = dimension;
        this.pos = pos;
        this.origin = origin;
        this.ownerUid = ownerUid;
        this.visibility = WaystoneVisibility.fromWaystoneType(waystoneType);
    }

    @Override
    public UUID getWaystoneUid() {
        return this.waystoneUid;
    }

    @Override
    public class_2561 getName() {
        return this.name;
    }

    @Override
    public void setName(class_2561 name) {
        this.name = name;
    }

    @Override
    public class_5321<class_1937> getDimension() {
        return this.dimension;
    }

    @Override
    public WaystoneOrigin getOrigin() {
        return this.origin;
    }

    @Override
    public WaystoneVisibility getVisibility() {
        return this.visibility;
    }

    @Override
    public void setVisibility(WaystoneVisibility visibility) {
        this.visibility = visibility;
    }

    @Override
    public boolean isOwner(class_1657 player) {
        return this.ownerUid == null || player.method_7334().getId().equals(this.ownerUid) || player.method_31549().field_7477;
    }

    @Override
    public void setOwnerUid(@Nullable UUID ownerUid) {
        this.ownerUid = ownerUid;
    }

    @Override
    public class_2338 getPos() {
        return this.pos;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public UUID getOwnerUid() {
        return this.ownerUid;
    }

    @Override
    public void setDimension(class_5321<class_1937> dimension) {
        this.dimension = dimension;
    }

    @Override
    public void setPos(class_2338 pos) {
        this.pos = pos;
    }

    @Override
    public class_2960 getWaystoneType() {
        return this.waystoneType;
    }

    @Override
    public boolean isValidInLevel(class_3218 level) {
        class_2680 state = level.method_8320(this.pos);
        return state.method_26164(ModBlockTags.IS_TELEPORT_TARGET);
    }

    public static List<Waystone> readList(class_9129 buf) {
        int size = buf.readShort();
        ArrayList<Waystone> waystones = new ArrayList<Waystone>(size);
        for (int i = 0; i < size; ++i) {
            waystones.add(WaystoneImpl.read(buf));
        }
        return waystones;
    }

    public static Waystone read(class_9129 buf) {
        UUID waystoneUid = buf.method_10790();
        class_2960 waystoneType = buf.method_10810();
        class_2561 name = (class_2561)class_8824.field_48540.decode((Object)buf);
        WaystoneVisibility visibility = (WaystoneVisibility)buf.method_10818(WaystoneVisibility.class);
        class_5321 dimension = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60654((String)buf.method_10800(250)));
        class_2338 pos = buf.method_10811();
        WaystoneOrigin origin = (WaystoneOrigin)buf.method_10818(WaystoneOrigin.class);
        WaystoneImpl waystone = new WaystoneImpl(waystoneType, waystoneUid, (class_5321<class_1937>)dimension, pos, origin, null);
        waystone.setName(name);
        waystone.setVisibility(visibility);
        return waystone;
    }

    private static class_2338 readLegacyBlockPos(class_2487 compound) {
        return new class_2338(compound.method_10550("X"), compound.method_10550("Y"), compound.method_10550("Z"));
    }

    public static Waystone read(class_2487 compound, class_7225.class_7874 provider) {
        WaystoneOrigin origin;
        UUID waystoneUid = class_2512.method_25930((class_2520)Objects.requireNonNull(compound.method_10580("WaystoneUid")));
        String legacyName = compound.method_10558("Name");
        class_5250 name = compound.method_10545("NameV2") ? class_2561.class_2562.method_10877((String)compound.method_10558("NameV2"), (class_7225.class_7874)provider) : class_2561.method_43470((String)legacyName);
        class_5321 dimensionType = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60654((String)compound.method_10558("World")));
        class_2338 pos = class_2512.method_10691((class_2487)compound, (String)"BlockPos").orElseGet(() -> WaystoneImpl.readLegacyBlockPos(compound.method_10562("BlockPos")));
        boolean legacyWasGenerated = compound.method_10577("WasGenerated");
        WaystoneOrigin waystoneOrigin = origin = legacyWasGenerated ? WaystoneOrigin.WILDERNESS : WaystoneOrigin.UNKNOWN;
        if (compound.method_10545("Origin")) {
            try {
                origin = WaystoneOrigin.valueOf(compound.method_10558("Origin"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        UUID ownerUid = compound.method_10545("OwnerUid") ? class_2512.method_25930((class_2520)Objects.requireNonNull(compound.method_10580("OwnerUid"))) : null;
        class_2960 waystoneType = compound.method_10545("Type") ? class_2960.method_60654((String)compound.method_10558("Type")) : WaystoneTypes.WAYSTONE;
        WaystoneImpl waystone = new WaystoneImpl(waystoneType, waystoneUid, (class_5321<class_1937>)dimensionType, pos, origin, ownerUid);
        waystone.setName((class_2561)name);
        if (compound.method_10545("Visibility")) {
            waystone.setVisibility(WaystoneVisibility.valueOf(compound.method_10558("Visibility")));
        } else {
            waystone.setVisibility(compound.method_10577("IsGlobal") ? WaystoneVisibility.GLOBAL : WaystoneVisibility.ACTIVATION);
        }
        return waystone;
    }

    public static void writeList(class_9129 buf, Collection<Waystone> waystones) {
        buf.method_52998(waystones.size());
        for (Waystone waystone : waystones) {
            WaystoneImpl.write(buf, waystone);
        }
    }

    public static void write(class_9129 buf, Waystone waystone) {
        buf.method_10797(waystone.getWaystoneUid());
        buf.method_10812(waystone.getWaystoneType());
        class_8824.field_48540.encode((Object)buf, (Object)waystone.getName());
        buf.method_10817((Enum)waystone.getVisibility());
        buf.method_10812(waystone.getDimension().method_29177());
        buf.method_10807(waystone.getPos());
        buf.method_10817((Enum)waystone.getOrigin());
    }

    public static class_2487 write(Waystone waystone, class_2487 compound, class_7225.class_7874 provider) {
        compound.method_10566("WaystoneUid", (class_2520)class_2512.method_25929((UUID)waystone.getWaystoneUid()));
        compound.method_10582("Type", waystone.getWaystoneType().toString());
        compound.method_10582("NameV2", class_2561.class_2562.method_10867((class_2561)waystone.getName(), (class_7225.class_7874)provider));
        compound.method_10582("World", waystone.getDimension().method_29177().toString());
        compound.method_10566("BlockPos", class_2512.method_10692((class_2338)waystone.getPos()));
        compound.method_10582("Origin", waystone.getOrigin().name());
        if (waystone.getOwnerUid() != null) {
            compound.method_10566("OwnerUid", (class_2520)class_2512.method_25929((UUID)waystone.getOwnerUid()));
        }
        compound.method_10582("Visibility", waystone.getVisibility().name());
        return compound;
    }
}

