/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.compile;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import me.jellysquid.mods.sodium.client.gl.util.VertexRange;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.render.chunk.compile.buffers.BakedChunkModelBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.data.BuiltSectionInfo;
import me.jellysquid.mods.sodium.client.render.chunk.data.BuiltSectionMeshParts;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.DefaultTerrainRenderPasses;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.TerrainRenderPass;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.material.Material;
import me.jellysquid.mods.sodium.client.render.chunk.vertex.builder.ChunkMeshBufferBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.vertex.format.ChunkVertexType;
import me.jellysquid.mods.sodium.client.util.NativeBuffer;

public class ChunkBuildBuffers {
    private final Reference2ReferenceOpenHashMap<TerrainRenderPass, BakedChunkModelBuilder> builders = new Reference2ReferenceOpenHashMap();
    private final ChunkVertexType vertexType;

    public ChunkBuildBuffers(ChunkVertexType vertexType) {
        this.vertexType = vertexType;
        for (TerrainRenderPass pass : DefaultTerrainRenderPasses.ALL) {
            ChunkMeshBufferBuilder[] vertexBuffers = new ChunkMeshBufferBuilder[ModelQuadFacing.COUNT];
            for (int facing = 0; facing < ModelQuadFacing.COUNT; ++facing) {
                vertexBuffers[facing] = new ChunkMeshBufferBuilder(this.vertexType, 131072);
            }
            this.builders.put((Object)pass, (Object)new BakedChunkModelBuilder(vertexBuffers));
        }
    }

    public void init(BuiltSectionInfo.Builder renderData, int sectionIndex) {
        for (BakedChunkModelBuilder builder : this.builders.values()) {
            builder.begin(renderData, sectionIndex);
        }
    }

    public ChunkModelBuilder get(Material material) {
        return (ChunkModelBuilder)this.builders.get((Object)material.pass);
    }

    public BuiltSectionMeshParts createMesh(TerrainRenderPass pass) {
        BakedChunkModelBuilder builder = (BakedChunkModelBuilder)this.builders.get((Object)pass);
        ArrayList<ByteBuffer> vertexBuffers = new ArrayList<ByteBuffer>();
        VertexRange[] vertexRanges = new VertexRange[ModelQuadFacing.COUNT];
        int vertexCount = 0;
        for (ModelQuadFacing facing : ModelQuadFacing.VALUES) {
            ChunkMeshBufferBuilder buffer = builder.getVertexBuffer(facing);
            if (buffer.isEmpty()) continue;
            vertexBuffers.add(buffer.slice());
            vertexRanges[facing.ordinal()] = new VertexRange(vertexCount, buffer.count());
            vertexCount += buffer.count();
        }
        if (vertexCount == 0) {
            return null;
        }
        NativeBuffer mergedBuffer = new NativeBuffer(vertexCount * this.vertexType.getVertexFormat().getStride());
        ByteBuffer mergedBufferBuilder = mergedBuffer.getDirectBuffer();
        for (ByteBuffer buffer : vertexBuffers) {
            mergedBufferBuilder.put(buffer);
        }
        mergedBufferBuilder.flip();
        return new BuiltSectionMeshParts(mergedBuffer, vertexRanges);
    }

    public void destroy() {
        for (BakedChunkModelBuilder builder : this.builders.values()) {
            builder.destroy();
        }
    }
}

