/*
 * Decompiled with CFR 0.152.
 */
package draylar.goml;

import com.jamieswhiteshirt.rtree3i.Entry;
import com.jamieswhiteshirt.rtree3i.Selection;
import draylar.goml.GetOffMyLawn;
import draylar.goml.api.Augment;
import draylar.goml.api.Claim;
import draylar.goml.api.ClaimBox;
import draylar.goml.api.ClaimUtils;
import draylar.goml.api.PermissionReason;
import draylar.goml.api.event.ClaimEvents;
import draylar.goml.block.SelectiveClaimAugmentBlock;
import draylar.goml.block.entity.ClaimAnchorBlockEntity;
import draylar.goml.other.StatusEnum;
import draylar.goml.registry.GOMLBlocks;
import draylar.goml.registry.GOMLTags;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_4538;
import net.minecraft.class_6025;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class EventHandlers {
    public static final class_2960 GOML_PHASE = GetOffMyLawn.id("protection");

    private EventHandlers() {
    }

    public static void init() {
        for (Event x : new Event[]{UseEntityCallback.EVENT, AttackEntityCallback.EVENT, UseBlockCallback.EVENT, PlayerBlockBreakEvents.BEFORE, AttackBlockCallback.EVENT}) {
            x.addPhaseOrdering(GOML_PHASE, Event.DEFAULT_PHASE);
        }
        EventHandlers.registerBreakBlockCallback();
        EventHandlers.registerInteractBlockCallback();
        EventHandlers.registerAttackEntityCallback();
        EventHandlers.registerInteractEntityCallback();
        EventHandlers.registerAnchorAttackCallback();
    }

    private static void registerInteractEntityCallback() {
        UseEntityCallback.EVENT.register(GOML_PHASE, (playerEntity, world, hand, entity, entityHitResult) -> {
            class_6025 tameable;
            if (ClaimUtils.isInAdminMode(playerEntity)) {
                return class_1269.field_5811;
            }
            if (GetOffMyLawn.CONFIG.canInteract(entity) || entity.method_5864().method_20210(GOMLTags.ALLOWED_INTERACTIONS_ENTITY)) {
                return class_1269.field_5811;
            }
            if (entity instanceof class_6025 && (tameable = (class_6025)entity).method_35057() == playerEntity) {
                return class_1269.field_5811;
            }
            if (entity instanceof class_1657) {
                class_1657 attackedPlayer = (class_1657)entity;
                Selection claims = ClaimUtils.getClaimsAt((class_4538)world, entity.method_24515());
                if (claims.isEmpty()) {
                    return class_1269.field_5811;
                }
                if ((claims = claims.filter(e -> ((Claim)e.getValue()).hasAugment((Augment)GOMLBlocks.PVP_ARENA.getFirst()))).isEmpty()) {
                    return GetOffMyLawn.CONFIG.enablePvPinClaims ? class_1269.field_5811 : class_1269.field_5814;
                }
                MutableObject obj = new MutableObject((Object)class_1269.field_5811);
                claims.forEach(e -> {
                    if (obj.getValue() == class_1269.field_5814) {
                        return;
                    }
                    Claim claim = (Claim)e.getValue();
                    obj.setValue((Object)(switch (claim.getData(((SelectiveClaimAugmentBlock)GOMLBlocks.PVP_ARENA.getFirst()).key)) {
                        default -> throw new MatchException(null, null);
                        case StatusEnum.TargetPlayer.EVERYONE -> class_1269.field_5811;
                        case StatusEnum.TargetPlayer.DISABLED -> class_1269.field_5814;
                        case StatusEnum.TargetPlayer.TRUSTED -> {
                            if (claim.hasPermission(playerEntity) && claim.hasPermission(attackedPlayer)) {
                                yield class_1269.field_5811;
                            }
                            yield class_1269.field_5814;
                        }
                        case StatusEnum.TargetPlayer.UNTRUSTED -> !claim.hasPermission(playerEntity) && !claim.hasPermission(attackedPlayer) ? class_1269.field_5811 : class_1269.field_5814;
                    }));
                });
                return (class_1269)obj.getValue();
            }
            Selection<Entry<ClaimBox, Claim>> claimsFound = ClaimUtils.getClaimsAt((class_4538)world, entity.method_24515());
            return EventHandlers.testPermission(claimsFound, playerEntity, hand, entity.method_24515(), PermissionReason.ENTITY_PROTECTED);
        });
    }

    private static void registerAttackEntityCallback() {
        AttackEntityCallback.EVENT.register(GOML_PHASE, (playerEntity, world, hand, entity, entityHitResult) -> ClaimUtils.canDamageEntity(world, entity, world.method_48963().method_48802(playerEntity)) ? class_1269.field_5811 : class_1269.field_5814);
    }

    private static void registerInteractBlockCallback() {
        UseBlockCallback.EVENT.register(GOML_PHASE, (playerEntity, world, hand, blockHitResult) -> {
            class_2680 blockState;
            if (!(playerEntity.method_5998(hand).method_7909() instanceof class_1747) && (GetOffMyLawn.CONFIG.canInteract((blockState = world.method_8320(blockHitResult.method_17777())).method_26204()) || blockState.method_26164(GOMLTags.ALLOWED_INTERACTIONS_BLOCKS))) {
                return class_1269.field_5811;
            }
            Selection<Entry<ClaimBox, Claim>> claimsFound = ClaimUtils.getClaimsAt((class_4538)world, blockHitResult.method_17777());
            class_1269 ac = EventHandlers.testPermission(claimsFound, playerEntity, hand, blockHitResult.method_17777(), PermissionReason.AREA_PROTECTED);
            if (ac == class_1269.field_5811) {
                Selection<Entry<ClaimBox, Claim>> claimsFound2 = ClaimUtils.getClaimsAt((class_4538)world, blockHitResult.method_17777().method_10093(blockHitResult.method_17780()));
                return EventHandlers.testPermission(claimsFound2, playerEntity, hand, blockHitResult.method_17777().method_10093(blockHitResult.method_17780()), PermissionReason.AREA_PROTECTED);
            }
            return ac;
        });
    }

    private static void registerBreakBlockCallback() {
        AttackBlockCallback.EVENT.register(GOML_PHASE, (playerEntity, world, hand, blockPos, direction) -> {
            Selection<Entry<ClaimBox, Claim>> claimsFound = ClaimUtils.getClaimsAt((class_4538)world, blockPos);
            return EventHandlers.testPermission(claimsFound, playerEntity, hand, blockPos, PermissionReason.BLOCK_PROTECTED);
        });
        PlayerBlockBreakEvents.BEFORE.register(GOML_PHASE, (world, player, pos, state, blockEntity) -> {
            Selection<Entry<ClaimBox, Claim>> claimsFound = ClaimUtils.getClaimsAt((class_4538)world, pos);
            class_1269 result = EventHandlers.testPermission(claimsFound, player, class_1268.field_5808, pos, PermissionReason.BLOCK_PROTECTED);
            return !result.equals((Object)class_1269.field_5814);
        });
    }

    private static void registerAnchorAttackCallback() {
        AttackBlockCallback.EVENT.register(GOML_PHASE, (playerEntity, world, hand, blockPos, direction) -> {
            class_2586 be = world.method_8321(blockPos);
            if (be instanceof ClaimAnchorBlockEntity && !((ClaimAnchorBlockEntity)be).getClaim().isOwner(playerEntity) && !ClaimUtils.isInAdminMode(playerEntity)) {
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        });
    }

    @ApiStatus.Internal
    public static class_1269 testPermission(Selection<Entry<ClaimBox, Claim>> claims, class_1657 player, class_1268 hand, class_2338 pos, PermissionReason reason) {
        class_1269 check;
        boolean noPermission;
        if (!claims.isEmpty() && (noPermission = claims.anyMatch(boxInfo -> !((Claim)boxInfo.getValue()).hasPermission(player))) && !ClaimUtils.isInAdminMode(player) && ((check = ((ClaimEvents.InteractionHandler)ClaimEvents.PERMISSION_DENIED.invoker()).check(player, player.method_37908(), hand, pos, reason)).method_23665() || check.equals((Object)class_1269.field_5811))) {
            player.method_7353(reason.getReason(), true);
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }
}

