/*
 * Decompiled with CFR 0.152.
 */
package draylar.goml.api;

import com.jamieswhiteshirt.rtree3i.Box;
import com.jamieswhiteshirt.rtree3i.Entry;
import com.jamieswhiteshirt.rtree3i.Selection;
import com.mojang.authlib.GameProfile;
import draylar.goml.EventHandlers;
import draylar.goml.GetOffMyLawn;
import draylar.goml.api.Augment;
import draylar.goml.api.Claim;
import draylar.goml.api.ClaimBox;
import draylar.goml.api.PermissionReason;
import draylar.goml.api.event.ClaimEvents;
import draylar.goml.block.SelectiveClaimAugmentBlock;
import draylar.goml.block.augment.ExplosionControllerAugmentBlock;
import draylar.goml.block.entity.ClaimAnchorBlockEntity;
import draylar.goml.cca.ClaimComponent;
import draylar.goml.other.GomlPlayer;
import draylar.goml.other.OriginOwner;
import draylar.goml.other.StatusEnum;
import draylar.goml.registry.GOMLBlocks;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1295;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_4076;
import net.minecraft.class_4538;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;

public class ClaimUtils {
    public static Selection<Entry<ClaimBox, Claim>> getClaimsAt(class_4538 world, class_2338 pos) {
        Box checkBox = Box.create((int)pos.method_10263(), (int)pos.method_10264(), (int)pos.method_10260(), (int)(pos.method_10263() + 1), (int)(pos.method_10264() + 1), (int)(pos.method_10260() + 1));
        return ((ClaimComponent)GetOffMyLawn.CLAIM.get((Object)world)).getClaims().entries(box -> box.contains(checkBox));
    }

    public static Selection<Entry<ClaimBox, Claim>> getClaimsWithOrigin(class_4538 world, class_2338 pos) {
        return ((ClaimComponent)GetOffMyLawn.CLAIM.get((Object)world)).getClaims().entries().filter(x -> ((Claim)x.getValue()).getOrigin().equals((Object)pos));
    }

    public static Selection<Entry<ClaimBox, Claim>> getClaimsOwnedBy(class_4538 world, UUID player) {
        return ((ClaimComponent)GetOffMyLawn.CLAIM.get((Object)world)).getClaims().entries().filter(entry -> ((Claim)entry.getValue()).isOwner(player));
    }

    public static Selection<Entry<ClaimBox, Claim>> getClaimsTrusted(class_4538 world, UUID player) {
        return ((ClaimComponent)GetOffMyLawn.CLAIM.get((Object)world)).getClaims().entries().filter(entry -> ((Claim)entry.getValue()).getTrusted().contains(player));
    }

    public static Selection<Entry<ClaimBox, Claim>> getClaimsWithAccess(class_4538 world, UUID player) {
        return ((ClaimComponent)GetOffMyLawn.CLAIM.get((Object)world)).getClaims().entries().filter(entry -> ((Claim)entry.getValue()).hasPermission(player));
    }

    public static Selection<Entry<ClaimBox, Claim>> getClaimsInBox(class_4538 world, class_2338 lower, class_2338 upper) {
        Box checkBox = ClaimUtils.createBox(lower, upper);
        return ClaimUtils.getClaimsInBox(world, checkBox);
    }

    public static Selection<Entry<ClaimBox, Claim>> getClaimsInBox(class_4538 world, Box checkBox) {
        return ((ClaimComponent)GetOffMyLawn.CLAIM.get((Object)world)).getClaims().entries(box -> box.intersectsClosed(checkBox));
    }

    public static Selection<Entry<ClaimBox, Claim>> getClaimsInOpenBox(class_4538 world, Box checkBox) {
        return ((ClaimComponent)GetOffMyLawn.CLAIM.get((Object)world)).getClaims().entries(box -> box.intersectsOpen(checkBox));
    }

    public static Box createBox(int x1, int y1, int z1, int x2, int y2, int z2) {
        return Box.create((int)Math.min(x1, x2), (int)Math.min(y1, y2), (int)Math.min(z1, z2), (int)Math.max(x1, x2), (int)Math.max(y1, y2), (int)Math.max(z1, z2));
    }

    public static Box createBox(class_2338 pos1, class_2338 pos2) {
        return Box.create((int)Math.min(pos1.method_10263(), pos2.method_10263()), (int)Math.min(pos1.method_10264(), pos2.method_10264()), (int)Math.min(pos1.method_10260(), pos2.method_10260()), (int)Math.max(pos1.method_10263(), pos2.method_10263()), (int)Math.max(pos1.method_10264(), pos2.method_10264()), (int)Math.max(pos1.method_10260(), pos2.method_10260()));
    }

    public static Selection<Entry<ClaimBox, Claim>> getClaimsInBox(class_4538 world, class_2338 lower, class_2338 upper, Box ignore) {
        Box checkBox = Box.create((int)lower.method_10263(), (int)lower.method_10264(), (int)lower.method_10260(), (int)upper.method_10263(), (int)upper.method_10264(), (int)upper.method_10260());
        return ((ClaimComponent)GetOffMyLawn.CLAIM.get((Object)world)).getClaims().entries(box -> box.intersectsClosed(checkBox) && !box.equals((Object)ignore));
    }

    public static Selection<Entry<ClaimBox, Claim>> getClaimsInBox(class_4538 world, Box checkBox, Box ignore) {
        return ((ClaimComponent)GetOffMyLawn.CLAIM.get((Object)world)).getClaims().entries(box -> box.intersectsClosed(checkBox) && !box.equals((Object)ignore));
    }

    public static boolean canDestroyClaimBlock(Entry<ClaimBox, Claim> claim, @Nullable class_1657 checkPlayer, class_2338 checkPos) {
        return (checkPlayer == null || ClaimUtils.playerHasPermission(claim, checkPlayer)) && ((Claim)claim.getValue()).getOrigin().equals((Object)checkPos);
    }

    public static boolean canModifyClaimAt(class_1937 world, class_2338 pos, Entry<ClaimBox, Claim> claim, class_1657 player) {
        return ((Claim)claim.getValue()).hasPermission(player) || ClaimUtils.isInAdminMode(player) || ((ClaimEvents.InteractionHandler)ClaimEvents.PERMISSION_DENIED.invoker()).check(player, world, class_1268.field_5808, pos, PermissionReason.AREA_PROTECTED) == class_1269.field_5812;
    }

    public static boolean isInAdminMode(class_1657 player) {
        GomlPlayer adminModePlayer;
        return Permissions.check((class_1297)player, (String)"goml.modify_others", (int)3) && player instanceof GomlPlayer && (adminModePlayer = (GomlPlayer)player).goml_getAdminMode();
    }

    public static boolean canFireDestroy(class_1937 world, class_2338 pos) {
        return ClaimUtils.getClaimsAt((class_4538)world, pos).isEmpty();
    }

    public static boolean canFluidFlow(class_1937 world, class_2338 cur, class_2338 dest) {
        Selection<Entry<ClaimBox, Claim>> claimsDest = ClaimUtils.getClaimsAt((class_4538)world, dest);
        Selection<Entry<ClaimBox, Claim>> claimsCur = ClaimUtils.getClaimsAt((class_4538)world, cur);
        return claimsDest.isEmpty() || claimsCur.anyMatch(x -> claimsCur.anyMatch(y -> x.equals(y)));
    }

    public static boolean canExplosionDestroy(class_1937 world, class_2338 pos, @Nullable class_1297 causingEntity) {
        class_1657 playerEntity;
        class_1308 creeperEntity;
        class_1309 class_13092;
        class_1657 playerEntity2;
        Selection<Entry<ClaimBox, Claim>> claimsFound = ClaimUtils.getClaimsAt((class_4538)world, pos);
        Object player = causingEntity instanceof class_1657 ? (playerEntity2 = (class_1657)causingEntity) : (!GetOffMyLawn.CONFIG.protectAgainstHostileExplosionsActivatedByTrustedPlayers && causingEntity instanceof class_1308 && (class_13092 = (creeperEntity = (class_1308)causingEntity).method_5968()) instanceof class_1657 ? (playerEntity = (class_1657)class_13092) : null);
        if (player != null && claimsFound.isNotEmpty()) {
            return !claimsFound.anyMatch(arg_0 -> ClaimUtils.lambda$canExplosionDestroy$11(world, pos, (class_1657)player, arg_0));
        }
        return claimsFound.isEmpty() || claimsFound.anyMatch(c -> {
            if (world.method_8503() != null && ((Claim)c.getValue()).hasAugment((Augment)GOMLBlocks.EXPLOSION_CONTROLLER.getFirst())) {
                return ((Claim)c.getValue()).getData(ExplosionControllerAugmentBlock.KEY) == StatusEnum.Toggle.DISABLED;
            }
            return false;
        });
    }

    public static boolean canDamageEntity(class_1937 world, class_1297 entity, class_1282 source) {
        class_1308 creeperEntity;
        class_1657 player;
        if (entity == source.method_5529()) {
            return true;
        }
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_1657) {
            class_1657 playerEntity;
            player = playerEntity = (class_1657)class_12972;
        } else if (!GetOffMyLawn.CONFIG.protectAgainstHostileExplosionsActivatedByTrustedPlayers && (class_12972 = source.method_5529()) instanceof class_1308 && (class_12972 = (creeperEntity = (class_1308)class_12972).method_5968()) instanceof class_1657) {
            class_1657 playerEntity;
            player = playerEntity = (class_1657)class_12972;
        } else {
            class_1676 projectileEntity;
            class_12972 = source.method_5529();
            if (class_12972 instanceof class_1676 && (class_12972 = (projectileEntity = (class_1676)class_12972).method_24921()) instanceof class_1657) {
                class_1657 playerEntity;
                player = playerEntity = (class_1657)class_12972;
            } else {
                class_1295 projectileEntity2;
                class_12972 = source.method_5529();
                if (class_12972 instanceof class_1295 && (class_12972 = (projectileEntity2 = (class_1295)class_12972).method_5601()) instanceof class_1657) {
                    class_1657 playerEntity;
                    player = playerEntity = (class_1657)class_12972;
                } else {
                    class_1321 projectileEntity3;
                    class_12972 = source.method_5529();
                    if (class_12972 instanceof class_1321 && (class_12972 = (projectileEntity3 = (class_1321)class_12972).method_35057()) instanceof class_1657) {
                        class_1657 playerEntity;
                        player = playerEntity = (class_1657)class_12972;
                    } else {
                        if (!(entity instanceof class_1657 || source.method_5526() == null || source.method_5529() != null && source.method_5526() != source.method_5529())) {
                            class_1297 projectile = source.method_5526();
                            return ClaimUtils.hasMatchingClaims(world, entity.method_24515(), ((OriginOwner)projectile).goml$getOriginSafe());
                        }
                        return true;
                    }
                }
            }
        }
        if (ClaimUtils.isInAdminMode(player) || entity == player) {
            return true;
        }
        if ((GetOffMyLawn.CONFIG.allowDamagingNamedHostileMobs || GetOffMyLawn.CONFIG.allowDamagingUnnamedHostileMobs && entity.method_5797() == null) && entity instanceof class_1588) {
            return true;
        }
        Selection claims = ClaimUtils.getClaimsAt((class_4538)world, entity.method_24515());
        if (claims.isEmpty()) {
            return true;
        }
        if (entity instanceof class_1657) {
            class_1657 attackedPlayer = (class_1657)entity;
            if ((claims = claims.filter(e -> ((Claim)e.getValue()).hasAugment((Augment)GOMLBlocks.PVP_ARENA.getFirst()))).isEmpty()) {
                return GetOffMyLawn.CONFIG.enablePvPinClaims;
            }
            MutableBoolean obj = new MutableBoolean(true);
            claims.forEach(e -> {
                if (!obj.getValue().booleanValue()) {
                    return;
                }
                Claim claim = (Claim)e.getValue();
                obj.setValue(switch (claim.getData(((SelectiveClaimAugmentBlock)GOMLBlocks.PVP_ARENA.getFirst()).key)) {
                    default -> throw new MatchException(null, null);
                    case StatusEnum.TargetPlayer.EVERYONE -> true;
                    case StatusEnum.TargetPlayer.DISABLED -> false;
                    case StatusEnum.TargetPlayer.TRUSTED -> {
                        if (claim.hasPermission(player) && claim.hasPermission(attackedPlayer)) {
                            yield true;
                        }
                        yield false;
                    }
                    case StatusEnum.TargetPlayer.UNTRUSTED -> !claim.hasPermission(player) && !claim.hasPermission(attackedPlayer);
                });
            });
            return obj.getValue();
        }
        return EventHandlers.testPermission((Selection<Entry<ClaimBox, Claim>>)claims, player, class_1268.field_5808, entity.method_24515(), PermissionReason.ENTITY_PROTECTED) != class_1269.field_5814;
    }

    public static boolean canModify(class_1937 world, class_2338 pos, @Nullable class_1657 player) {
        if (GetOffMyLawn.CONFIG.allowFakePlayersToModify && player != null && player.getClass() != class_3222.class && !world.field_9236) {
            return true;
        }
        Selection<Entry<ClaimBox, Claim>> claimsFound = ClaimUtils.getClaimsAt((class_4538)world, pos);
        if (player != null && claimsFound.isNotEmpty()) {
            return !claimsFound.anyMatch(boxInfo -> !ClaimUtils.canModifyClaimAt(world, pos, (Entry<ClaimBox, Claim>)boxInfo, player));
        }
        return claimsFound.isEmpty();
    }

    @Nullable
    public static ClaimAnchorBlockEntity getAnchor(class_1937 world, Claim claim) {
        ClaimAnchorBlockEntity claimAnchor = (ClaimAnchorBlockEntity)world.method_8321(claim.getOrigin());
        if (claimAnchor == null) {
            GetOffMyLawn.LOGGER.warn(String.format("A claim anchor was requested at %s, but no Claim Anchor BE was found! Was the claim not properly removed? Removing the claim now.", claim.getOrigin().toString()));
            ((ClaimComponent)GetOffMyLawn.CLAIM.get((Object)world)).getClaims().entries().forEach(entry -> {
                if (entry.getValue() == claim) {
                    claim.destroy();
                }
            });
            return null;
        }
        return claimAnchor;
    }

    public static List<class_2561> getClaimText(MinecraftServer server, Claim claim) {
        List<class_2561> owners = ClaimUtils.getPlayerNames(server, claim.getOwners());
        List<class_2561> trusted = ClaimUtils.getPlayerNames(server, claim.getTrusted());
        ArrayList<class_2561> texts = new ArrayList<class_2561>();
        texts.add((class_2561)class_2561.method_43469((String)"text.goml.position", (Object[])new Object[]{class_2561.method_43470((String)claim.getOrigin().method_23854()).method_10852((class_2561)class_2561.method_43470((String)(" (" + claim.getWorld().toString() + ")")).method_27692(class_124.field_1080)).method_27692(class_124.field_1068)}).method_27692(class_124.field_1078));
        texts.add((class_2561)class_2561.method_43469((String)"text.goml.radius", (Object[])new Object[]{class_2561.method_43470((String)("" + claim.getRadius())).method_27692(class_124.field_1068)}).method_27692(class_124.field_1054));
        if (!owners.isEmpty()) {
            texts.add((class_2561)class_2561.method_43469((String)"text.goml.owners", (Object[])new Object[]{owners.removeFirst()}).method_27692(class_124.field_1065));
            for (class_2561 text : owners) {
                texts.add((class_2561)class_2561.method_43470((String)"   ").method_10852(text));
            }
        }
        if (!trusted.isEmpty()) {
            texts.add((class_2561)class_2561.method_43469((String)"text.goml.trusted", (Object[])new Object[]{trusted.removeFirst()}).method_27692(class_124.field_1060));
            for (class_2561 text : trusted) {
                texts.add((class_2561)class_2561.method_43470((String)"   ").method_10852(text));
            }
        }
        return texts;
    }

    protected static final List<class_2561> getPlayerNames(MinecraftServer server, Collection<UUID> uuids) {
        ArrayList<class_2561> list = new ArrayList<class_2561>();
        StringBuilder builder = new StringBuilder();
        Iterator<UUID> iterator = uuids.iterator();
        while (iterator.hasNext()) {
            Optional gameProfile = server.method_3793().method_14512(iterator.next());
            if (!gameProfile.isPresent()) continue;
            builder.append(((GameProfile)gameProfile.get()).getName());
            if (iterator.hasNext()) {
                builder.append(", ");
            }
            if (builder.length() <= 32) continue;
            list.add((class_2561)class_2561.method_43470((String)builder.toString()).method_27692(class_124.field_1068));
            builder = new StringBuilder();
        }
        if (!builder.isEmpty()) {
            list.add((class_2561)class_2561.method_43470((String)builder.toString()).method_27692(class_124.field_1068));
        }
        return list;
    }

    @Deprecated
    public static boolean claimMatchesWith(Entry<ClaimBox, Claim> claim, @Nullable class_1657 checkPlayer, class_2338 checkPos) {
        return ClaimUtils.canDestroyClaimBlock(claim, checkPlayer, checkPos);
    }

    @Deprecated
    public static boolean playerHasPermission(Entry<ClaimBox, Claim> claim, class_1657 checkPlayer) {
        return ((Claim)claim.getValue()).getOwners().contains(checkPlayer.method_5667()) || ClaimUtils.isInAdminMode(checkPlayer);
    }

    public static ClaimBox createClaimBox(class_2338 pos, int radius) {
        if (GetOffMyLawn.CONFIG.makeClaimAreaChunkBound) {
            class_4076 chunkPos = class_4076.method_18682((class_2338)pos);
            radius = (int)((Math.ceil((double)radius / 16.0) - 1.0) * 16.0) + 8;
            int radiusY = (int)((Math.ceil((double)radius * GetOffMyLawn.CONFIG.claimAreaHeightMultiplier / 16.0) - 1.0) * 16.0) + 8;
            return new ClaimBox(chunkPos.method_19768(), radius, GetOffMyLawn.CONFIG.claimProtectsFullWorldHeight ? Short.MAX_VALUE : radiusY, true);
        }
        return new ClaimBox(pos, radius, GetOffMyLawn.CONFIG.claimProtectsFullWorldHeight ? Short.MAX_VALUE : (int)((double)radius * GetOffMyLawn.CONFIG.claimAreaHeightMultiplier));
    }

    public static class_3545<class_243, class_2350> getClosestXZBorder(Claim claim, class_243 curPos) {
        return ClaimUtils.getClosestXZBorder(claim, curPos, 0.0);
    }

    public static class_3545<class_243, class_2350> getClosestXZBorder(Claim claim, class_243 curPos, double extraDistance) {
        double z;
        double x;
        ClaimBox box = claim.getClaimBox();
        class_243 center = box.noShift() ? class_243.method_24954((class_2382)box.origin()) : class_243.method_24953((class_2382)box.getOrigin());
        class_243 vec = curPos.method_1020(center);
        double r = (box.noShift() ? (double)box.radius() - 0.5 : (double)box.radius()) + extraDistance;
        double angle = class_3532.method_15349((double)vec.field_1350, (double)vec.field_1352);
        double tan = Math.tan(angle);
        if (Double.isNaN(tan)) {
            tan = 1.0;
        }
        class_2350 dir = null;
        if (angle >= -0.7853981852531433 && angle <= 0.7853981852531433) {
            x = r;
            z = tan * r;
            dir = class_2350.field_11034;
        } else if (angle >= 0.7853981852531433 && angle <= 2.356194496154785) {
            x = 1.0 / tan * r;
            z = r;
            dir = class_2350.field_11035;
        } else if (angle <= -0.7853981852531433 && angle >= -2.356194496154785) {
            x = -1.0 / tan * r;
            z = -r;
            dir = class_2350.field_11043;
        } else {
            x = -r;
            z = -Math.tan(angle) * r;
            dir = class_2350.field_11039;
        }
        return new class_3545((Object)center.method_1031(x, 0.0, z), (Object)dir);
    }

    public static boolean hasMatchingClaims(class_1937 world, class_2338 target, class_2338 origin) {
        return ClaimUtils.hasMatchingClaims(world, target, origin, null);
    }

    public static boolean hasMatchingClaims(class_1937 world, class_2338 target, class_2338 origin, @Nullable UUID uuid) {
        Selection<Entry<ClaimBox, Claim>> claims = ClaimUtils.getClaimsAt((class_4538)world, target);
        if (claims.isEmpty()) {
            return true;
        }
        Selection<Entry<ClaimBox, Claim>> originClaims = ClaimUtils.getClaimsAt((class_4538)world, origin);
        if (originClaims.isEmpty() && uuid == null) {
            return false;
        }
        HashSet<UUID> trusted = new HashSet<UUID>();
        if (uuid != null) {
            trusted.add(uuid);
        }
        claims.forEach(x -> {
            trusted.addAll(((Claim)x.getValue()).getOwners());
            trusted.addAll(((Claim)x.getValue()).getTrusted());
        });
        return claims.anyMatch(x -> ((Claim)x.getValue()).hasPermission(trusted));
    }

    private static /* synthetic */ boolean lambda$canExplosionDestroy$11(class_1937 world, class_2338 pos, class_1657 player, Entry boxInfo) {
        return !ClaimUtils.canModifyClaimAt(world, pos, (Entry<ClaimBox, Claim>)boxInfo, player);
    }
}

