/*
 * Decompiled with CFR 0.152.
 */
package net.blouflin.photography.networking;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import javax.imageio.ImageIO;
import net.blouflin.image2map.Image2Map;
import net.blouflin.image2map.renderer.MapRenderer;
import net.blouflin.photography.client.PhotographyHud;
import net.blouflin.photography.networking.SpawnPicturePayload;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1011;
import net.minecraft.class_22;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_318;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_8710;
import net.minecraft.class_9139;

public record CreatePicturePayload(Integer id, class_2487 nbtCompound) implements class_8710
{
    public static final class_8710.class_9154<CreatePicturePayload> ID = class_8710.method_56483((String)"photography_create_picture");
    public static final class_9139<class_2540, CreatePicturePayload> CODEC = class_9139.method_56438((value, buf) -> buf.method_53002(value.id.intValue()).method_10794((class_2520)value.nbtCompound), buf -> new CreatePicturePayload(buf.readInt(), buf.method_10798()));

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return ID;
    }

    public static void receive(class_310 client, Integer id, class_2487 nbtCompound) {
        CompletableFuture future = new CompletableFuture();
        client.execute(() -> {
            class_5455 registryLookup = client.field_1724.method_56673();
            class_22 mapState = class_22.method_32371((class_2487)nbtCompound, (class_7225.class_7874)registryLookup);
            PhotographyHud.CAMERA_SCOPE_TO_RENDER = PhotographyHud.CAMERA_SCOPE_CLEAR;
            PhotographyHud.setScreenshotFuture(future);
            future.thenRun(() -> {
                class_1011 nativeImage = class_318.method_1663((class_276)client.method_1522());
                PhotographyHud.CAMERA_SCOPE_TO_RENDER = PhotographyHud.CAMERA_SCOPE;
                PhotographyHud.spyglassFlashOpacity = 1.0f;
                PhotographyHud.isTakingPhoto = false;
                try {
                    byte[] imageBytes = nativeImage.method_24036();
                    BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(imageBytes));
                    bufferedImage = CreatePicturePayload.crop(bufferedImage, bufferedImage.getHeight(), bufferedImage.getHeight());
                    class_22 mapState1 = MapRenderer.render(bufferedImage, Image2Map.DitherMode.FLOYD, id, mapState);
                    SpawnPicturePayload payload = new SpawnPicturePayload(id, nbtCompound);
                    ClientPlayNetworking.send((class_8710)payload);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        });
    }

    public static BufferedImage crop(BufferedImage bufferedImage, int targetWidth, int targetHeight) throws IOException {
        int height = bufferedImage.getHeight();
        int width = bufferedImage.getWidth();
        int xc = (width - targetWidth) / 2;
        int yc = (height - targetHeight) / 2;
        BufferedImage croppedImage = bufferedImage.getSubimage(xc, yc, targetWidth, targetHeight);
        return croppedImage;
    }
}

