/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.InMemoryCommentedFormat;
import com.electronwill.nightconfig.core.UnmodifiableCommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.concurrent.ConcurrentCommentedConfig;
import com.electronwill.nightconfig.core.concurrent.SynchronizedConfig;
import com.electronwill.nightconfig.core.file.FileWatcher;
import com.electronwill.nightconfig.core.io.ParsingException;
import com.electronwill.nightconfig.core.io.ParsingMode;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.electronwill.nightconfig.toml.TomlParser;
import com.electronwill.nightconfig.toml.TomlWriter;
import com.mojang.logging.LogUtils;
import fuzs.forgeconfigapiport.fabric.impl.config.ForgeConfigApiPortConfig;
import fuzs.forgeconfigapiport.fabric.impl.core.ModConfigEventsHelper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import net.fabricmc.loader.api.FabricLoader;
import net.neoforged.fml.config.ConfigWatcher;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.LoadedConfig;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

@ApiStatus.Internal
public class ConfigTracker {
    public static final ConfigTracker INSTANCE = new ConfigTracker();
    static final Marker CONFIG = MarkerFactory.getMarker((String)"CONFIG");
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Path defaultConfigPath = ForgeConfigApiPortConfig.getDefaultConfigsDirectory();
    final ConcurrentHashMap<String, ModConfig> fileMap = new ConcurrentHashMap();
    final EnumMap<ModConfig.Type, Set<ModConfig>> configSets = new EnumMap(ModConfig.Type.class);
    final ConcurrentHashMap<String, List<ModConfig>> configsByMod = new ConcurrentHashMap();
    private final Map<String, ReentrantLock> locksByMod = new ConcurrentHashMap<String, ReentrantLock>();

    @VisibleForTesting
    public ConfigTracker() {
        for (ModConfig.Type type : ModConfig.Type.values()) {
            this.configSets.put(type, Collections.synchronizedSet(new LinkedHashSet()));
        }
    }

    public ModConfig registerConfig(ModConfig.Type type, IConfigSpec spec, String modId) {
        return this.registerConfig(type, spec, modId, ConfigTracker.defaultConfigName(type, modId));
    }

    public ModConfig registerConfig(ModConfig.Type type, IConfigSpec spec, String modId, String fileName) {
        ReentrantLock lock = this.locksByMod.computeIfAbsent(modId, m -> new ReentrantLock());
        ModConfig modConfig = new ModConfig(type, spec, modId, fileName, lock);
        this.validateSpec(spec, modConfig);
        this.trackConfig(modConfig);
        if (modConfig.getType() != ModConfig.Type.SERVER) {
            ConfigTracker.openConfig(modConfig, FabricLoader.getInstance().getConfigDir(), null);
        }
        return modConfig;
    }

    private void validateSpec(IConfigSpec spec, ModConfig config) {
        if (spec instanceof ModConfigSpec) {
            this.forEachValue(((ModConfigSpec)spec).getValues().valueMap().values(), configValue -> {
                if (configValue.getSpec().restartType() == ModConfigSpec.RestartType.GAME && config.getType() == ModConfig.Type.SERVER) {
                    throw new IllegalArgumentException("Configuration value " + String.join((CharSequence)".", configValue.getPath()) + " defined in config " + config.getFileName() + " has restart of type " + String.valueOf((Object)configValue.getSpec().restartType()) + " which cannot be used for configs of type " + String.valueOf((Object)config.getType()));
                }
            });
        }
    }

    private void forEachValue(Iterable<Object> configValues, Consumer<ModConfigSpec.ConfigValue<?>> consumer) {
        configValues.forEach(value -> {
            if (value instanceof ModConfigSpec.ConfigValue) {
                ModConfigSpec.ConfigValue configValue = (ModConfigSpec.ConfigValue)value;
                consumer.accept(configValue);
            } else if (value instanceof Config) {
                Config innerConfig = (Config)value;
                this.forEachValue(innerConfig.valueMap().values(), consumer);
            }
        });
    }

    private static String defaultConfigName(ModConfig.Type type, String modId) {
        return String.format(Locale.ROOT, "%s-%s.toml", modId, type.extension());
    }

    void trackConfig(ModConfig config) {
        ModConfig previousValue = this.fileMap.putIfAbsent(config.getFileName(), config);
        if (previousValue != null) {
            String errorMessage = String.format(Locale.ROOT, "Detected config file conflict on %s from %s (already registered by %s)", config.getFileName(), config.getModId(), previousValue.getModId());
            LOGGER.error(CONFIG, "{}", (Object)errorMessage);
            throw new RuntimeException(errorMessage);
        }
        this.configSets.get((Object)config.getType()).add(config);
        this.configsByMod.computeIfAbsent(config.getModId(), k -> Collections.synchronizedList(new ArrayList())).add(config);
        LOGGER.debug(CONFIG, "Config file {} for {} tracking", (Object)config.getFileName(), (Object)config.getModId());
    }

    public void loadConfigs(ModConfig.Type type, Path configBasePath) {
        this.loadConfigs(type, configBasePath, null);
    }

    public void loadConfigs(ModConfig.Type type, Path configBasePath, @Nullable Path configOverrideBasePath) {
        LOGGER.debug(CONFIG, "Loading configs type {}", (Object)type);
        this.configSets.get((Object)type).forEach(config -> ConfigTracker.openConfig(config, configBasePath, configOverrideBasePath));
    }

    public void unloadConfigs(ModConfig.Type type) {
        LOGGER.debug(CONFIG, "Unloading configs type {}", (Object)type);
        this.configSets.get((Object)type).forEach(ConfigTracker::closeConfig);
    }

    static void openConfig(ModConfig config, Path configBasePath, @Nullable Path configOverrideBasePath) {
        LOGGER.trace(CONFIG, "Loading config file type {} at {} for {}", new Object[]{config.getType(), config.getFileName(), config.getModId()});
        if (config.loadedConfig != null) {
            LOGGER.warn("Opening a config that was already loaded with value {} at path {}", (Object)config.loadedConfig, (Object)config.getFileName());
        }
        Path basePath = ConfigTracker.resolveBasePath(config, configBasePath, configOverrideBasePath);
        Path configPath = basePath.resolve(config.getFileName());
        ConfigTracker.loadConfig(config, configPath, ModConfigEventsHelper.loading());
        LOGGER.debug(CONFIG, "Loaded TOML config file {}", (Object)configPath);
        if (!((Boolean)ForgeConfigApiPortConfig.INSTANCE.getValue("disableConfigWatcher")).booleanValue()) {
            FileWatcher.defaultInstance().addWatch(configPath, (Runnable)new ConfigWatcher(config, configPath, Thread.currentThread().getContextClassLoader()));
            LOGGER.debug(CONFIG, "Watching TOML config file {} for changes", (Object)configPath);
        }
    }

    private static Path resolveBasePath(ModConfig config, Path configBasePath, @Nullable Path configOverrideBasePath) {
        Path overrideFilePath;
        if (configOverrideBasePath != null && Files.exists(overrideFilePath = configOverrideBasePath.resolve(config.getFileName()), new LinkOption[0])) {
            LOGGER.info(CONFIG, "Found config file override in path {}", (Object)overrideFilePath);
            return configOverrideBasePath;
        }
        return configBasePath;
    }

    static void loadConfig(ModConfig modConfig, Path path, Consumer<ModConfig> eventConstructor) {
        ConcurrentCommentedConfig config;
        try {
            config = ConfigTracker.readConfig(path);
            if (!modConfig.getSpec().isCorrect((UnmodifiableCommentedConfig)config)) {
                LOGGER.warn(CONFIG, "Configuration file {} is not correct. Correcting", (Object)path);
                ConfigTracker.backUpConfig(path);
                modConfig.getSpec().correct((CommentedConfig)config);
                ConfigTracker.writeConfig(path, (UnmodifiableCommentedConfig)config);
            }
        }
        catch (NoSuchFileException ignored) {
            try {
                ConfigTracker.setupConfigFile(modConfig, path);
                config = ConfigTracker.readConfig(path);
            }
            catch (ParsingException | IOException ex) {
                throw new RuntimeException("Failed to create default config file " + modConfig.getFileName() + " of type " + String.valueOf((Object)modConfig.getType()) + " for modid " + modConfig.getModId(), ex);
            }
        }
        catch (ParsingException | IOException ex) {
            LOGGER.warn(CONFIG, "Failed to load config {}: {}. Attempting to recreate", (Object)modConfig.getFileName(), (Object)ex);
            try {
                ConfigTracker.backUpConfig(path);
                Files.delete(path);
                ConfigTracker.setupConfigFile(modConfig, path);
                config = ConfigTracker.readConfig(path);
            }
            catch (Throwable t) {
                ex.addSuppressed(t);
                throw new RuntimeException("Failed to recreate config file " + modConfig.getFileName() + " of type " + String.valueOf((Object)modConfig.getType()) + " for modid " + modConfig.getModId(), ex);
            }
        }
        modConfig.setConfig(new LoadedConfig((CommentedConfig)config, path, modConfig), eventConstructor);
    }

    public static void acceptSyncedConfig(ModConfig modConfig, byte[] bytes) {
        if (modConfig.loadedConfig != null) {
            LOGGER.warn("Overwriting non-null config {} at path {} with synced config", (Object)modConfig.loadedConfig, (Object)modConfig.getFileName());
        }
        SynchronizedConfig newConfig = new SynchronizedConfig((ConfigFormat)InMemoryCommentedFormat.defaultInstance(), LinkedHashMap::new);
        newConfig.bulkCommentedUpdate(view -> TomlFormat.instance().createParser().parse((InputStream)new ByteArrayInputStream(bytes), (Config)view, ParsingMode.REPLACE));
        modConfig.setConfig(new LoadedConfig((CommentedConfig)newConfig, null, modConfig), ModConfigEventsHelper.reloading());
    }

    public void loadDefaultServerConfigs() {
        this.configSets.get((Object)ModConfig.Type.SERVER).forEach(modConfig -> {
            if (modConfig.loadedConfig != null) {
                LOGGER.warn("Overwriting non-null config {} at path {} with default server config", (Object)modConfig.loadedConfig, (Object)modConfig.getFileName());
            }
            modConfig.setConfig(new LoadedConfig(ConfigTracker.createDefaultConfig(modConfig.getSpec()), null, (ModConfig)modConfig), ModConfigEventsHelper.loading());
        });
    }

    private static CommentedConfig createDefaultConfig(IConfigSpec spec) {
        SynchronizedConfig commentedConfig = new SynchronizedConfig((ConfigFormat)InMemoryCommentedFormat.defaultInstance(), LinkedHashMap::new);
        commentedConfig.bulkCommentedUpdate(spec::correct);
        return commentedConfig;
    }

    private static void closeConfig(ModConfig config) {
        if (config.loadedConfig != null) {
            if (config.loadedConfig.path() != null) {
                LOGGER.trace(CONFIG, "Closing config file type {} at {} for {}", new Object[]{config.getType(), config.getFileName(), config.getModId()});
                ConfigTracker.unload(config.loadedConfig.path());
                config.setConfig(null, ModConfigEventsHelper.unloading());
            } else {
                LOGGER.warn(CONFIG, "Closing non-file config {} at path {}", (Object)config.loadedConfig, (Object)config.getFileName());
            }
        }
    }

    private static void unload(Path path) {
        if (((Boolean)ForgeConfigApiPortConfig.INSTANCE.getValue("disableConfigWatcher")).booleanValue()) {
            return;
        }
        try {
            FileWatcher.defaultInstance().removeWatch(path);
        }
        catch (RuntimeException e) {
            LOGGER.error("Failed to remove config {} from tracker!", (Object)path, (Object)e);
        }
    }

    private static void setupConfigFile(ModConfig modConfig, Path file) throws IOException {
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        Path p = defaultConfigPath.resolve(modConfig.getFileName());
        if (Files.exists(p, new LinkOption[0])) {
            LOGGER.info(CONFIG, "Loading default config file from path {}", (Object)p);
            Files.copy(p, file, new CopyOption[0]);
        } else {
            ConfigTracker.writeConfig(file, (UnmodifiableCommentedConfig)ConfigTracker.createDefaultConfig(modConfig.getSpec()));
        }
    }

    private static ConcurrentCommentedConfig readConfig(Path path) throws IOException, ParsingException {
        try (BufferedReader reader = Files.newBufferedReader(path);){
            SynchronizedConfig config = new SynchronizedConfig((ConfigFormat)TomlFormat.instance(), LinkedHashMap::new);
            config.bulkCommentedUpdate(view -> new TomlParser().parse((Reader)reader, (Config)view, ParsingMode.REPLACE));
            SynchronizedConfig synchronizedConfig = config;
            return synchronizedConfig;
        }
    }

    static void writeConfig(Path file, UnmodifiableCommentedConfig config) {
        new TomlWriter().write((UnmodifiableConfig)config, file, WritingMode.REPLACE_ATOMIC);
    }

    private static void backUpConfig(Path commentedFileConfig) {
        ConfigTracker.backUpConfig(commentedFileConfig, 5);
    }

    private static void backUpConfig(Path commentedFileConfig, int maxBackups) {
        Path bakFileLocation = commentedFileConfig.getParent();
        String bakFileName = FilenameUtils.removeExtension((String)commentedFileConfig.getFileName().toString());
        String bakFileExtension = FilenameUtils.getExtension((String)commentedFileConfig.getFileName().toString()) + ".bak";
        Path bakFile = bakFileLocation.resolve(bakFileName + "-1." + bakFileExtension);
        try {
            for (int i = maxBackups; i > 0; --i) {
                Path oldBak = bakFileLocation.resolve(bakFileName + "-" + i + "." + bakFileExtension);
                if (!Files.exists(oldBak, new LinkOption[0])) continue;
                if (i >= maxBackups) {
                    Files.delete(oldBak);
                    continue;
                }
                Files.move(oldBak, bakFileLocation.resolve(bakFileName + "-" + (i + 1) + "." + bakFileExtension), new CopyOption[0]);
            }
            Files.copy(commentedFileConfig, bakFile, new CopyOption[0]);
        }
        catch (IOException exception) {
            LOGGER.warn(CONFIG, "Failed to back up config file {}", (Object)commentedFileConfig, (Object)exception);
        }
    }
}

