/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.fabric.config;

import com.anthonyhilyard.iceberg.Iceberg;
import com.anthonyhilyard.iceberg.events.common.ConfigEvents;
import com.anthonyhilyard.iceberg.fabric.config.FabricIcebergConfigSpec;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.electronwill.nightconfig.core.file.FileWatcher;
import com.electronwill.nightconfig.core.io.ParsingException;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.concurrent.ConcurrentMap;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.util.BiConsumer;

public class ConfigTracker {
    public static final ConfigTracker INSTANCE = new ConfigTracker();
    private final ConcurrentMap<String, ConfigInfo> fileMap = Maps.newConcurrentMap();
    private final ConcurrentMap<String, ConfigInfo> configsByMod = Maps.newConcurrentMap();
    private static final Path defaultConfigPath = FabricLoader.getInstance().getConfigDir();

    private ConfigTracker() {
    }

    public void registerConfig(FabricIcebergConfigSpec configSpec, String modId) {
        this.trackConfig(new ConfigInfo(String.format(Locale.ROOT, "%s.toml", modId), configSpec, modId));
    }

    private void trackConfig(ConfigInfo config) {
        if (this.fileMap.containsKey(config.getFilename())) {
            Iceberg.LOGGER.error("Detected config file conflict {} between {} and {}", (Object)config.getFilename(), (Object)((ConfigInfo)this.fileMap.get(config.getFilename())).getModId(), (Object)config.getModId());
            throw new RuntimeException("Config conflict detected!");
        }
        this.fileMap.put(config.getFilename(), config);
        this.configsByMod.put(config.getModId(), config);
        Iceberg.LOGGER.debug("Config file {} for {} tracking", (Object)config.getFilename(), (Object)config.getModId());
    }

    public void loadConfigs(Path configBasePath) {
        Iceberg.LOGGER.debug("Loading configs");
        this.fileMap.values().forEach(config -> this.openConfig((ConfigInfo)config, configBasePath));
    }

    public void unloadConfigs() {
        Iceberg.LOGGER.debug("Unloading configs");
        this.fileMap.values().forEach(this::closeConfig);
    }

    public void openConfig(ConfigInfo config, Path configBasePath) {
        Iceberg.LOGGER.trace("Loading config file at {} for {}", (Object)config.getFilename(), (Object)config.getModId());
        CommentedFileConfig configData = this.readTomlFile(configBasePath, config);
        config.setConfigData(configData);
        ConfigEvents.LOAD.invoker().onLoad(config.getModId());
        config.save();
    }

    private CommentedFileConfig readTomlFile(Path basePath, ConfigInfo config) {
        Path configPath = basePath.resolve(config.getFilename());
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder(configPath).sync().preserveInsertionOrder().autosave().onFileNotFound((newfile, configFormat) -> this.setupConfigFile(config, newfile, configFormat)).writingMode(WritingMode.REPLACE).build();
        Iceberg.LOGGER.debug("Built TOML config for {}", (Object)configPath);
        try {
            configData.load();
        }
        catch (ParsingException ex) {
            Iceberg.LOGGER.warn("Attempting to recreate {}", (Object)configPath);
            try {
                ConfigTracker.backUpConfig(configData.getNioPath(), 3);
                Files.delete(configData.getNioPath());
                configData.load();
            }
            catch (Throwable t) {
                ex.addSuppressed(t);
                throw new RuntimeException("Failed loading config file " + config.getFilename() + " for modid " + config.getModId(), ex);
            }
        }
        Iceberg.LOGGER.debug("Loaded TOML config file {}", (Object)configPath);
        try {
            FileWatcher.defaultInstance().addWatch(configPath, (Runnable)new ConfigWatcher(this, config, configData, Thread.currentThread().getContextClassLoader()));
            Iceberg.LOGGER.debug("Watching TOML config file {} for changes", (Object)configPath);
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't watch config file", e);
        }
        return configData;
    }

    public void unload(ConfigInfo config) {
        Path configPath = this.getConfigFilePath(config.getModId());
        try {
            FileWatcher.defaultInstance().removeWatch(configPath);
        }
        catch (RuntimeException e) {
            Iceberg.LOGGER.error("Failed to remove config {} from tracker!", (Object)configPath, (Object)e);
        }
    }

    private boolean setupConfigFile(ConfigInfo config, Path file, ConfigFormat<?> conf) throws IOException {
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        Path p = defaultConfigPath.resolve(config.getFilename());
        if (Files.exists(p, new LinkOption[0])) {
            Iceberg.LOGGER.debug("Loading default config file from path {}", (Object)p);
            Files.copy(p, file, new CopyOption[0]);
        } else {
            Files.createFile(file, new FileAttribute[0]);
            conf.initEmptyFile(file);
        }
        return true;
    }

    public static void backUpConfig(Path commentedFileConfig, int maxBackups) {
        Path bakFileLocation = commentedFileConfig.getParent();
        String bakFileName = FilenameUtils.removeExtension((String)commentedFileConfig.getFileName().toString());
        String bakFileExtension = FilenameUtils.getExtension((String)commentedFileConfig.getFileName().toString()) + ".bak";
        Path bakFile = bakFileLocation.resolve(bakFileName + "-1." + bakFileExtension);
        try {
            for (int i = maxBackups; i > 0; --i) {
                Path oldBak = bakFileLocation.resolve(bakFileName + "-" + i + "." + bakFileExtension);
                if (!Files.exists(oldBak, new LinkOption[0])) continue;
                if (i >= maxBackups) {
                    Files.delete(oldBak);
                    continue;
                }
                Files.move(oldBak, bakFileLocation.resolve(bakFileName + "-" + (i + 1) + "." + bakFileExtension), new CopyOption[0]);
            }
            Files.copy(commentedFileConfig, bakFile, new CopyOption[0]);
        }
        catch (IOException exception) {
            Iceberg.LOGGER.warn("Failed to back up config file {}", (Object)commentedFileConfig, (Object)exception);
        }
    }

    private void closeConfig(ConfigInfo config) {
        if (config.getConfigData() != null) {
            Iceberg.LOGGER.trace("Closing config file at {} for {}", (Object)config.getFilename(), (Object)config.getModId());
            this.unload(config);
            config.save();
            config.setConfigData(null);
        }
    }

    public String getConfigFileName(String modId) {
        Path path = this.getConfigFilePath(modId);
        return path == null ? null : path.toString();
    }

    public Path getConfigFilePath(String modId) {
        return this.configsByMod.containsKey(modId) ? defaultConfigPath.resolve(((ConfigInfo)this.configsByMod.get(modId)).getFilename()) : null;
    }

    private static class ConfigInfo {
        private final String filename;
        private final FabricIcebergConfigSpec configSpec;
        private final String modId;
        private CommentedConfig configData;

        ConfigInfo(String filename, FabricIcebergConfigSpec configSpec, String modId) {
            this.filename = filename;
            this.configSpec = configSpec;
            this.modId = modId;
        }

        public String getFilename() {
            return this.filename;
        }

        public FabricIcebergConfigSpec getSpec() {
            return this.configSpec;
        }

        public String getModId() {
            return this.modId;
        }

        public CommentedConfig getConfigData() {
            return this.configData;
        }

        void setConfigData(CommentedConfig configData) {
            this.configData = configData;
            this.configSpec.setConfig(configData);
        }

        public void save() {
            CommentedConfig commentedConfig = this.configData;
            if (commentedConfig instanceof FileConfig) {
                FileConfig fileConfig = (FileConfig)((Object)commentedConfig);
                fileConfig.save();
            }
        }
    }

    class ConfigWatcher
    implements Runnable {
        private final ConfigInfo configInfo;
        private final CommentedFileConfig commentedFileConfig;
        private final ClassLoader realClassLoader;

        ConfigWatcher(ConfigTracker this$0, ConfigInfo configInfo, CommentedFileConfig commentedFileConfig, ClassLoader classLoader) {
            this.configInfo = configInfo;
            this.commentedFileConfig = commentedFileConfig;
            this.realClassLoader = classLoader;
        }

        @Override
        public void run() {
            Thread.currentThread().setContextClassLoader(this.realClassLoader);
            if (!this.configInfo.getSpec().applyCorrectionAction(this.commentedFileConfig, (BiConsumer<FabricIcebergConfigSpec, CommentedFileConfig>)((BiConsumer)(spec, config) -> {
                Iceberg.LOGGER.warn("Configuration file {} is not correct. Correcting", (Object)config.getFile().getAbsolutePath());
                ConfigTracker.backUpConfig(config.getNioPath(), 3);
                spec.correct((CommentedConfig)config, (action, path, incorrectValue, correctedValue) -> {}, null);
            }), this.configInfo.getModId())) {
                throw new RuntimeException("Failed loading config file " + this.configInfo.getFilename() + " for modid " + this.configInfo.getModId());
            }
        }
    }
}

