/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.common.tree.breaking;

import fr.rakambda.fallingtree.common.FallingTreeCommon;
import fr.rakambda.fallingtree.common.tree.Tree;
import fr.rakambda.fallingtree.common.tree.TreePart;
import fr.rakambda.fallingtree.common.tree.TreePartType;
import fr.rakambda.fallingtree.common.tree.breaking.BreakTreeTooBigException;
import fr.rakambda.fallingtree.common.tree.breaking.ITreeBreakingHandler;
import fr.rakambda.fallingtree.common.tree.breaking.ToolDamageHandler;
import fr.rakambda.fallingtree.common.wrapper.IBlockPos;
import fr.rakambda.fallingtree.common.wrapper.IBlockState;
import fr.rakambda.fallingtree.common.wrapper.IItemStack;
import fr.rakambda.fallingtree.common.wrapper.ILevel;
import fr.rakambda.fallingtree.common.wrapper.IPlayer;
import fr.rakambda.fallingtree.common.wrapper.IServerLevel;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ShiftDownTreeBreakingHandler
implements ITreeBreakingHandler {
    @Generated
    private static final Logger log = LogManager.getLogger(ShiftDownTreeBreakingHandler.class);
    private static ShiftDownTreeBreakingHandler INSTANCE;
    private final FallingTreeCommon<?> mod;

    @Override
    public boolean breakTree(@NotNull IPlayer player, @NotNull Tree tree) throws BreakTreeTooBigException {
        IItemStack tool = player.getMainHandItem();
        Optional<TreePart> treePartOptional = tree.getLastSequencePart();
        if (treePartOptional.isEmpty()) {
            return false;
        }
        TreePart treePart = treePartOptional.get();
        ILevel level = tree.getLevel();
        if (treePart.treePartType() == TreePartType.NETHER_WART && this.mod.getConfiguration().getTrees().isBreakNetherTreeWarts()) {
            return this.breakElements(tree, level, player, tool, tree.getWarts());
        }
        return this.breakElements(tree, level, player, tool, List.of(treePart));
    }

    private boolean breakElements(@NotNull Tree tree, @NotNull ILevel level, @NotNull IPlayer player, @NotNull IItemStack tool, @NotNull Collection<TreePart> parts) throws BreakTreeTooBigException {
        int count = parts.size();
        double damageMultiplicand = this.mod.getConfiguration().getTools().getDamageMultiplicand();
        ToolDamageHandler toolHandler = new ToolDamageHandler(tool, damageMultiplicand, this.mod.getConfiguration().getTools().isPreserve(), count, this.mod.getConfiguration().getTrees().getMaxSize(), this.mod.getConfiguration().getTrees().getMaxSizeAction(), this.mod.getConfiguration().getTools().getDamageRounding());
        if (toolHandler.getMaxBreakCount() <= 0) {
            log.debug("Didn't break tree at {} as {}'s tool was about to break", (Object)tree.getHitPos(), (Object)player);
            this.mod.notifyPlayer(player, this.mod.translate("chat.fallingtree.prevented_break_tool", new Object[0]));
            return false;
        }
        int breakCount = parts.stream().limit(toolHandler.getMaxBreakCount()).mapToInt(wart -> this.breakPart(tree, (TreePart)wart, level, player, tool)).sum();
        int damage = toolHandler.getActualDamage(breakCount);
        if (damage > 0) {
            tool.damage(damage, player);
        }
        if (level instanceof IServerLevel) {
            IServerLevel serverLevel = (IServerLevel)level;
            serverLevel.spawnParticle(tree.getHitPos(), level.getBlockState(tree.getHitPos()), 10, 1.0f, 1.0f, 1.0f, 5.0f);
        }
        return true;
    }

    private int breakPart(@NotNull Tree tree, @NotNull TreePart treePart, @NotNull ILevel level, @NotNull IPlayer player, @NotNull IItemStack tool) {
        IBlockState logState;
        IBlockPos blockPos = treePart.blockPos();
        if (!this.mod.checkCanBreakBlock(level, blockPos, logState = level.getBlockState(blockPos), player)) {
            return 0;
        }
        player.awardItemUsed(tool.getItem());
        if (!player.isCreative() || this.mod.getConfiguration().isLootInCreative()) {
            logState.getBlock().playerDestroy(level, player, tree.getHitPos(), logState, level.getBlockEntity(blockPos), tool);
        }
        level.removeBlock(blockPos, false);
        return 1;
    }

    @NotNull
    public static ShiftDownTreeBreakingHandler getInstance(@NotNull FallingTreeCommon<?> common) {
        if (Objects.isNull(INSTANCE)) {
            INSTANCE = new ShiftDownTreeBreakingHandler(common);
        }
        return INSTANCE;
    }

    @Generated
    public ShiftDownTreeBreakingHandler(FallingTreeCommon<?> mod) {
        this.mod = mod;
    }
}

