/*
 * Decompiled with CFR 0.152.
 */
package dynamic_fps.impl.compat;

import dynamic_fps.impl.DynamicFPSMod;
import dynamic_fps.impl.PowerState;
import dynamic_fps.impl.config.BatteryTrackerConfig;
import dynamic_fps.impl.config.Config;
import dynamic_fps.impl.config.DynamicFPSConfig;
import dynamic_fps.impl.config.option.BatteryIndicatorCondition;
import dynamic_fps.impl.config.option.BatteryIndicatorPlacement;
import dynamic_fps.impl.config.option.GraphicsState;
import dynamic_fps.impl.config.option.IdleCondition;
import dynamic_fps.impl.util.Localization;
import dynamic_fps.impl.util.VariableStepTransformer;
import java.util.Locale;
import java.util.Optional;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.impl.builders.SubCategoryBuilder;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_3419;
import net.minecraft.class_437;
import net.minecraft.class_5244;

public final class ClothConfig {
    public static class_437 genConfigScreen(class_437 parent) {
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((class_2561)Localization.localized("config", "title", new Object[0])).setSavingRunnable(DynamicFPSMod::onConfigChanged);
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        ConfigCategory general = builder.getOrCreateCategory((class_2561)Localization.localized("config", "category.general", new Object[0]));
        DynamicFPSConfig config = DynamicFPSConfig.INSTANCE;
        DynamicFPSConfig defaultConfig = DynamicFPSConfig.DEFAULTS;
        general.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)Localization.localized("config", "enabled", new Object[0]), config.enabled()).setDefaultValue(defaultConfig.enabled()).setSaveConsumer(config::setEnabled).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)Localization.localized("config", "uncap_menu_frame_rate", new Object[0]), config.uncapMenuFrameRate()).setDefaultValue(defaultConfig.uncapMenuFrameRate()).setSaveConsumer(config::setUncapMenuFrameRate).setTooltip(new class_2561[]{Localization.localized("config", "uncap_menu_frame_rate_tooltip", new Object[0])}).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription(class_5244.field_41874).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((class_2561)Localization.localized("config", "idle_time", new Object[0]), config.idle().timeout() / 60, 0, 30).setDefaultValue(defaultConfig.idle().timeout() / 60).setSaveConsumer(value -> config.idle().setTimeout(value * 60)).setTextGetter(ClothConfig::idleTimeMessage).setTooltip(new class_2561[]{Localization.localized("config", "idle_time_tooltip", new Object[0])}).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startEnumSelector((class_2561)Localization.localized("config", "idle_condition", new Object[0]), IdleCondition.class, (Enum)config.idle().condition()).setDefaultValue((Enum)defaultConfig.idle().condition()).setSaveConsumer(config.idle()::setCondition).setEnumNameProvider(ClothConfig::IdleConditionMessage).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription(class_5244.field_41874).build());
        VariableStepTransformer volumeTransformer = ClothConfig.getVolumeStepTransformer();
        general.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((class_2561)Localization.localized("config", "volume_transition_speed_up", new Object[0]), volumeTransformer.toStep((int)(config.volumeTransitionSpeed().getUp() * 100.0f)), 1, 73).setDefaultValue(volumeTransformer.toStep((int)(defaultConfig.volumeTransitionSpeed().getUp() * 100.0f))).setSaveConsumer(step -> config.volumeTransitionSpeed().setUp((float)volumeTransformer.toValue((int)step) / 100.0f)).setTextGetter(ClothConfig::volumeTransitionMessage).setTooltip(new class_2561[]{Localization.localized("config", "volume_transition_speed_tooltip", new Object[0])}).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((class_2561)Localization.localized("config", "volume_transition_speed_down", new Object[0]), volumeTransformer.toStep((int)(config.volumeTransitionSpeed().getDown() * 100.0f)), 1, 73).setDefaultValue(volumeTransformer.toStep((int)(defaultConfig.volumeTransitionSpeed().getDown() * 100.0f))).setSaveConsumer(step -> config.volumeTransitionSpeed().setDown((float)volumeTransformer.toValue((int)step) / 100.0f)).setTextGetter(ClothConfig::volumeTransitionMessage).setTooltip(new class_2561[]{Localization.localized("config", "volume_transition_speed_tooltip", new Object[0])}).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription(class_5244.field_41874).build());
        BatteryTrackerConfig batteryTracker = config.batteryTracker();
        general.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)Localization.localized("config", "battery_tracker", new Object[0]), batteryTracker.enabled()).setDefaultValue(defaultConfig.batteryTracker().enabled()).setSaveConsumer(batteryTracker::setEnabled).setTooltip(new class_2561[]{Localization.localized("config", "battery_tracker_tooltip", new Object[0])}).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)Localization.localized("config", "battery_tracker_switch_states", new Object[0]), batteryTracker.switchStates()).setDefaultValue(defaultConfig.batteryTracker().switchStates()).setSaveConsumer(batteryTracker::setSwitchStates).setTooltip(new class_2561[]{Localization.localized("config", "battery_tracker_switch_states_tooltip", new Object[0])}).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)Localization.localized("config", "battery_tracker_notifications", new Object[0]), batteryTracker.notifications()).setDefaultValue(defaultConfig.batteryTracker().notifications()).setSaveConsumer(batteryTracker::setNotifications).setTooltip(new class_2561[]{Localization.localized("config", "battery_tracker_notifications_tooltip", new Object[0])}).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startEnumSelector((class_2561)Localization.localized("config", "battery_indicator_condition", new Object[0]), BatteryIndicatorCondition.class, (Enum)batteryTracker.display().condition()).setDefaultValue((Enum)defaultConfig.batteryTracker().display().condition()).setSaveConsumer(batteryTracker.display()::setCondition).setEnumNameProvider(ClothConfig::batteryIndicatorConditionMessage).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startEnumSelector((class_2561)Localization.localized("config", "battery_indicator_placement", new Object[0]), BatteryIndicatorPlacement.class, (Enum)batteryTracker.display().placement()).setDefaultValue((Enum)defaultConfig.batteryTracker().display().placement()).setSaveConsumer(batteryTracker.display()::setPlacement).setEnumNameProvider(ClothConfig::batteryIndicatorPlacementMessage).build());
        VariableStepTransformer fpsTransformer = ClothConfig.getFpsTransformer();
        for (PowerState state : PowerState.values()) {
            if (state.configurabilityLevel == PowerState.ConfigurabilityLevel.NONE) continue;
            Config instance = config.get(state);
            Config standard = defaultConfig.get(state);
            ConfigCategory category = builder.getOrCreateCategory((class_2561)Localization.localized("config", "category." + state.toString().toLowerCase(Locale.ROOT), new Object[0]));
            category.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((class_2561)Localization.localized("config", "frame_rate_target", new Object[0]), fpsTransformer.toStep(instance.frameRateTarget()), 0, 68).setDefaultValue(fpsTransformer.toStep(standard.frameRateTarget())).setSaveConsumer(step -> instance.setFrameRateTarget(fpsTransformer.toValue((int)step))).setTextGetter(ClothConfig::fpsTargetMessage).build());
            category.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"options.vsync"), instance.enableVsync()).setDefaultValue(standard.enableVsync()).setSaveConsumer(instance::setEnableVsync).build());
            if (state.configurabilityLevel == PowerState.ConfigurabilityLevel.SOME) continue;
            SubCategoryBuilder volumes = entryBuilder.startSubCategory((class_2561)Localization.localized("config", "volume_multiplier", new Object[0]));
            for (class_3419 source : class_3419.values()) {
                String name = source.method_14840();
                volumes.add((AbstractConfigListEntry)entryBuilder.startIntSlider((class_2561)class_2561.method_43471((String)("soundCategory." + name)), (int)(instance.rawVolumeMultiplier(source) * 100.0f), 0, 100).setDefaultValue((int)(standard.rawVolumeMultiplier(source) * 100.0f)).setSaveConsumer(value -> instance.setVolumeMultiplier(source, (float)value.intValue() / 100.0f)).setTextGetter(ClothConfig::volumeMultiplierMessage).build());
            }
            category.addEntry((AbstractConfigListEntry)volumes.build());
            category.addEntry((AbstractConfigListEntry)entryBuilder.startEnumSelector((class_2561)Localization.localized("config", "graphics_state", new Object[0]), GraphicsState.class, (Enum)instance.graphicsState()).setDefaultValue((Enum)standard.graphicsState()).setSaveConsumer(instance::setGraphicsState).setEnumNameProvider(ClothConfig::graphicsStateMessage).setTooltipSupplier(ClothConfig::graphicsStateTooltip).build());
            category.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)Localization.localized("config", "show_toasts", new Object[0]), instance.showToasts()).setDefaultValue(standard.showToasts()).setSaveConsumer(instance::setShowToasts).setTooltip(new class_2561[]{Localization.localized("config", "show_toasts_tooltip", new Object[0])}).build());
            category.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)Localization.localized("config", "run_garbage_collector", new Object[0]), instance.runGarbageCollector()).setDefaultValue(standard.runGarbageCollector()).setSaveConsumer(instance::setRunGarbageCollector).setTooltip(new class_2561[]{Localization.localized("config", "run_garbage_collector_tooltip", new Object[0])}).build());
        }
        ConfigCategory advanced = builder.getOrCreateCategory((class_2561)Localization.localized("config", "category.advanced", new Object[0]));
        advanced.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)Localization.localized("config", "download_natives", new Object[0]), config.downloadNatives()).setDefaultValue(defaultConfig.downloadNatives()).setSaveConsumer(config::setDownloadNatives).setTooltip(new class_2561[]{Localization.localized("config", "download_natives_description_0", new Object[0]), Localization.localized("config", "download_natives_description_1", new Object[0])}).build());
        return builder.build();
    }

    private static class_2561 idleTimeMessage(int value) {
        if (value == 0) {
            return Localization.localized("config", "disabled", new Object[0]);
        }
        return Localization.localized("config", "minutes", value);
    }

    private static VariableStepTransformer getVolumeStepTransformer() {
        VariableStepTransformer transformer = new VariableStepTransformer();
        transformer.addStep(1, 50);
        transformer.addStep(5, 100);
        transformer.addStep(10, 200);
        transformer.addStep(100, 300);
        transformer.addStep(700, 1000);
        return transformer;
    }

    private static class_2561 volumeTransitionMessage(int step) {
        int value = ClothConfig.getVolumeStepTransformer().toValue(step);
        if (value <= 300) {
            return class_2561.method_43470((String)(value + "%"));
        }
        return Localization.localized("config", "volume_transition_speed_instant", new Object[0]);
    }

    private static VariableStepTransformer getFpsTransformer() {
        VariableStepTransformer transformer = new VariableStepTransformer();
        transformer.addStep(1, 20);
        transformer.addStep(2, 72);
        transformer.addStep(3, 75);
        transformer.addStep(5, 100);
        transformer.addStep(10, 260);
        return transformer;
    }

    private static class_2561 fpsTargetMessage(int step) {
        int fps = ClothConfig.getFpsTransformer().toValue(step);
        if (fps != 260) {
            return class_2561.method_43469((String)"options.framerate", (Object[])new Object[]{fps});
        }
        return class_2561.method_43471((String)"options.framerateLimit.max");
    }

    private static class_2561 volumeMultiplierMessage(int value) {
        return class_2561.method_43470((String)(Integer.toString(value) + "%"));
    }

    public static class_2561 IdleConditionMessage(Enum<IdleCondition> state) {
        return Localization.localized("config", "idle_condition_" + state.toString().toLowerCase(Locale.ROOT), new Object[0]);
    }

    private static class_2561 graphicsStateMessage(Enum<GraphicsState> graphicsState) {
        return Localization.localized("config", "graphics_state_" + graphicsState.toString().toLowerCase(Locale.ROOT), new Object[0]);
    }

    public static class_2561 batteryIndicatorConditionMessage(Enum<BatteryIndicatorCondition> state) {
        return Localization.localized("config", "battery_indicator_condition_" + state.toString().toLowerCase(Locale.ROOT), new Object[0]);
    }

    public static class_2561 batteryIndicatorPlacementMessage(Enum<BatteryIndicatorPlacement> state) {
        return Localization.localized("config", "battery_indicator_placement_" + state.toString().toLowerCase(Locale.ROOT), new Object[0]);
    }

    private static Optional<class_2561[]> graphicsStateTooltip(GraphicsState graphicsState) {
        if (!graphicsState.equals((Object)GraphicsState.MINIMAL)) {
            return Optional.empty();
        }
        return Optional.of(new class_2561[]{Localization.localized("config", "graphics_state_minimal_tooltip", new Object[0]).method_27692(class_124.field_1061)});
    }
}

