/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers.render;

import dev.tr7zw.skinlayers.api.Mesh;
import dev.tr7zw.skinlayers.api.MeshTransformer;
import dev.tr7zw.skinlayers.api.SkinLayersAPI;
import dev.tr7zw.skinlayers.versionless.render.CustomModelPart;
import dev.tr7zw.skinlayers.versionless.render.CustomizableCube;
import java.util.List;
import java.util.Map;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5603;
import net.minecraft.class_630;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class CustomizableModelPart
extends CustomModelPart
implements Mesh {
    private final List<class_630.class_628> cubes;
    private final Map<String, class_630> children;
    private Vector4f[] vector4f = new Vector4f[]{new Vector4f(), new Vector4f(), new Vector4f(), new Vector4f()};

    public CustomizableModelPart(List<class_630.class_628> list, List<CustomizableCube> customCubes, Map<String, class_630> map) {
        super(customCubes);
        this.cubes = list;
        this.children = map;
    }

    @Override
    public void loadPose(class_5603 partPose) {
        this.x = partPose.field_27702;
        this.y = partPose.field_27703;
        this.z = partPose.field_27704;
        this.xRot = partPose.field_27705;
        this.yRot = partPose.field_27706;
        this.zRot = partPose.field_27707;
    }

    @Override
    public void copyFrom(class_630 modelPart) {
        this.xRot = modelPart.field_3654;
        this.yRot = modelPart.field_3675;
        this.zRot = modelPart.field_3674;
        this.x = modelPart.field_3657;
        this.y = modelPart.field_3656;
        this.z = modelPart.field_3655;
    }

    @Override
    public void render(class_4587 poseStack, class_4588 vertexConsumer, int i, int j) {
        this.render(null, poseStack, vertexConsumer, i, j, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    private int convertFloatColorToInteger(float color) {
        return color > 1.0f ? 255 : Math.round(color * 255.0f);
    }

    @Deprecated(forRemoval=true)
    public void render(class_630 vanillaModel, class_4587 poseStack, class_4588 vertexConsumer, int light, int overlay, float red, float green, float blue, float alpha) {
        int color = (this.convertFloatColorToInteger(alpha) & 0xFF) << 24 | (this.convertFloatColorToInteger(red) & 0xFF) << 16 | (this.convertFloatColorToInteger(green) & 0xFF) << 8 | this.convertFloatColorToInteger(blue) & 0xFF;
        this.render(vanillaModel, poseStack, vertexConsumer, light, overlay, color);
    }

    @Override
    public void render(class_630 vanillaModel, class_4587 poseStack, class_4588 vertexConsumer, int light, int overlay, int color) {
        if (!this.visible) {
            return;
        }
        poseStack.method_22903();
        this.translateAndRotate(poseStack);
        this.compile(vanillaModel, poseStack.method_23760(), vertexConsumer, light, overlay, color);
        for (class_630 modelPart : this.children.values()) {
            modelPart.method_22699(poseStack, vertexConsumer, light, overlay, color);
        }
        poseStack.method_22909();
    }

    public void translateAndRotate(class_4587 poseStack) {
        poseStack.method_46416(this.x / 16.0f, this.y / 16.0f, this.z / 16.0f);
        if (this.xRot != 0.0f || this.yRot != 0.0f || this.zRot != 0.0f) {
            poseStack.method_22907(new Quaternionf().rotationZYX(this.zRot, this.yRot, this.xRot));
        }
    }

    private void compile(class_630 vanillaModel, class_4587.class_4665 pose, class_4588 vertexConsumer, int light, int overlay, int color) {
        MeshTransformer transformer = SkinLayersAPI.getMeshTransformerProvider().prepareTransformer(vanillaModel);
        Matrix4f matrix4f = pose.method_23761();
        Matrix3f matrix3f = pose.method_23762();
        for (int id = 0; id < this.polygonData.length; id += 23) {
            int o;
            Vector3f vector3f = new Vector3f(this.polygonData[id + 0], this.polygonData[id + 1], this.polygonData[id + 2]);
            for (o = 0; o < 4; ++o) {
                this.vector4f[o].set(this.polygonData[id + 3 + o * 5 + 0], this.polygonData[id + 3 + o * 5 + 1], this.polygonData[id + 3 + o * 5 + 2], 1.0f);
            }
            transformer.transform(vector3f, this.vector4f);
            vector3f = matrix3f.transform(vector3f);
            for (o = 0; o < 4; ++o) {
                matrix4f.transform(this.vector4f[o]);
                vertexConsumer.method_22912(this.vector4f[o].x(), this.vector4f[o].y(), this.vector4f[o].z());
                vertexConsumer.method_39415(color);
                vertexConsumer.method_22913(this.polygonData[id + 3 + o * 5 + 3], this.polygonData[id + 3 + o * 5 + 4]);
                vertexConsumer.method_22922(overlay);
                vertexConsumer.method_60803(light);
                vertexConsumer.method_22914(vector3f.x(), vector3f.y(), vector3f.z());
            }
        }
        for (class_630.class_628 cube : this.cubes) {
            transformer.transform(cube);
            cube.method_32089(pose, vertexConsumer, light, overlay, color);
        }
    }
}

