/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.config;

import com.greymerk.roguelike.Roguelike;
import com.greymerk.roguelike.config.IConfigStore;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Optional;
import org.apache.commons.io.IOUtils;

public class ConfigFile
implements IConfigStore {
    private static final String configDirPath = "config";
    private static final String configFilePath = "roguelike-dungeons.json";
    private static final String configFullPath = "config" + File.separatorChar + "roguelike-dungeons.json";

    @Override
    public Optional<String> getFileContents() {
        File file = new File(configFullPath);
        if (!file.exists()) {
            return Optional.empty();
        }
        try {
            return Optional.of(IOUtils.toString((Reader)new FileReader(file)));
        }
        catch (FileNotFoundException e) {
            return Optional.empty();
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    @Override
    public void write(String content) {
        File directory = new File(configDirPath);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        try {
            FileWriter writer = new FileWriter(configFullPath);
            writer.flush();
            writer.write(content);
            writer.close();
        }
        catch (IOException e) {
            Roguelike.LOGGER.error(e.getMessage());
        }
    }

    @Override
    public boolean exists() {
        File f = new File(configFullPath);
        return f.exists();
    }
}

