/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.dungeon;

import com.google.common.base.Stopwatch;
import com.greymerk.roguelike.debug.Debug;
import com.greymerk.roguelike.dungeon.layout.LayoutManager;
import com.greymerk.roguelike.dungeon.room.IRoom;
import com.greymerk.roguelike.dungeon.room.Room;
import com.greymerk.roguelike.dungeon.tower.RogueTower;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.boundingbox.BoundingBox;
import com.greymerk.roguelike.editor.boundingbox.IBounded;
import com.greymerk.roguelike.settings.LevelSettings;
import com.greymerk.roguelike.state.RoguelikeState;
import com.greymerk.roguelike.theme.Theme;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_5819;

public class Dungeon
implements Iterable<IRoom> {
    List<IRoom> rooms = new ArrayList<IRoom>();
    Coord origin;
    BoundingBox bb;

    public static boolean generate(IWorldEditor editor, Coord pos) {
        return Dungeon.generate(editor, pos, false);
    }

    public static boolean generate(IWorldEditor editor, Coord pos, boolean force) {
        if (!Dungeon.canSpawn(editor, pos) && !force) {
            return false;
        }
        Dungeon donjon = new Dungeon(pos.copy());
        donjon.generate(editor);
        editor.getState().addDungeon(donjon);
        RoguelikeState.flagForGenerationCheck = true;
        return true;
    }

    public Dungeon(Coord pos) {
        this.bb = BoundingBox.of(pos.copy());
        this.origin = pos;
    }

    public Dungeon(class_2487 tag) {
        class_2499 rooms = tag.method_10554("rooms", 10);
        for (class_2520 nbt : rooms) {
            this.rooms.add(Room.createFromNBT((class_2487)nbt));
        }
        this.origin = Coord.of(tag.method_10562("pos"));
        this.bb = new BoundingBox(tag.method_10562("bounds"));
    }

    public static boolean canSpawn(IWorldEditor editor, Coord pos) {
        if (!editor.isOverworld()) {
            return false;
        }
        Coord surface = editor.findSurface(pos);
        return editor.getBlock(surface).isGround();
    }

    public class_2487 getNbt() {
        class_2487 data = new class_2487();
        class_2499 roomlist = new class_2499();
        for (IRoom room : this.rooms) {
            roomlist.add((Object)room.getNbt());
        }
        data.method_10566("rooms", (class_2520)roomlist);
        data.method_10566("pos", this.origin.getNbt());
        data.method_10566("bounds", (class_2520)this.bb.getNbt());
        return data;
    }

    public void generate(IWorldEditor editor) {
        class_5819 rand = editor.getRandom(this.origin);
        Stopwatch watch = Stopwatch.createStarted();
        Coord surface = editor.findSurface(this.origin);
        int entranceY = surface.getY() - surface.getY() % 10 - 10;
        Coord firstFloor = new Coord(this.origin.getX(), entranceY, this.origin.getZ());
        LayoutManager layout = new LayoutManager(firstFloor);
        IRoom entrance = Room.getInstance(Room.ENTRANCE, LevelSettings.fromType(LevelSettings.OAK), new Coord(0, 0, 0), firstFloor);
        entrance.generate(editor);
        entrance.setGenerated(true);
        layout.addEntrance(entrance);
        layout.generate(editor);
        this.rooms = layout.getRooms();
        this.rooms.forEach(r -> this.bb.combine(r.getBoundingBox().get()));
        RogueTower tower = new RogueTower();
        tower.generate(editor, rand, Theme.getTheme(Theme.TOWER), firstFloor);
        Debug.info("Dungeon @: " + String.valueOf(surface) + " in: " + watch.elapsed(TimeUnit.MILLISECONDS) + "ms");
    }

    public boolean isGenerated() {
        for (IRoom room : this.rooms) {
            if (room.isGenerated()) continue;
            return false;
        }
        return true;
    }

    public IBounded getBounds() {
        return this.bb;
    }

    public static int getLevelFromY(int y) {
        if (y > 60) {
            return 0;
        }
        return Math.abs(y / 10 - 6);
    }

    @Override
    public Iterator<IRoom> iterator() {
        return this.rooms.iterator();
    }
}

