/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.dungeon.cell;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.greymerk.roguelike.dungeon.cell.CellState;
import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class Cell {
    public static final int SIZE = 6;
    private CellState state;
    private Coord floorPos;
    private Set<Cardinal> walls;

    public static Cell of(Coord floorPos, CellState state) {
        return new Cell(floorPos, state);
    }

    public Cell(Coord floorPos, CellState state) {
        this.floorPos = floorPos.copy();
        this.state = state;
        this.walls = new HashSet<Cardinal>();
    }

    public CellState getState() {
        return this.state;
    }

    public void setState(CellState state) {
        this.state = state;
    }

    public void replace(Cell other) {
        this.floorPos = other.floorPos.copy();
        this.state = other.state;
        this.walls.addAll(other.walls);
    }

    public boolean isRoom() {
        return this.state == CellState.OBSTRUCTED;
    }

    public Coord getFloorPos() {
        return this.floorPos.copy();
    }

    public int getLevelOffset() {
        return this.floorPos.getY() * -1;
    }

    public Coord getWorldPos(Coord origin) {
        return this.floorPos.copy().mul(new Coord(6, 1, 6)).add(origin);
    }

    public Cell addWall(Cardinal dir) {
        this.walls.add(dir);
        return this;
    }

    public Cell addWalls(List<Cardinal> directions) {
        directions.forEach(dir -> this.addWall((Cardinal)((Object)dir)));
        return this;
    }

    public boolean hasWall(Cardinal dir) {
        return this.walls.contains((Object)dir);
    }

    public boolean hasWalls() {
        return !this.walls.isEmpty();
    }

    public List<Cardinal> getWalls() {
        return new ArrayList<Cardinal>(this.walls);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.floorPos, this.state});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Cell other = (Cell)obj;
        return Objects.equals(this.floorPos, other.floorPos) && this.state == other.state;
    }

    public String toString() {
        return this.floorPos.toString() + " " + String.valueOf((Object)this.state) + " " + String.valueOf(this.walls);
    }

    public JsonElement asJson() {
        JsonObject jsonCell = new JsonObject();
        jsonCell.add("floorPos", this.floorPos.asJson());
        jsonCell.addProperty("state", this.state.name());
        JsonArray jsonWalls = new JsonArray();
        this.walls.forEach(dir -> jsonWalls.add(dir.name()));
        jsonCell.add("walls", (JsonElement)jsonWalls);
        return jsonCell;
    }
}

