/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.dungeon.layout;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.greymerk.roguelike.config.Config;
import com.greymerk.roguelike.debug.DebugLayout;
import com.greymerk.roguelike.dungeon.Dungeon;
import com.greymerk.roguelike.dungeon.Floor;
import com.greymerk.roguelike.dungeon.cell.Cell;
import com.greymerk.roguelike.dungeon.cell.CellManager;
import com.greymerk.roguelike.dungeon.cell.CellState;
import com.greymerk.roguelike.dungeon.layout.ExclusionZones;
import com.greymerk.roguelike.dungeon.room.IRoom;
import com.greymerk.roguelike.dungeon.room.Room;
import com.greymerk.roguelike.dungeon.room.RoomProvider;
import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.settings.IDungeonSettings;
import com.greymerk.roguelike.settings.dungeon.DungeonSettingsDefault;
import com.greymerk.roguelike.util.math.RandHelper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_5819;

public class LayoutManager {
    private Coord origin;
    private List<Floor> floors;
    private IDungeonSettings settings;
    private ExclusionZones zones;

    public LayoutManager(Coord origin) {
        this.origin = origin;
        this.floors = this.createFloors();
        this.settings = new DungeonSettingsDefault();
        this.zones = new ExclusionZones();
    }

    public void generate(IWorldEditor editor) {
        class_5819 rand = editor.getRandom(this.origin);
        for (Floor floor : this.floors) {
            int level = Dungeon.getLevelFromY(floor.getOrigin().getY());
            if (level == 0) {
                this.addStair(editor, rand, floor);
                continue;
            }
            RoomProvider roomProvider = this.settings.getLevel(floor.getOrigin().getY()).getRooms();
            int numRooms = Math.clamp((long)Config.ofInteger(Config.ROOMS_PER_LEVEL).orElse(20).intValue(), 1, 1000);
            List<Room> rooms = roomProvider.getRooms(rand, numRooms);
            rooms.forEach(r -> {
                IRoom room = Room.getInstance(r, this.settings.getLevel(floor.getOrigin().getY()));
                this.placeRoom(room, rand, floor);
            });
            if (level > 0) {
                this.addStair(editor, rand, floor);
            }
            floor.getRooms().forEach(r -> r.determineEntrances(floor, r.getFloorPos()));
        }
        if (Config.ofBoolean(Config.DEBUG).booleanValue()) {
            DebugLayout debug = new DebugLayout(editor.getWorldDirectory());
            debug.toFile(this.origin.getX() + "_" + this.origin.getZ() + ".json", this.asJson());
        }
    }

    private void placeRoom(IRoom room, class_5819 rand, Floor floor) {
        if (this.findFit(room, rand, floor, true)) {
            return;
        }
        this.findFit(room, rand, floor, false);
    }

    private boolean findFit(IRoom room, class_5819 rand, Floor floor, boolean avoidZones) {
        List<Cell> cells = floor.getCells(CellState.POTENTIAL);
        RandHelper.shuffle(cells, rand);
        for (Cell potential : cells) {
            List<Cardinal> dirs = this.getPotentialDir(floor, potential);
            RandHelper.shuffle(dirs, rand);
            for (Cardinal dir : dirs) {
                Coord wp = potential.getWorldPos(floor.getOrigin());
                if (avoidZones && this.zones.collides(room.getBoundingBox(wp, dir))) continue;
                CellManager rcm = room.getCells(dir);
                if (!floor.getCells().roomFits(potential, rcm)) continue;
                this.addRoom(room, dir, potential.getFloorPos(), wp, floor);
                return true;
            }
        }
        return false;
    }

    private List<Cardinal> getPotentialDir(Floor floor, Cell cell) {
        ArrayList<Cardinal> dirs = new ArrayList<Cardinal>();
        for (Cardinal dir : Cardinal.directions) {
            Coord fp = cell.getFloorPos();
            fp.add(Cardinal.reverse(dir));
            Cell target = floor.getCell(fp);
            if (target.getState() != CellState.OBSTRUCTED || target.hasWall(dir)) continue;
            dirs.add(dir);
        }
        return dirs;
    }

    private void addStair(IWorldEditor editor, class_5819 rand, Floor floor) {
        if (this.floors.indexOf(floor) >= this.floors.size() - 1) {
            return;
        }
        IRoom stairway = Room.getInstance(Room.STAIRWAY, this.settings.getLevel(floor.getOrigin().getY()));
        this.placeRoom(stairway, rand, floor);
        this.zones.scan(editor, stairway.getWorldPos(), 500);
    }

    public void addEntrance(IRoom room) {
        Floor f = this.floors.get(0);
        Coord fp = new Coord(0, 0, 0);
        Coord wp = f.getOrigin();
        this.addRoom(room, Cardinal.NORTH, fp, wp, f);
    }

    public void addRoom(IRoom toAdd, Cardinal dir, Coord fp, Coord wp, Floor floor) {
        int level = this.floors.indexOf(floor);
        toAdd.setDirection(dir);
        toAdd.setFloorPos(fp);
        toAdd.setWorldPos(wp);
        floor.addRoom(toAdd);
        CellManager cells = toAdd.getCells(dir);
        cells.getLevelOffsets().forEach(offset -> {
            Floor f = this.floors.get(level + offset);
            cells.getByOffset((int)offset).forEach(c -> {
                Coord cfp = new Coord(c.getFloorPos().getX(), 0, c.getFloorPos().getZ());
                cfp.add(fp);
                f.addCell(Cell.of(cfp, c.getState()).addWalls(c.getWalls()));
            });
        });
    }

    private List<Floor> createFloors() {
        int depth = -50;
        ArrayList<Floor> floors = new ArrayList<Floor>();
        for (int y = this.origin.getY(); y >= depth; y -= 10) {
            floors.add(new Floor(new Coord(this.origin.getX(), y, this.origin.getZ())));
        }
        return floors;
    }

    public List<IRoom> getRooms() {
        ArrayList<IRoom> rooms = new ArrayList<IRoom>();
        for (Floor floor : this.floors) {
            rooms.addAll(floor.getRooms());
        }
        return rooms;
    }

    public JsonObject asJson() {
        JsonObject json = new JsonObject();
        JsonArray jsonFloors = new JsonArray();
        json.add("floors", (JsonElement)jsonFloors);
        this.floors.forEach(f -> jsonFloors.add(f.asJson()));
        return json;
    }

    public class CenterSort
    implements Comparator<Cell> {
        public CenterSort(LayoutManager this$0) {
        }

        @Override
        public int compare(Cell c, Cell other) {
            Coord center = new Coord(0, 0, 0);
            int distC = (int)c.getFloorPos().distance(center);
            int distOther = (int)other.getFloorPos().distance(center);
            return Integer.compare(distC, distOther);
        }
    }
}

