/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.dungeon.room;

import com.greymerk.roguelike.dungeon.fragment.Fragment;
import com.greymerk.roguelike.dungeon.fragment.parts.CellSupport;
import com.greymerk.roguelike.dungeon.fragment.parts.Pillar;
import com.greymerk.roguelike.dungeon.layout.Entrance;
import com.greymerk.roguelike.dungeon.room.AbstractLargeRoom;
import com.greymerk.roguelike.dungeon.room.IRoom;
import com.greymerk.roguelike.dungeon.room.Room;
import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.MetaBlock;
import com.greymerk.roguelike.editor.blocks.Air;
import com.greymerk.roguelike.editor.blocks.Candle;
import com.greymerk.roguelike.editor.boundingbox.BoundingBox;
import java.util.List;
import net.minecraft.class_2246;
import net.minecraft.class_5819;

public class BanquetRoom
extends AbstractLargeRoom
implements IRoom {
    @Override
    public void generate(IWorldEditor editor) {
        Coord origin = this.getWorldPos().copy().add(this.direction, 12).freeze();
        class_5819 rand = editor.getRandom(origin);
        this.clear(editor, rand, origin);
        this.ceiling(editor, rand, origin);
        this.pillars(editor, rand, origin);
        this.decorations(editor, rand, origin);
        this.tables(editor, rand, origin);
        this.supports(editor, rand, origin);
    }

    private void supports(IWorldEditor editor, class_5819 rand, Coord origin) {
        CellSupport.generate(editor, rand, this.theme, origin);
        Cardinal.directions.forEach(dir -> List.of(Integer.valueOf(6), Integer.valueOf(12)).forEach(i -> {
            CellSupport.generate(editor, rand, this.theme, origin.copy().add((Cardinal)((Object)dir), (int)i));
            List.of(Integer.valueOf(6), Integer.valueOf(12)).forEach(j -> CellSupport.generate(editor, rand, this.theme, origin.copy().add((Cardinal)((Object)dir), (int)i).add(Cardinal.left(dir), (int)j)));
        }));
    }

    private void tables(IWorldEditor editor, class_5819 rand, Coord origin) {
        Cardinal.orthogonal(this.direction).forEach(o -> this.table(editor, rand, origin.copy().add((Cardinal)((Object)o), 3).freeze(), (Cardinal)((Object)o)));
    }

    private void table(IWorldEditor editor, class_5819 rand, Coord origin, Cardinal dir) {
        BoundingBox.of(origin).grow(Cardinal.orthogonal(dir), 3).fill(editor, rand, this.theme.getSecondary().getWall());
        Cardinal.parallel(dir).forEach(p -> {
            this.theme.getSecondary().getStair().setOrientation((Cardinal)((Object)p), true).fill(editor, rand, BoundingBox.of(origin).add((Cardinal)((Object)p)).grow(Cardinal.orthogonal(dir), 4));
            Cardinal.orthogonal(dir).forEach(o -> {
                this.theme.getSecondary().getStair().setOrientation(Cardinal.reverse(p), false).set(editor, rand, origin.copy().add((Cardinal)((Object)p), 2).add((Cardinal)((Object)((Object)o))));
                this.theme.getSecondary().getStair().setOrientation(Cardinal.reverse(p), false).set(editor, rand, origin.copy().add((Cardinal)((Object)p), 2).add((Cardinal)((Object)((Object)o)), 3));
            });
            BoundingBox.of(origin).add(Cardinal.UP).add((Cardinal)((Object)p)).grow(Cardinal.orthogonal(dir), 4).forEach(pos -> {
                if (rand.method_43048(3) == 0) {
                    MetaBlock.of(class_2246.field_10495).set(editor, (Coord)pos);
                }
            });
        });
        Cardinal.orthogonal(dir).forEach(o -> {
            this.theme.getSecondary().getStair().setOrientation((Cardinal)((Object)o), true).set(editor, rand, origin.copy().add((Cardinal)((Object)o), 4));
            this.theme.getSecondary().getStair().setOrientation(Cardinal.reverse(o), false).set(editor, rand, origin.copy().add((Cardinal)((Object)o), 5));
        });
        BoundingBox.of(origin).add(Cardinal.UP).grow(Cardinal.orthogonal(dir), 3).forEach(pos -> {
            if (rand.method_43056()) {
                Candle.generate(editor, rand, pos);
            }
        });
    }

    private void decorations(IWorldEditor editor, class_5819 rand, Coord origin) {
        Cardinal.directions.forEach(dir -> Cardinal.orthogonal(dir).forEach(o -> List.of(Integer.valueOf(6), Integer.valueOf(12)).forEach(step -> this.settings.getWallFragment(rand).generate(editor, rand, this.theme, origin.copy().add((Cardinal)((Object)dir), 12).add((Cardinal)((Object)((Object)o)), (int)step), (Cardinal)((Object)dir)))));
    }

    private void pillars(IWorldEditor editor, class_5819 rand, Coord origin) {
        Cardinal.directions.forEach(dir -> {
            Cardinal.orthogonal(dir).forEach(o -> List.of(Integer.valueOf(3), Integer.valueOf(9)).forEach(step -> this.pillarSet(editor, rand, origin.copy().add((Cardinal)((Object)dir), 9).add((Cardinal)((Object)((Object)o)), (int)step).freeze(), (Cardinal)((Object)dir))));
            Pillar.generate(editor, rand, origin.copy().add((Cardinal)((Object)dir), 14).add(Cardinal.left(dir), 14), this.theme, 2, List.of(Cardinal.reverse(dir), Cardinal.right(dir)));
        });
    }

    private void pillarSet(IWorldEditor editor, class_5819 rand, Coord origin, Cardinal dir) {
        Pillar.generate(editor, rand, origin, this.theme, 3);
        this.theme.getPrimary().getWall().set(editor, rand, origin.copy().add(Cardinal.UP, 5));
        this.theme.getPrimary().getStair().setOrientation(Cardinal.reverse(dir), true).set(editor, rand, origin.copy().add(dir, 5).add(Cardinal.UP, 2));
        Cardinal.orthogonal(dir).forEach(o -> {
            Pillar.generate(editor, rand, origin.copy().add((Cardinal)((Object)o)).add(dir, 5), this.theme, 2, List.of(o, dir, Cardinal.reverse(dir)));
            this.theme.getPrimary().getStair().setOrientation(Cardinal.reverse(dir), true).set(editor, rand, origin.copy().add((Cardinal)((Object)o)).add(dir, 3).add(Cardinal.UP, 3));
            this.theme.getPrimary().getWall().set(editor, rand, origin.copy().add((Cardinal)((Object)o)).add(dir, 4).add(Cardinal.UP, 3));
        });
    }

    private void ceiling(IWorldEditor editor, class_5819 rand, Coord origin) {
        Cardinal.directions.forEach(dir -> {
            List.of(Integer.valueOf(8), Integer.valueOf(10), Integer.valueOf(14)).forEach(step -> BoundingBox.of(origin).add(Cardinal.UP, 4).add((Cardinal)((Object)dir), (int)step).grow(Cardinal.orthogonal(dir), 15).fill(editor, rand, this.theme.getPrimary().getWall()));
            List.of(Integer.valueOf(2), Integer.valueOf(4), Integer.valueOf(8)).forEach(step -> BoundingBox.of(origin).add(Cardinal.UP, 5).add((Cardinal)((Object)dir), (int)step).grow(Cardinal.orthogonal(dir), 15).fill(editor, rand, this.theme.getPrimary().getWall()));
            List.of(Integer.valueOf(2), Integer.valueOf(4)).forEach(step -> Cardinal.orthogonal(dir).forEach(o -> BoundingBox.of(origin).add((Cardinal)((Object)dir), 9).add((Cardinal)((Object)((Object)((Object)o))), (int)step).add(Cardinal.UP, 4).grow((Cardinal)((Object)dir), 4).fill(editor, rand, this.theme.getPrimary().getWall())));
            BoundingBox.of(origin).add(Cardinal.UP, 5).add((Cardinal)((Object)dir), 9).grow((Cardinal)((Object)dir), 5).grow(Cardinal.left(dir), 14).grow(Cardinal.right(dir), 8).fill(editor, rand, this.theme.getPrimary().getWall(), false, true);
            BoundingBox.of(origin).add(Cardinal.UP, 3).add((Cardinal)((Object)dir), 14).grow(Cardinal.UP).grow(Cardinal.orthogonal(dir), 14).fill(editor, rand, this.theme.getPrimary().getWall());
        });
        BoundingBox.of(origin).add(Cardinal.UP, 6).grow(Cardinal.directions, 8).fill(editor, rand, this.theme.getPrimary().getWall(), false, true);
    }

    private void clear(IWorldEditor editor, class_5819 rand, Coord origin) {
        BoundingBox.of(origin).grow(Cardinal.directions, 14).grow(Cardinal.UP, 4).fill(editor, rand, Air.get());
        BoundingBox.of(origin).add(Cardinal.UP, 5).grow(Cardinal.directions, 8).fill(editor, rand, Air.get());
        Cardinal.directions.forEach(dir -> BoundingBox.of(origin).add((Cardinal)((Object)dir), 15).grow(Cardinal.DOWN).grow(Cardinal.UP, 4).grow(Cardinal.orthogonal(dir), 15).fill(editor, rand, this.theme.getPrimary().getWall(), false, true));
        BoundingBox.of(origin).add(Cardinal.DOWN).grow(Cardinal.directions, 15).fill(editor, rand, this.theme.getPrimary().getFloor());
        this.getEntrancesFromType(Entrance.DOOR).forEach(dir -> Fragment.generate(Fragment.ARCH, editor, rand, this.theme, origin.copy().add((Cardinal)((Object)dir), 12), dir));
    }

    @Override
    public String getName() {
        return Room.BANQUET.name();
    }
}

