/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.dungeon.room;

import com.greymerk.roguelike.dungeon.Floor;
import com.greymerk.roguelike.dungeon.cell.Cell;
import com.greymerk.roguelike.dungeon.cell.CellManager;
import com.greymerk.roguelike.dungeon.cell.CellState;
import com.greymerk.roguelike.dungeon.fragment.Fragment;
import com.greymerk.roguelike.dungeon.fragment.parts.CellSupport;
import com.greymerk.roguelike.dungeon.fragment.wall.WallFlowers;
import com.greymerk.roguelike.dungeon.layout.Entrance;
import com.greymerk.roguelike.dungeon.room.AbstractRoom;
import com.greymerk.roguelike.dungeon.room.Corridor;
import com.greymerk.roguelike.dungeon.room.IRoom;
import com.greymerk.roguelike.dungeon.room.Room;
import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.IBlockFactory;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.blocks.Air;
import com.greymerk.roguelike.editor.blocks.Bed;
import com.greymerk.roguelike.editor.blocks.BlockType;
import com.greymerk.roguelike.editor.blocks.Candle;
import com.greymerk.roguelike.editor.blocks.Furnace;
import com.greymerk.roguelike.editor.blocks.Lantern;
import com.greymerk.roguelike.editor.blocks.stair.IStair;
import com.greymerk.roguelike.editor.boundingbox.BoundingBox;
import com.greymerk.roguelike.editor.shapes.RectHollow;
import com.greymerk.roguelike.editor.shapes.RectSolid;
import com.greymerk.roguelike.editor.shapes.Shape;
import com.greymerk.roguelike.treasure.Treasure;
import java.util.ArrayList;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_5819;

public class BedRoom
extends AbstractRoom
implements IRoom {
    @Override
    public void generate(IWorldEditor editor) {
        Coord origin = this.getWorldPos();
        class_5819 rand = editor.getRandom(origin);
        Corridor cor = new Corridor();
        for (Object dir2 : this.entrances.keySet()) {
            if (this.entrances.get(dir2) != Entrance.DOOR) continue;
            cor.addEntrance((Cardinal)((Object)dir2), Entrance.DOOR);
        }
        cor.setLevelSettings(this.settings);
        cor.worldPos = this.worldPos.copy();
        cor.addEntrance(this.direction, Entrance.DOOR);
        cor.generate(editor);
        BoundingBox bb = BoundingBox.of(origin);
        bb.add(this.direction, 3).grow(Cardinal.DOWN).grow(Cardinal.UP, 3);
        bb.grow(this.direction, 12).grow(Cardinal.orthogonal(this.direction), 4);
        RectHollow.fill(editor, rand, bb, this.theme.getPrimary().getWall());
        bb = BoundingBox.of(origin);
        bb.add(this.direction, 5).add(Cardinal.DOWN);
        bb.grow(Cardinal.orthogonal(this.direction), 2).grow(this.direction, 8);
        RectSolid.fill(editor, rand, bb, this.theme.getSecondary().getFloor());
        for (Cardinal o : Cardinal.orthogonal(this.direction)) {
            bb = BoundingBox.of(origin);
            bb.add(this.direction, 4).add(o, 3).grow(Cardinal.UP, 4);
            RectSolid.fill(editor, rand, bb, this.theme.getPrimary().getWall());
            bb.add(this.direction, 10);
            RectSolid.fill(editor, rand, bb, this.theme.getPrimary().getWall());
        }
        Coord pos = origin.copy().add(this.direction, 3);
        this.theme.getPrimary().getDoor().generate(editor, pos, Cardinal.reverse(this.direction));
        this.setPillars(editor, rand, origin);
        this.ceiling(editor, rand, origin);
        this.decorations(editor, rand, origin);
        this.getEntrancesFromType(Entrance.DOOR).forEach(dir -> Fragment.generate(Fragment.ARCH, editor, rand, this.theme, origin.copy(), dir));
        CellSupport.generate(editor, rand, this.theme, origin.copy().add(this.direction, 6));
        CellSupport.generate(editor, rand, this.theme, origin.copy().add(this.direction, 12));
    }

    private void setPillars(IWorldEditor editor, class_5819 rand, Coord origin) {
        ArrayList<Coord> stops = new ArrayList<Coord>();
        Coord pos = origin.copy();
        pos.add(this.direction, 5);
        stops.add(pos.copy());
        pos.add(this.direction, 4);
        stops.add(pos.copy());
        pos.add(this.direction, 4);
        stops.add(pos.copy());
        for (Cardinal o : Cardinal.orthogonal(this.direction)) {
            for (Coord p : stops) {
                Coord c = p.copy().add(o, 3);
                this.pillar(editor, rand, c);
            }
        }
        pos = origin.copy();
        pos.add(this.direction, 4);
        for (Cardinal o : Cardinal.orthogonal(this.direction)) {
            Coord p = pos.copy();
            p.add(o, 2);
            this.pillar(editor, rand, p);
            p.add(this.direction, 10);
            this.pillar(editor, rand, p);
        }
    }

    private void pillar(IWorldEditor editor, class_5819 rand, Coord origin) {
        IBlockFactory pillar = this.theme.getSecondary().getPillar();
        IBlockFactory wall = this.theme.getSecondary().getWall();
        IStair stair = this.theme.getSecondary().getStair();
        Coord pos = origin.copy();
        pillar.set(editor, rand, pos);
        pos.add(Cardinal.UP);
        pillar.set(editor, rand, pos);
        pos.add(Cardinal.UP);
        wall.set(editor, rand, pos);
        for (Cardinal dir : Cardinal.directions) {
            Coord p = pos.copy();
            p.add(dir);
            stair.setOrientation(dir, true);
            stair.set(editor, rand, p, true, false);
        }
    }

    private void ceiling(IWorldEditor editor, class_5819 rand, Coord origin) {
        BoundingBox bb = BoundingBox.of(origin);
        bb.add(this.direction, 5).add(Cardinal.UP, 4);
        bb.grow(Cardinal.orthogonal(this.direction), 2).grow(this.direction, 8);
        RectSolid.fill(editor, rand, bb, this.theme.getPrimary().getWall());
        bb.add(Cardinal.UP);
        RectSolid.fill(editor, rand, bb, this.theme.getSecondary().getWall());
        bb = BoundingBox.of(origin);
        bb.add(this.direction, 7).add(Cardinal.UP, 3);
        bb.grow(Cardinal.directions).grow(Cardinal.UP);
        RectSolid.fill(editor, rand, bb, Air.get());
        bb.add(this.direction, 4);
        RectSolid.fill(editor, rand, bb, Air.get());
        for (Object dir : Cardinal.directions) {
            if (dir == this.direction) continue;
            bb = BoundingBox.of(origin);
            bb.add(this.direction, 7).add(Cardinal.UP, 3).add((Cardinal)((Object)dir), 2);
            bb.grow(Cardinal.orthogonal(dir));
            IStair stair = this.theme.getPrimary().getStair();
            stair.setOrientation(Cardinal.reverse(dir), true);
            for (Object c : bb.getShape(Shape.RECTSOLID)) {
                stair.set(editor, rand, (Coord)c);
            }
        }
        Coord pos = origin.copy().add(this.direction, 7).add(Cardinal.UP, 3);
        pos.add(Cardinal.UP);
        Lantern.set(editor, pos);
        pos.add(this.direction, 4);
        Lantern.set(editor, pos);
        pos.add(Cardinal.DOWN);
        for (Cardinal dir : Cardinal.directions) {
            if (dir == Cardinal.reverse(this.direction)) continue;
            bb = BoundingBox.of(origin);
            bb.add(this.direction, 7).add(Cardinal.UP, 3).add(dir, 2);
            bb.grow(Cardinal.orthogonal(dir));
            IStair stair = this.theme.getPrimary().getStair();
            stair.setOrientation(Cardinal.reverse(dir), true);
            for (Coord c : bb.getShape(Shape.RECTSOLID)) {
                stair.set(editor, rand, c);
            }
        }
        pos = origin.copy().add(this.direction, 9).add(Cardinal.UP, 3);
        Air.get().set(editor, pos);
        IStair stair = this.theme.getPrimary().getStair();
        for (Cardinal o : Cardinal.orthogonal(this.direction)) {
            Coord p = pos.copy();
            p.add(o);
            stair.setOrientation(Cardinal.reverse(o), true);
            stair.set(editor, rand, p);
        }
    }

    private void decorations(IWorldEditor editor, class_5819 rand, Coord origin) {
        for (Cardinal o : Cardinal.orthogonal(this.direction)) {
            Coord pos = origin.copy();
            pos.add(this.direction, 7);
            pos.add(o);
            new WallFlowers().generate(editor, rand, this.theme, pos, o);
        }
        Coord pos = origin.copy();
        pos.add(this.direction, 11);
        pos.add(Cardinal.left(this.direction), 3);
        Bed.generate(editor, rand, Cardinal.right(this.direction), pos);
        pos.add(this.direction);
        BlockType.get(BlockType.SHELF).set(editor, pos);
        pos.add(Cardinal.UP);
        Candle.generate(editor, rand, pos);
        pos = origin.copy();
        pos.add(this.direction, 12);
        new WallFlowers().generate(editor, rand, this.theme, pos, this.direction);
        pos = origin.copy();
        pos.add(this.direction, 10);
        pos.add(Cardinal.right(this.direction), 3);
        Treasure.generate(editor, rand, pos, Cardinal.left(this.direction), Treasure.STARTER);
        pos.add(this.direction);
        BlockType.get(BlockType.CRAFTING_TABLE).set(editor, pos);
        pos.add(this.direction);
        Furnace.generate(editor, Cardinal.left(this.direction), pos, false, new class_1799((class_1935)class_1802.field_8713, rand.method_39332(1, 4)));
    }

    @Override
    public CellManager getCells(Cardinal dir) {
        Coord origin = Coord.ZERO;
        CellManager cells = new CellManager();
        cells.add(Cell.of(origin.copy(), CellState.OBSTRUCTED));
        cells.add(Cell.of(origin.copy().add(dir), CellState.OBSTRUCTED));
        cells.add(Cell.of(origin.copy().add(dir, 2), CellState.OBSTRUCTED).addWall(dir));
        for (Cardinal o : Cardinal.orthogonal(dir)) {
            cells.add(Cell.of(origin.copy().add(dir).add(o), CellState.OBSTRUCTED).addWall(Cardinal.reverse(dir)).addWall(o));
            cells.add(Cell.of(origin.copy().add(dir, 2).add(o), CellState.OBSTRUCTED).addWall(dir).addWall(o));
        }
        for (Cardinal d : Cardinal.directions) {
            if (d == dir) continue;
            cells.add(Cell.of(origin.copy().add(d), CellState.POTENTIAL));
        }
        return cells;
    }

    @Override
    public void determineEntrances(Floor f, Coord floorPos) {
        for (Cardinal dir : Cardinal.directions) {
            Cell c;
            if (dir == this.direction || !(c = f.getCell(floorPos.copy().add(dir))).isRoom()) continue;
            if (!c.getWalls().contains((Object)Cardinal.reverse(dir))) {
                this.addEntrance(dir, Entrance.DOOR);
                continue;
            }
            this.addEntrance(dir, Entrance.WALL);
        }
    }

    @Override
    public BoundingBox getBoundingBox(Coord origin, Cardinal dir) {
        return BoundingBox.of(origin).grow(dir, 12).grow(Cardinal.orthogonal(dir), 6).grow(Cardinal.UP, 6).grow(Cardinal.DOWN, 3);
    }

    @Override
    public String getName() {
        return Room.BEDROOM.name();
    }
}

