/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.dungeon.room;

import com.greymerk.roguelike.dungeon.fragment.Fragment;
import com.greymerk.roguelike.dungeon.fragment.parts.CellSupport;
import com.greymerk.roguelike.dungeon.fragment.parts.Pillar;
import com.greymerk.roguelike.dungeon.layout.Entrance;
import com.greymerk.roguelike.dungeon.room.AbstractRoom;
import com.greymerk.roguelike.dungeon.room.IRoom;
import com.greymerk.roguelike.dungeon.room.Room;
import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.IBlockFactory;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.blocks.Air;
import com.greymerk.roguelike.editor.boundingbox.BoundingBox;
import java.util.List;
import net.minecraft.class_5819;

public class Corridor
extends AbstractRoom
implements IRoom {
    @Override
    public void generate(IWorldEditor editor) {
        class_5819 rand = editor.getRandom(this.worldPos);
        Coord origin = this.getWorldPos();
        this.clear(editor, rand, origin);
        this.cell(editor, rand, origin);
        this.decorations(editor, rand, origin);
        CellSupport.generate(editor, rand, this.theme, origin);
    }

    private void cell(IWorldEditor editor, class_5819 rand, Coord origin) {
        IBlockFactory blocks = this.theme.getPrimary().getWall();
        BoundingBox.of(origin).add(Cardinal.UP, 4).grow(Cardinal.directions).fill(editor, rand, blocks, false, true);
        Cardinal.directions.forEach(dir -> {
            BoundingBox.of(origin).add((Cardinal)((Object)dir), 2).add(Cardinal.UP, 3).grow(Cardinal.orthogonal(dir), 2).fill(editor, rand, blocks);
            BoundingBox.of(origin).add((Cardinal)((Object)dir), 2).add(Cardinal.DOWN).grow(Cardinal.orthogonal(dir), 2).fill(editor, rand, blocks);
            Pillar.generate(editor, rand, origin.copy().add((Cardinal)((Object)dir), 2).add(Cardinal.left(dir), 2), this.theme, 2, List.of(Cardinal.reverse(dir), Cardinal.right(dir)));
            blocks.set(editor, rand, origin.copy().add((Cardinal)((Object)dir), 2).add(Cardinal.left(dir), 2).add(Cardinal.UP, 4));
        });
        BoundingBox.of(origin).add(Cardinal.DOWN).grow(Cardinal.directions).fill(editor, rand, this.theme.getPrimary().getFloor());
    }

    private void clear(IWorldEditor editor, class_5819 rand, Coord origin) {
        BoundingBox.of(origin).grow(Cardinal.directions, 2).grow(Cardinal.UP, 3).fill(editor, rand, Air.get());
        Cardinal.directions.forEach(dir -> BoundingBox.of(origin).add((Cardinal)((Object)dir), 3).grow(Cardinal.orthogonal(dir), 2).grow(Cardinal.UP, 3).fill(editor, rand, this.theme.getPrimary().getWall(), false, true));
    }

    private void decorations(IWorldEditor editor, class_5819 rand, Coord origin) {
        for (Cardinal dir : Cardinal.directions) {
            if (this.getEntrance(dir) == Entrance.DOOR) {
                Fragment.generate(Fragment.ARCH, editor, rand, this.theme, this.worldPos.copy(), dir);
                continue;
            }
            if (this.getEntrance(dir) == Entrance.ALCOVE) {
                this.settings.getAlcove(rand).generate(editor, rand, this.theme, this.worldPos.copy(), dir);
                continue;
            }
            this.settings.getWallFragment(rand).generate(editor, rand, this.theme, this.worldPos.copy(), dir);
        }
    }

    @Override
    public String getName() {
        return Room.CORRIDOR.name();
    }
}

