/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.dungeon.room;

import com.greymerk.roguelike.dungeon.fragment.Fragment;
import com.greymerk.roguelike.dungeon.fragment.parts.CellSupport;
import com.greymerk.roguelike.dungeon.fragment.parts.Pillar;
import com.greymerk.roguelike.dungeon.layout.Entrance;
import com.greymerk.roguelike.dungeon.room.AbstractMediumRoom;
import com.greymerk.roguelike.dungeon.room.IRoom;
import com.greymerk.roguelike.dungeon.room.Room;
import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.IBlockFactory;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.blocks.Air;
import com.greymerk.roguelike.editor.blocks.stair.IStair;
import com.greymerk.roguelike.editor.boundingbox.BoundingBox;
import com.greymerk.roguelike.filter.Filter;
import java.util.List;
import net.minecraft.class_5819;

public class CrossRoom
extends AbstractMediumRoom
implements IRoom {
    @Override
    public void generate(IWorldEditor editor) {
        Coord origin = this.getWorldPos().copy().add(this.direction, 6).freeze();
        class_5819 rand = editor.getRandom(origin);
        this.clear(editor, rand, origin);
        this.corners(editor, rand, origin);
        this.sides(editor, rand, origin);
        this.center(editor, rand, origin);
        this.decorations(editor, rand, origin);
        this.supports(editor, rand, origin);
        this.pots(editor, rand, origin);
    }

    private void pots(IWorldEditor editor, class_5819 rand, Coord origin) {
        Filter.get(Filter.POTS).apply(editor, rand, this.theme, BoundingBox.of(origin).grow(Cardinal.directions, 8));
    }

    private void supports(IWorldEditor editor, class_5819 rand, Coord origin) {
        CellSupport.generate(editor, rand, this.theme, origin);
        Cardinal.directions.forEach(dir -> {
            CellSupport.generate(editor, rand, this.theme, origin.copy().add((Cardinal)((Object)dir), 6));
            CellSupport.generate(editor, rand, this.theme, origin.copy().add((Cardinal)((Object)dir), 6).add(Cardinal.left(dir), 6));
        });
    }

    private void decorations(IWorldEditor editor, class_5819 rand, Coord origin) {
        Cardinal.directions.forEach(dir -> {
            Cardinal.orthogonal(dir).forEach(o -> this.settings.getWallFragment(rand).generate(editor, rand, this.theme, origin.copy().add((Cardinal)((Object)dir), 6).add((Cardinal)((Object)((Object)o)), 6), (Cardinal)((Object)dir)));
            if (this.getEntrance((Cardinal)((Object)dir)) == Entrance.WALL) {
                this.settings.getWallFragment(rand).generate(editor, rand, this.theme, origin.copy().add((Cardinal)((Object)dir), 6), (Cardinal)((Object)dir));
            }
            if (this.getEntrance((Cardinal)((Object)dir)) == Entrance.ALCOVE) {
                this.settings.getAlcove(rand).generate(editor, rand, this.theme, origin.copy().add((Cardinal)((Object)dir), 6), (Cardinal)((Object)dir));
            }
        });
    }

    private void center(IWorldEditor editor, class_5819 rand, Coord origin) {
        IBlockFactory walls = this.theme.getPrimary().getWall();
        IStair stair = this.theme.getPrimary().getStair();
        walls.set(editor, rand, origin.copy().add(Cardinal.UP, 6));
        BoundingBox.of(origin).add(Cardinal.UP, 7).grow(Cardinal.directions, 2).fill(editor, rand, walls, false, true);
        Cardinal.directions.forEach(dir -> {
            walls.set(editor, rand, origin.copy().add(Cardinal.UP, 6).add((Cardinal)((Object)dir)));
            walls.set(editor, rand, origin.copy().add(Cardinal.UP, 5).add((Cardinal)((Object)dir), 3).add(Cardinal.left(dir), 3));
            stair.setOrientation(Cardinal.reverse(dir), true).fill(editor, rand, BoundingBox.of(origin).add((Cardinal)((Object)dir), 3).add(Cardinal.UP, 5).grow(Cardinal.orthogonal(dir)));
            BoundingBox.of(origin).add(Cardinal.UP, 6).add((Cardinal)((Object)dir), 2).grow(Cardinal.orthogonal(dir), 3).fill(editor, rand, walls);
            Cardinal.orthogonal(dir).forEach(o -> stair.setOrientation(Cardinal.reverse(o), true).set(editor, rand, origin.copy().add(Cardinal.UP, 5).add((Cardinal)((Object)dir), 3).add((Cardinal)((Object)((Object)o)), 2)));
        });
        Cardinal.directions.forEach(dir -> stair.setOrientation(Cardinal.reverse(dir), true).set(editor, rand, origin.copy().add((Cardinal)((Object)dir), 2).add(Cardinal.left(dir), 2).add(Cardinal.UP, 5)));
    }

    private void sides(IWorldEditor editor, class_5819 rand, Coord origin) {
        IBlockFactory walls = this.theme.getPrimary().getWall();
        IStair stair = this.theme.getPrimary().getStair();
        Cardinal.directions.forEach(dir -> {
            BoundingBox.of(origin).add((Cardinal)((Object)dir), 5).add(Cardinal.UP, 6).grow((Cardinal)((Object)dir)).grow(Cardinal.orthogonal(dir), 3).fill(editor, rand, walls, false, true);
            BoundingBox.of(origin).add((Cardinal)((Object)dir), 8).add(Cardinal.UP, 3).grow(Cardinal.orthogonal(dir), 3).grow(Cardinal.UP, 2).fill(editor, rand, walls);
            BoundingBox.of(origin).add((Cardinal)((Object)dir), 7).add(Cardinal.UP, 5).grow(Cardinal.orthogonal(dir), 3).fill(editor, rand, walls);
            BoundingBox.of(origin).add((Cardinal)((Object)dir), 4).add(Cardinal.UP, 5).grow(Cardinal.orthogonal(dir), 3).fill(editor, rand, walls);
            Cardinal.orthogonal(dir).forEach(o -> {
                BoundingBox.of(origin).add((Cardinal)((Object)dir), 5).add((Cardinal)((Object)((Object)o)), 2).add(Cardinal.UP, 5).grow((Cardinal)((Object)dir)).fill(editor, rand, walls);
                stair.setOrientation(Cardinal.reverse(o), true).set(editor, rand, origin.copy().add((Cardinal)((Object)dir), 4).add(Cardinal.UP, 4).add((Cardinal)((Object)((Object)o)), 3));
                Pillar.generate(editor, rand, origin.copy().add((Cardinal)((Object)dir), 8).add((Cardinal)((Object)((Object)o)), 2), this.theme, 2, List.of(Cardinal.reverse(dir), Cardinal.reverse(o)));
                stair.setOrientation(Cardinal.reverse(dir), true).set(editor, rand, origin.copy().add((Cardinal)((Object)dir), 7).add((Cardinal)((Object)((Object)o)), 3).add(Cardinal.UP, 4));
                stair.setOrientation(Cardinal.reverse(dir), true).set(editor, rand, origin.copy().add((Cardinal)((Object)dir), 8).add((Cardinal)((Object)((Object)o)), 3).add(Cardinal.UP, 2));
                stair.setOrientation(Cardinal.reverse(dir), true).set(editor, rand, origin.copy().add((Cardinal)((Object)dir), 6).add((Cardinal)((Object)((Object)o)), 2).add(Cardinal.UP, 4));
                stair.setOrientation(Cardinal.reverse(o), true).set(editor, rand, origin.copy().add((Cardinal)((Object)dir), 7).add((Cardinal)((Object)((Object)o))).add(Cardinal.UP, 4));
                BoundingBox.of(origin).add((Cardinal)((Object)dir), 7).add((Cardinal)((Object)((Object)o)), 2).add(Cardinal.UP, 3).grow(Cardinal.UP).fill(editor, rand, walls);
            });
        });
    }

    private void corners(IWorldEditor editor, class_5819 rand, Coord origin) {
        Cardinal.directions.forEach(dir -> this.corner(editor, rand, origin.copy().add((Cardinal)((Object)dir), 6).add(Cardinal.left(dir), 6)));
    }

    private void corner(IWorldEditor editor, class_5819 rand, Coord origin) {
        Cardinal.directions.forEach(dir -> {
            BoundingBox.of(origin).add((Cardinal)((Object)dir), 2).add(Cardinal.UP, 3).grow(Cardinal.orthogonal(dir)).grow(Cardinal.left(dir)).grow(Cardinal.UP, 2).fill(editor, rand, this.theme.getPrimary().getWall());
            Pillar.generate(editor, rand, origin.copy().add((Cardinal)((Object)dir), 2).add(Cardinal.left(dir), 2), this.theme, 2, List.of(Cardinal.reverse(dir), Cardinal.right(dir)));
        });
        BoundingBox.of(origin).add(Cardinal.UP, 5).grow(Cardinal.directions).fill(editor, rand, this.theme.getPrimary().getWall(), false, true);
    }

    private void clear(IWorldEditor editor, class_5819 rand, Coord origin) {
        BoundingBox.of(origin).grow(Cardinal.directions, 8).grow(Cardinal.UP, 4).fill(editor, rand, Air.get());
        BoundingBox.of(origin).add(Cardinal.UP, 5).grow(Cardinal.directions, 4).fill(editor, rand, Air.get());
        BoundingBox.of(origin).add(Cardinal.UP, 6).grow(Cardinal.directions, 2).fill(editor, rand, Air.get());
        Cardinal.directions.forEach(dir -> {
            BoundingBox.of(origin).add((Cardinal)((Object)dir), 4).add(Cardinal.UP, 5).grow((Cardinal)((Object)dir), 4).grow(Cardinal.orthogonal(dir), 3).fill(editor, rand, Air.get());
            BoundingBox.of(origin).add(Cardinal.DOWN).add((Cardinal)((Object)dir), 9).grow(Cardinal.orthogonal(dir), 9).fill(editor, rand, this.theme.getPrimary().getWall());
            BoundingBox.of(origin).grow(Cardinal.UP, 5).add((Cardinal)((Object)dir), 9).grow(Cardinal.orthogonal(dir), 9).fill(editor, rand, this.theme.getPrimary().getWall(), false, true);
        });
        BoundingBox.of(origin).add(Cardinal.DOWN).grow(Cardinal.directions, 8).fill(editor, rand, this.theme.getPrimary().getFloor());
        this.getEntrancesFromType(Entrance.DOOR).forEach(dir -> Fragment.generate(Fragment.ARCH, editor, rand, this.theme, origin.copy().add((Cardinal)((Object)dir), 6), dir));
    }

    @Override
    public String getName() {
        return Room.CROSS.name();
    }
}

