/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.dungeon.room;

import com.greymerk.roguelike.dungeon.fragment.Fragment;
import com.greymerk.roguelike.dungeon.fragment.parts.CellSupport;
import com.greymerk.roguelike.dungeon.fragment.parts.Pillar;
import com.greymerk.roguelike.dungeon.layout.Entrance;
import com.greymerk.roguelike.dungeon.room.AbstractLargeRoom;
import com.greymerk.roguelike.dungeon.room.IRoom;
import com.greymerk.roguelike.dungeon.room.Room;
import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.IBlockFactory;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.MetaBlock;
import com.greymerk.roguelike.editor.blocks.Air;
import com.greymerk.roguelike.editor.blocks.BookShelf;
import com.greymerk.roguelike.editor.blocks.ColorBlock;
import com.greymerk.roguelike.editor.blocks.Lantern;
import com.greymerk.roguelike.editor.blocks.Terracotta;
import com.greymerk.roguelike.editor.blocks.stair.IStair;
import com.greymerk.roguelike.editor.boundingbox.BoundingBox;
import com.greymerk.roguelike.editor.factories.BlockCheckers;
import com.greymerk.roguelike.editor.factories.BlockFloor;
import com.greymerk.roguelike.util.Color;
import com.greymerk.roguelike.util.math.RandHelper;
import java.util.List;
import net.minecraft.class_2246;
import net.minecraft.class_5819;

public class LibraryRoom
extends AbstractLargeRoom
implements IRoom {
    @Override
    public void generate(IWorldEditor editor) {
        Coord origin = this.getWorldPos().add(this.direction, 12).freeze();
        class_5819 rand = editor.getRandom(origin);
        this.clear(editor, rand, origin);
        this.entries(editor, rand, origin);
        this.floor(editor, rand, origin);
        this.ceiling(editor, rand, origin);
        this.walls(editor, rand, origin);
        this.decorations(editor, rand, origin);
        this.supports(editor, rand, origin);
    }

    private void decorations(IWorldEditor editor, class_5819 rand, Coord origin) {
        Cardinal.directions.forEach(dir -> Cardinal.orthogonal(dir).forEach(o -> {
            BookShelf.set(editor, rand, origin.add((Cardinal)((Object)dir), 5).add((Cardinal)((Object)((Object)o)), 8).add(Cardinal.UP), Cardinal.reverse(o));
            this.settings.getWallFragment(rand).generate(editor, rand, this.theme, origin.add((Cardinal)((Object)dir), 12).add((Cardinal)((Object)((Object)o)), 6), (Cardinal)((Object)dir));
            this.settings.getWallFragment(rand).generate(editor, rand, this.theme, origin.add((Cardinal)((Object)dir), 12).add((Cardinal)((Object)((Object)o)), 6), Cardinal.reverse(dir));
            this.settings.getWallFragment(rand).generate(editor, rand, this.theme, origin.add((Cardinal)((Object)dir), 12).add((Cardinal)((Object)((Object)o)), 12), (Cardinal)((Object)dir));
        }));
    }

    private void walls(IWorldEditor editor, class_5819 rand, Coord origin) {
        IBlockFactory wall = this.theme.getPrimary().getWall();
        IStair stair = this.theme.getPrimary().getStair();
        Cardinal.directions.forEach(dir -> {
            Pillar.generate(editor, rand, origin.add((Cardinal)((Object)dir), 7).add(Cardinal.left(dir), 7), this.theme, 5);
            Cardinal.orthogonal(dir).forEach(o -> {
                BoundingBox.of(origin).add((Cardinal)((Object)dir), 8).add((Cardinal)((Object)((Object)o)), 3).grow(Cardinal.UP, 6).grow((Cardinal)((Object)dir)).grow((Cardinal)((Object)((Object)o)), 6).fill(editor, rand, wall);
                Pillar.generate(editor, rand, origin.add((Cardinal)((Object)dir), 7).add((Cardinal)((Object)((Object)o)), 3), this.theme, 5);
                BoundingBox.of(origin).add(Cardinal.UP, 6).add((Cardinal)((Object)dir), 4).add((Cardinal)((Object)((Object)o)), 4).grow((Cardinal)((Object)dir), 6).fill(editor, rand, wall);
                Pillar.generate(editor, rand, origin.add((Cardinal)((Object)dir), 10).add((Cardinal)((Object)((Object)o)), 4), this.theme, 4, List.of(dir, o));
                Pillar.generate(editor, rand, origin.add((Cardinal)((Object)dir), 10).add((Cardinal)((Object)((Object)o)), 8), this.theme, 4, List.of(dir, Cardinal.reverse(o)));
                BoundingBox.of(origin).add((Cardinal)((Object)dir), 10).add((Cardinal)((Object)((Object)o)), 2).add(Cardinal.UP, 5).grow((Cardinal)((Object)((Object)o)), 12).fill(editor, rand, wall);
                List.of(Integer.valueOf(2), Integer.valueOf(4), Integer.valueOf(8)).forEach(step -> BoundingBox.of(origin).add(Cardinal.UP, 5).add((Cardinal)((Object)dir), 11).add((Cardinal)((Object)((Object)o)), (int)step).grow((Cardinal)((Object)dir), 2).fill(editor, rand, wall));
                Pillar.generate(editor, rand, origin.add((Cardinal)((Object)dir), 14).add((Cardinal)((Object)((Object)o)), 2), this.theme, 4, List.of(Cardinal.reverse(dir), Cardinal.reverse(o)));
                Pillar.generate(editor, rand, origin.add((Cardinal)((Object)dir), 14).add((Cardinal)((Object)((Object)o)), 4), this.theme, 4, List.of(Cardinal.reverse(dir), o));
                Pillar.generate(editor, rand, origin.add((Cardinal)((Object)dir), 14).add((Cardinal)((Object)((Object)o)), 8), this.theme, 4, List.of(Cardinal.reverse(dir), Cardinal.reverse(o)));
                Pillar.generate(editor, rand, origin.add((Cardinal)((Object)dir), 14).add((Cardinal)((Object)((Object)o)), 10), this.theme, 4, List.of(Cardinal.reverse(dir), o));
                BoundingBox.of(origin).add((Cardinal)((Object)dir), 6).add((Cardinal)((Object)((Object)o)), 3).add(Cardinal.UP, 6).grow((Cardinal)((Object)((Object)o)), 4).grow((Cardinal)((Object)dir)).fill(editor, rand, wall);
                wall.set(editor, rand, origin.add((Cardinal)((Object)dir), 9).add((Cardinal)((Object)((Object)o)), 2).add(Cardinal.UP, 4));
                wall.set(editor, rand, origin.add((Cardinal)((Object)dir), 8).add((Cardinal)((Object)((Object)o)), 2).add(Cardinal.UP, 5));
                wall.set(editor, rand, origin.add((Cardinal)((Object)dir), 10).add((Cardinal)((Object)((Object)o)), 2).add(Cardinal.UP, 5));
                stair.setOrientation(Cardinal.reverse(o), true).set(editor, rand, origin.add((Cardinal)((Object)dir), 8).add((Cardinal)((Object)((Object)o)), 2).add(Cardinal.UP, 4));
                stair.setOrientation(Cardinal.reverse(o), true).set(editor, rand, origin.add((Cardinal)((Object)dir), 8).add((Cardinal)((Object)((Object)o))).add(Cardinal.UP, 5));
                stair.setOrientation(Cardinal.reverse(o), true).set(editor, rand, origin.add((Cardinal)((Object)dir), 9).add((Cardinal)((Object)((Object)o)), 2).add(Cardinal.UP, 3));
                stair.setOrientation(Cardinal.reverse(o), true).set(editor, rand, origin.add((Cardinal)((Object)dir), 9).add((Cardinal)((Object)((Object)o))).add(Cardinal.UP, 4));
                stair.setOrientation((Cardinal)((Object)dir), true).set(editor, rand, origin.add((Cardinal)((Object)dir), 10).add((Cardinal)((Object)((Object)o)), 2).add(Cardinal.UP, 4));
                stair.setOrientation(Cardinal.reverse(o), true).set(editor, rand, origin.add((Cardinal)((Object)dir), 10).add((Cardinal)((Object)((Object)o))).add(Cardinal.UP, 5));
                stair.setOrientation(Cardinal.reverse(dir), true).set(editor, rand, origin.add(Cardinal.UP, 4).add((Cardinal)((Object)dir), 14).add((Cardinal)((Object)((Object)o)), 3));
                stair.setOrientation(Cardinal.reverse(dir), true).set(editor, rand, origin.add(Cardinal.UP, 4).add((Cardinal)((Object)dir), 14).add((Cardinal)((Object)((Object)o)), 9));
                stair.setOrientation((Cardinal)((Object)dir), true).set(editor, rand, origin.add(Cardinal.UP, 4).add((Cardinal)((Object)dir), 10).add((Cardinal)((Object)((Object)o)), 9));
            });
            MetaBlock.of(class_2246.field_23985).set(editor, origin.add((Cardinal)((Object)dir), 4).add(Cardinal.left(dir), 4).add(Cardinal.UP, 5));
            Lantern.set(editor, origin.add((Cardinal)((Object)dir), 4).add(Cardinal.left(dir), 4).add(Cardinal.UP, 4));
            BoundingBox.of(origin).add(Cardinal.UP, 5).add((Cardinal)((Object)dir), 14).grow(Cardinal.orthogonal(dir), 14).fill(editor, rand, wall);
            Pillar.generate(editor, rand, origin.add((Cardinal)((Object)dir), 10).add(Cardinal.left(dir), 10), this.theme, 4, List.of(dir, Cardinal.left(dir)));
            Pillar.generate(editor, rand, origin.add((Cardinal)((Object)dir), 14).add(Cardinal.left(dir), 14), this.theme, 4, List.of(Cardinal.reverse(dir), Cardinal.right(dir)));
            BoundingBox.of(origin).add((Cardinal)((Object)dir), 9).add(Cardinal.UP, 5).grow(Cardinal.orthogonal(dir), 2).fill(editor, rand, wall);
        });
    }

    private void supports(IWorldEditor editor, class_5819 rand, Coord origin) {
        CellSupport.generate(editor, rand, this.theme, origin);
        Cardinal.directions.forEach(dir -> List.of(Integer.valueOf(6), Integer.valueOf(12)).forEach(i -> {
            CellSupport.generate(editor, rand, this.theme, origin.copy().add((Cardinal)((Object)dir), (int)i));
            List.of(Integer.valueOf(6), Integer.valueOf(12)).forEach(j -> CellSupport.generate(editor, rand, this.theme, origin.copy().add((Cardinal)((Object)dir), (int)i).add(Cardinal.left(dir), (int)j)));
        }));
    }

    private void ceiling(IWorldEditor editor, class_5819 rand, Coord origin) {
        Cardinal.directions.forEach(dir -> List.of(Integer.valueOf(2), Integer.valueOf(4), Integer.valueOf(8), Integer.valueOf(10), Integer.valueOf(14)).forEach(step -> BoundingBox.of(origin).add(Cardinal.UP, 6).add((Cardinal)((Object)dir), (int)step).grow(Cardinal.orthogonal(dir), 14).fill(editor, rand, this.theme.getPrimary().getWall())));
        BoundingBox.of(origin).add(Cardinal.UP, 7).grow(Cardinal.directions, 14).fill(editor, rand, this.theme.getPrimary().getWall(), false, true);
    }

    private void entries(IWorldEditor editor, class_5819 rand, Coord origin) {
        this.getEntrancesFromType(Entrance.DOOR).forEach(dir -> Fragment.generate(Fragment.ARCH, editor, rand, this.theme, origin.add((Cardinal)((Object)dir), 12), dir));
    }

    private void floor(IWorldEditor editor, class_5819 rand, Coord origin) {
        List<Color> colors = RandHelper.pickCountFrom(List.of(Color.values()), rand, 4);
        BlockCheckers tiles = new BlockCheckers(ColorBlock.get(ColorBlock.CLAY, colors.get(0)), ColorBlock.get(ColorBlock.CLAY, colors.get(1)));
        BlockFloor tileFloor = new BlockFloor(tiles);
        BlockFloor trim = new BlockFloor(ColorBlock.get(ColorBlock.CLAY, colors.get(2)));
        Cardinal.directions.forEach(dir -> {
            BoundingBox.of(origin).add(Cardinal.DOWN).add((Cardinal)((Object)dir), 14).grow((Cardinal)((Object)dir)).grow(Cardinal.orthogonal(dir), 15).fill(editor, rand, this.theme.getPrimary().getFloor());
            BoundingBox.of(origin).add(Cardinal.DOWN).add((Cardinal)((Object)dir), 11).grow((Cardinal)((Object)dir), 2).grow(Cardinal.right(dir), 10).grow(Cardinal.left(dir), 13).fill(editor, rand, tileFloor);
            BoundingBox.of(origin).add(Cardinal.DOWN).add((Cardinal)((Object)dir), 2).grow((Cardinal)((Object)dir), 8).grow(Cardinal.orthogonal(dir)).fill(editor, rand, tileFloor);
            BoundingBox.of(origin).add(Cardinal.DOWN).grow(Cardinal.directions).fill(editor, rand, tileFloor);
            BoundingBox.of(origin).add(Cardinal.DOWN).add((Cardinal)((Object)dir), 8).add(Cardinal.left(dir), 2).grow((Cardinal)((Object)dir), 2).grow(Cardinal.left(dir), 8).fill(editor, rand, this.theme.getPrimary().getFloor());
            BoundingBox.of(origin).add(Cardinal.DOWN).add((Cardinal)((Object)dir), 8).add(Cardinal.right(dir), 2).grow((Cardinal)((Object)dir), 2).grow(Cardinal.right(dir), 5).fill(editor, rand, this.theme.getPrimary().getFloor());
            BoundingBox.of(origin).add(Cardinal.DOWN).add((Cardinal)((Object)dir), 2).add(Cardinal.left(dir), 2).grow(Cardinal.left(dir), 5).fill(editor, rand, trim);
            BoundingBox.of(origin).add(Cardinal.DOWN).add((Cardinal)((Object)dir), 7).add(Cardinal.left(dir), 2).grow(Cardinal.left(dir), 5).fill(editor, rand, trim);
            BoundingBox.of(origin).add(Cardinal.DOWN).add((Cardinal)((Object)dir), 3).add(Cardinal.left(dir), 2).grow((Cardinal)((Object)dir), 3).fill(editor, rand, trim);
            BoundingBox.of(origin).add(Cardinal.DOWN).add((Cardinal)((Object)dir), 3).add(Cardinal.left(dir), 7).grow((Cardinal)((Object)dir), 3).fill(editor, rand, trim);
            Terracotta.fillSquare(editor, rand, origin.copy().add(Cardinal.DOWN).add((Cardinal)((Object)dir), 3).add(Cardinal.left(dir), 3), dir, 4, (Color)((Object)((Object)colors.get(3))));
        });
    }

    private void clear(IWorldEditor editor, class_5819 rand, Coord origin) {
        BoundingBox.of(origin).grow(Cardinal.directions, 14).grow(Cardinal.UP, 6).fill(editor, rand, Air.get());
        Cardinal.directions.forEach(dir -> BoundingBox.of(origin).add((Cardinal)((Object)dir), 15).grow(Cardinal.orthogonal(dir), 15).grow(Cardinal.UP, 5).fill(editor, rand, this.theme.getPrimary().getWall(), false, true));
    }

    @Override
    public String getName() {
        return Room.LIBRARY.name();
    }
}

