/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.dungeon.room;

import com.greymerk.roguelike.dungeon.cell.Cell;
import com.greymerk.roguelike.dungeon.cell.CellManager;
import com.greymerk.roguelike.dungeon.cell.CellState;
import com.greymerk.roguelike.dungeon.fragment.Fragment;
import com.greymerk.roguelike.dungeon.fragment.parts.CellSupport;
import com.greymerk.roguelike.dungeon.layout.Entrance;
import com.greymerk.roguelike.dungeon.room.AbstractLargeRoom;
import com.greymerk.roguelike.dungeon.room.IRoom;
import com.greymerk.roguelike.dungeon.room.Room;
import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.IBlockFactory;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.blocks.Air;
import com.greymerk.roguelike.editor.blocks.IronBar;
import com.greymerk.roguelike.editor.blocks.Lantern;
import com.greymerk.roguelike.editor.blocks.stair.IStair;
import com.greymerk.roguelike.editor.boundingbox.BoundingBox;
import com.greymerk.roguelike.editor.shapes.Shape;
import java.util.List;
import net.minecraft.class_5819;

public class PanopticonRoom
extends AbstractLargeRoom
implements IRoom {
    @Override
    public void generate(IWorldEditor editor) {
        class_5819 rand = editor.getRandom(this.getWorldPos());
        Coord origin = this.worldPos.copy().add(this.direction, 12).freeze();
        this.clear(editor, rand, origin.copy().freeze());
        this.doors(editor, rand, origin.copy().freeze());
        this.tower(editor, rand, origin.copy().freeze());
        this.ceiling(editor, rand, origin.copy().freeze());
        this.pillars(editor, rand, origin.copy().freeze());
        this.lowerPlatforms(editor, rand, origin.copy().add(Cardinal.DOWN, 7).freeze());
        this.middlePlatforms(editor, rand, origin.copy().add(Cardinal.DOWN, 3).freeze());
        this.upperPlatforms(editor, rand, origin.copy().add(Cardinal.UP).freeze());
        this.bridges(editor, rand, origin.copy().freeze());
        this.bars(editor, rand, origin.copy().freeze());
        this.decorations(editor, rand, origin.copy().freeze());
        this.supports(editor, rand, origin.copy().add(Cardinal.DOWN, 10).freeze());
    }

    private void supports(IWorldEditor editor, class_5819 rand, Coord origin) {
        CellSupport.generate(editor, rand, this.theme, origin);
        Cardinal.directions.forEach(dir -> List.of(Integer.valueOf(6), Integer.valueOf(12)).forEach(i -> {
            CellSupport.generate(editor, rand, this.theme, origin.copy().add((Cardinal)((Object)dir), (int)i));
            List.of(Integer.valueOf(6), Integer.valueOf(12)).forEach(j -> CellSupport.generate(editor, rand, this.theme, origin.copy().add((Cardinal)((Object)dir), (int)i).add(Cardinal.left(dir), (int)j)));
        }));
    }

    private void decorations(IWorldEditor editor, class_5819 rand, Coord origin) {
        Cardinal.directions.forEach(dir -> {
            if (this.getEntrance((Cardinal)((Object)dir)) != Entrance.DOOR) {
                this.deco(editor, rand, origin.copy().add(Cardinal.UP, 2).add((Cardinal)((Object)dir), 12), (Cardinal)((Object)dir));
                this.deco(editor, rand, origin.copy().add(Cardinal.DOWN, 2).add((Cardinal)((Object)dir), 12), (Cardinal)((Object)dir));
            }
            this.deco(editor, rand, origin.copy().add(Cardinal.DOWN, 6).add((Cardinal)((Object)dir), 12), (Cardinal)((Object)dir));
            this.deco(editor, rand, origin.copy().add(Cardinal.DOWN, 10).add((Cardinal)((Object)dir), 12), (Cardinal)((Object)dir));
            Cardinal.orthogonal(dir).forEach(o -> List.of(Integer.valueOf(6), Integer.valueOf(12)).forEach(i -> {
                this.deco(editor, rand, origin.copy().add(Cardinal.UP, 2).add((Cardinal)((Object)dir), 12).add((Cardinal)((Object)((Object)o)), (int)i), (Cardinal)((Object)dir));
                this.deco(editor, rand, origin.copy().add(Cardinal.DOWN, 2).add((Cardinal)((Object)dir), 12).add((Cardinal)((Object)((Object)o)), (int)i), (Cardinal)((Object)dir));
                List.of(Integer.valueOf(6), Integer.valueOf(10)).forEach(j -> this.deco(editor, rand, origin.copy().add(Cardinal.DOWN, (int)j).add((Cardinal)((Object)dir), 12).add((Cardinal)((Object)((Object)o)), (int)i), (Cardinal)((Object)dir)));
            }));
        });
    }

    private void deco(IWorldEditor editor, class_5819 rand, Coord origin, Cardinal dir) {
        Cardinal.orthogonal(dir).forEach(o -> this.theme.getPrimary().getStair().setOrientation(Cardinal.reverse(o), true).set(editor, rand, origin.copy().add(dir, 2).add((Cardinal)((Object)o)).add(Cardinal.UP, 2)));
        this.settings.getWallFragment(rand).generate(editor, rand, this.theme, origin, dir);
    }

    private void bars(IWorldEditor editor, class_5819 rand, Coord origin) {
        Cardinal.directions.forEach(dir -> {
            this.barWall(editor, rand, origin.copy().add(Cardinal.DOWN, 10).add((Cardinal)((Object)dir), 10), (Cardinal)((Object)dir));
            this.barWall(editor, rand, origin.copy().add(Cardinal.DOWN, 6).add((Cardinal)((Object)dir), 10), (Cardinal)((Object)dir));
            if (this.getEntrance((Cardinal)((Object)dir)) != Entrance.DOOR) {
                this.barWall(editor, rand, origin.copy().add(Cardinal.DOWN, 2).add((Cardinal)((Object)dir), 10), (Cardinal)((Object)dir));
            }
            Cardinal.orthogonal(dir).forEach(o -> {
                this.barWall(editor, rand, origin.copy().add(Cardinal.DOWN, 10).add((Cardinal)((Object)dir), 10).add((Cardinal)((Object)((Object)o)), 6), (Cardinal)((Object)dir));
                this.barWall(editor, rand, origin.copy().add(Cardinal.DOWN, 6).add((Cardinal)((Object)dir), 10).add((Cardinal)((Object)((Object)o)), 6), (Cardinal)((Object)dir));
                this.barWall(editor, rand, origin.copy().add(Cardinal.DOWN, 2).add((Cardinal)((Object)dir), 10).add((Cardinal)((Object)((Object)o)), 6), (Cardinal)((Object)dir));
                List.of(Integer.valueOf(2), Integer.valueOf(4), Integer.valueOf(8), Integer.valueOf(10)).forEach(i -> {
                    this.barWall(editor, rand, origin.copy().add(Cardinal.DOWN, 10).add((Cardinal)((Object)dir), 12).add((Cardinal)((Object)((Object)o)), (int)i), (Cardinal)((Object)((Object)o)));
                    this.barWall(editor, rand, origin.copy().add(Cardinal.DOWN, 6).add((Cardinal)((Object)dir), 12).add((Cardinal)((Object)((Object)o)), (int)i), (Cardinal)((Object)((Object)o)));
                });
                if (this.getEntrance((Cardinal)((Object)dir)) == Entrance.DOOR) {
                    List.of(Integer.valueOf(8), Integer.valueOf(10)).forEach(i -> this.barWall(editor, rand, origin.copy().add(Cardinal.DOWN, 2).add((Cardinal)((Object)dir), 12).add((Cardinal)((Object)((Object)o)), (int)i), (Cardinal)((Object)((Object)o))));
                } else {
                    List.of(Integer.valueOf(2), Integer.valueOf(4), Integer.valueOf(8), Integer.valueOf(10)).forEach(i -> this.barWall(editor, rand, origin.copy().add(Cardinal.DOWN, 2).add((Cardinal)((Object)dir), 12).add((Cardinal)((Object)((Object)o)), (int)i), (Cardinal)((Object)((Object)o))));
                }
            });
        });
    }

    private void barWall(IWorldEditor editor, class_5819 rand, Coord origin, Cardinal dir) {
        BoundingBox.of(origin).grow(Cardinal.orthogonal(dir)).grow(Cardinal.UP, 2).fill(editor, rand, IronBar.getBroken(), true, false);
    }

    private void bridges(IWorldEditor editor, class_5819 rand, Coord origin) {
        IStair stair = this.theme.getPrimary().getStair();
        this.getEntrancesFromType(Entrance.DOOR).forEach(dir -> {
            BoundingBox.of(origin).add(Cardinal.DOWN).add((Cardinal)((Object)dir), 3).grow(Cardinal.orthogonal(dir)).grow((Cardinal)((Object)dir), 13).fill(editor, rand, this.theme.getPrimary().getFloor());
            BoundingBox.of(origin).add(Cardinal.DOWN, 2).add((Cardinal)((Object)dir), 8).grow(Cardinal.orthogonal(dir)).grow((Cardinal)((Object)dir), 6).fill(editor, rand, this.theme.getPrimary().getWall());
            Cardinal.orthogonal(dir).forEach(o -> {
                stair.setOrientation(Cardinal.reverse(dir), true).set(editor, rand, origin.copy().add(Cardinal.DOWN, 2).add((Cardinal)((Object)dir), 7).add((Cardinal)((Object)((Object)o))));
                stair.setOrientation(Cardinal.reverse(dir), true).set(editor, rand, origin.copy().add(Cardinal.DOWN, 3).add((Cardinal)((Object)dir), 8).add((Cardinal)((Object)((Object)o))));
                BoundingBox.of(origin).add((Cardinal)((Object)dir), 12).add((Cardinal)((Object)((Object)o)), 3).grow(Cardinal.orthogonal(o)).grow(Cardinal.DOWN, 2).grow(Cardinal.UP, 5).fill(editor, rand, this.theme.getPrimary().getWall());
                BoundingBox.of(origin).add(Cardinal.DOWN).add((Cardinal)((Object)dir), 12).add((Cardinal)((Object)((Object)o)), 2).grow(Cardinal.orthogonal(o)).grow(Cardinal.DOWN).fill(editor, rand, this.theme.getPrimary().getWall());
                BoundingBox.of(origin).add((Cardinal)((Object)dir), 2).add((Cardinal)((Object)((Object)o))).grow((Cardinal)((Object)dir), 8).forEach(pos -> {
                    if (editor.isSupported((Coord)pos)) {
                        IronBar.get().set(editor, rand, (Coord)pos);
                    }
                });
            });
        });
        Cardinal.directions.forEach(dir -> {
            if (this.getEntrance((Cardinal)((Object)dir)) != Entrance.DOOR) {
                BoundingBox.of(origin).add(Cardinal.UP).add((Cardinal)((Object)dir), 10).grow(Cardinal.orthogonal(dir), 3).fill(editor, rand, this.theme.getPrimary().getWall());
                Cardinal.orthogonal(dir).forEach(o -> BoundingBox.of(origin).add(Cardinal.UP).add((Cardinal)((Object)dir), 11).add((Cardinal)((Object)((Object)o)), 2).grow((Cardinal)((Object)dir), 2).fill(editor, rand, this.theme.getPrimary().getWall()));
                BoundingBox.of(origin).add(Cardinal.UP).add((Cardinal)((Object)dir), 11).grow(Cardinal.orthogonal(dir), 3).grow((Cardinal)((Object)dir), 3).fill(editor, rand, this.theme.getPrimary().getFloor());
            }
        });
    }

    private void upperPlatforms(IWorldEditor editor, class_5819 rand, Coord origin) {
        Cardinal.directions.forEach(dir -> Cardinal.orthogonal(dir).forEach(o -> {
            BoundingBox.of(origin).add((Cardinal)((Object)dir), 10).add((Cardinal)((Object)((Object)o)), 5).grow((Cardinal)((Object)((Object)o)), 2).fill(editor, rand, this.theme.getPrimary().getWall());
            BoundingBox.of(origin).add((Cardinal)((Object)dir), 11).add((Cardinal)((Object)((Object)o)), 4).grow((Cardinal)((Object)dir), 2).fill(editor, rand, this.theme.getPrimary().getWall());
            BoundingBox.of(origin).add((Cardinal)((Object)dir), 14).add((Cardinal)((Object)((Object)o)), 5).grow((Cardinal)((Object)((Object)o)), 8).fill(editor, rand, this.theme.getPrimary().getWall());
            BoundingBox.of(origin).add((Cardinal)((Object)dir), 12).add((Cardinal)((Object)((Object)o)), 5).grow((Cardinal)((Object)((Object)o)), 8).grow(Cardinal.orthogonal(o)).fill(editor, rand, this.theme.getPrimary().getFloor(), true, false);
        }));
    }

    private void middlePlatforms(IWorldEditor editor, class_5819 rand, Coord origin) {
        Cardinal.directions.forEach(dir -> {
            BoundingBox.of(origin).add((Cardinal)((Object)dir), 9).grow(Cardinal.orthogonal(dir), 14).grow((Cardinal)((Object)dir)).fill(editor, rand, this.theme.getPrimary().getWall());
            BoundingBox.of(origin).add((Cardinal)((Object)dir), 14).grow(Cardinal.orthogonal(dir), 14).fill(editor, rand, this.theme.getPrimary().getWall());
            Cardinal.orthogonal(dir).forEach(o -> {
                BoundingBox.of(origin).add((Cardinal)((Object)dir), 11).add((Cardinal)((Object)((Object)o)), 3).grow(Cardinal.orthogonal(dir)).grow((Cardinal)((Object)dir), 2).fill(editor, rand, this.theme.getPrimary().getWall());
                BoundingBox.of(origin).add((Cardinal)((Object)dir), 11).add((Cardinal)((Object)((Object)o)), 9).grow(Cardinal.orthogonal(dir)).grow((Cardinal)((Object)dir), 2).fill(editor, rand, this.theme.getPrimary().getWall());
                this.theme.getPrimary().getWall().set(editor, rand, origin.copy().add((Cardinal)((Object)dir), 8).add((Cardinal)((Object)((Object)o)), 3));
            });
            BoundingBox.of(origin).add((Cardinal)((Object)dir), 11).grow((Cardinal)((Object)dir), 3).grow(Cardinal.left(dir), 13).grow(Cardinal.right(dir), 7).fill(editor, rand, this.theme.getPrimary().getFloor(), true, false);
        });
    }

    private void lowerPlatforms(IWorldEditor editor, class_5819 rand, Coord origin) {
        Cardinal.directions.forEach(dir -> {
            BoundingBox.of(origin).add((Cardinal)((Object)dir), 8).grow((Cardinal)((Object)dir), 3).grow(Cardinal.orthogonal(dir), 14).fill(editor, rand, this.theme.getPrimary().getWall());
            BoundingBox.of(origin).add((Cardinal)((Object)dir), 14).grow(Cardinal.orthogonal(dir), 14).fill(editor, rand, this.theme.getPrimary().getWall());
            Cardinal.orthogonal(dir).forEach(o -> {
                BoundingBox.of(origin).add((Cardinal)((Object)dir), 11).add((Cardinal)((Object)((Object)o)), 3).grow(Cardinal.orthogonal(dir)).grow((Cardinal)((Object)dir), 2).fill(editor, rand, this.theme.getPrimary().getWall());
                BoundingBox.of(origin).add((Cardinal)((Object)dir), 11).add((Cardinal)((Object)((Object)o)), 9).grow(Cardinal.orthogonal(dir)).grow((Cardinal)((Object)dir), 2).fill(editor, rand, this.theme.getPrimary().getWall());
            });
            BoundingBox.of(origin).add((Cardinal)((Object)dir), 11).grow((Cardinal)((Object)dir), 3).grow(Cardinal.left(dir), 13).grow(Cardinal.right(dir), 7).fill(editor, rand, this.theme.getPrimary().getFloor(), true, false);
        });
    }

    private void pillars(IWorldEditor editor, class_5819 rand, Coord origin) {
        Cardinal.directions.forEach(dir -> {
            this.cornerPillarSet(editor, rand, origin.copy().add(Cardinal.DOWN, 10).add((Cardinal)((Object)dir), 7).add(Cardinal.left(dir), 7).freeze(), List.of(dir, Cardinal.left(dir)));
            Cardinal.orthogonal(dir).forEach(o -> this.mainPillarSet(editor, rand, origin.copy().add((Cardinal)((Object)dir), 8).add(Cardinal.DOWN, 10).add((Cardinal)((Object)((Object)o)), 3), (Cardinal)((Object)dir)));
        });
    }

    private void cornerPillarSet(IWorldEditor editor, class_5819 rand, Coord origin, List<Cardinal> corner) {
        this.pillar(editor, rand, origin.add(corner.getFirst()).add(corner.getLast()), List.of(Cardinal.reverse(corner.getFirst()), Cardinal.reverse(corner.getLast())), 2);
        this.pillar(editor, rand, origin.add(corner.getFirst(), 2).add(corner.getLast(), 2), List.of(Cardinal.reverse(corner.getFirst()), Cardinal.reverse(corner.getLast())), 6);
        this.pillar(editor, rand, origin.add(corner.getFirst(), 2).add(corner.getLast(), 2).add(Cardinal.UP, 8), List.of(Cardinal.reverse(corner.getFirst()), Cardinal.reverse(corner.getLast())), 6);
        this.pillar(editor, rand, origin.add(corner.getFirst(), 3).add(corner.getLast(), 3), List.of(corner.getFirst(), corner.getLast()), 14);
        this.pillar(editor, rand, origin.add(corner.getFirst(), 7).add(corner.getLast(), 7), List.of(Cardinal.reverse(corner.getFirst()), Cardinal.reverse(corner.getLast())), 14);
        corner.forEach(dir -> {
            Cardinal o = dir == corner.getFirst() ? (Cardinal)((Object)((Object)corner.getLast())) : (Cardinal)((Object)((Object)corner.getFirst()));
            this.pillar(editor, rand, origin.add((Cardinal)((Object)dir), 3).add(o), List.of(Cardinal.reverse(o), dir), 14);
            this.pillar(editor, rand, origin.add((Cardinal)((Object)dir), 7).add(o), List.of(Cardinal.reverse(o), Cardinal.reverse(dir)), 14);
            this.pillar(editor, rand, origin.add((Cardinal)((Object)dir), 7).add(o, 3), List.of(o, Cardinal.reverse(dir)), 14);
        });
    }

    private void mainPillarSet(IWorldEditor editor, class_5819 rand, Coord origin, Cardinal dir) {
        this.pillar(editor, rand, origin.copy().add(dir), Cardinal.directions, 2);
        this.pillar(editor, rand, origin.copy().add(dir).add(Cardinal.UP, 4), Cardinal.directions, 2);
        Cardinal.orthogonal(dir).forEach(o -> {
            this.pillar(editor, rand, origin.copy().add(dir, 2).add((Cardinal)((Object)o)), List.of(Cardinal.reverse(dir), dir, o), 14);
            this.pillar(editor, rand, origin.copy().add(dir, 6).add((Cardinal)((Object)o)), Cardinal.directions, 14);
        });
        this.theme.getPrimary().getStair().setOrientation(Cardinal.reverse(dir), true).set(editor, rand, origin.copy().add(dir, 2).add(Cardinal.UP, 14));
    }

    private void pillar(IWorldEditor editor, class_5819 rand, Coord origin, List<Cardinal> directions, int height) {
        BoundingBox.of(origin).grow(Cardinal.UP, height).fill(editor, rand, this.theme.getPrimary().getPillar());
        directions.forEach(dir -> this.theme.getPrimary().getStair().setOrientation((Cardinal)((Object)dir), true).set(editor, rand, origin.copy().add((Cardinal)((Object)dir)).add(Cardinal.UP, height)));
    }

    private void ceiling(IWorldEditor editor, class_5819 rand, Coord origin) {
        Cardinal.directions.forEach(dir -> List.of(Integer.valueOf(2), Integer.valueOf(4), Integer.valueOf(8), Integer.valueOf(10), Integer.valueOf(14)).forEach(step -> BoundingBox.of(origin).add(Cardinal.UP, 5).add((Cardinal)((Object)dir), (int)step).grow(Cardinal.orthogonal(dir), 14).fill(editor, rand, this.theme.getPrimary().getWall())));
    }

    private void tower(IWorldEditor editor, class_5819 rand, Coord origin) {
        IBlockFactory walls = this.theme.getPrimary().getWall();
        IStair stair = this.theme.getPrimary().getStair();
        BoundingBox.of(origin).add(Cardinal.DOWN).grow(Cardinal.directions).fill(editor, rand, this.theme.getPrimary().getFloor());
        Cardinal.directions.forEach(dir -> {
            BoundingBox.of(origin).add((Cardinal)((Object)dir), 2).add(Cardinal.left(dir), 2).grow(Cardinal.DOWN, 10).grow(Cardinal.UP, 5).fill(editor, rand, this.theme.getPrimary().getPillar());
            BoundingBox.of(origin).add((Cardinal)((Object)dir), 2).add(Cardinal.UP, 3).grow(Cardinal.orthogonal(dir)).grow(Cardinal.UP, 2).fill(editor, rand, walls);
            BoundingBox.of(origin).add((Cardinal)((Object)dir), 2).add(Cardinal.DOWN).grow(Cardinal.orthogonal(dir)).grow(Cardinal.DOWN).fill(editor, rand, walls);
            Lantern.set(editor, origin.copy().add((Cardinal)((Object)dir), 2).add(Cardinal.DOWN, 3));
            BoundingBox.of(origin).add((Cardinal)((Object)dir), 2).add(Cardinal.DOWN, 6).grow(Cardinal.orthogonal(dir)).fill(editor, rand, walls);
            Cardinal.orthogonal(dir).forEach(o -> {
                stair.setOrientation(Cardinal.reverse(o), true).set(editor, rand, origin.copy().add((Cardinal)((Object)dir), 2).add((Cardinal)((Object)((Object)o))).add(Cardinal.UP, 2));
                stair.setOrientation(Cardinal.reverse(o), true).set(editor, rand, origin.copy().add((Cardinal)((Object)dir), 2).add((Cardinal)((Object)((Object)o))).add(Cardinal.DOWN, 3));
                stair.setOrientation(Cardinal.reverse(o), true).set(editor, rand, origin.copy().add((Cardinal)((Object)dir), 2).add((Cardinal)((Object)((Object)o))).add(Cardinal.DOWN, 7));
                stair.setOrientation(Cardinal.reverse(o), true).set(editor, rand, origin.copy().add((Cardinal)((Object)dir), 3).add((Cardinal)((Object)((Object)o))).add(Cardinal.UP, 4));
                stair.setOrientation((Cardinal)((Object)dir), true).set(editor, rand, origin.copy().add((Cardinal)((Object)dir), 4).add((Cardinal)((Object)((Object)o)), 2).add(Cardinal.UP, 4));
                stair.setOrientation((Cardinal)((Object)dir), true).set(editor, rand, origin.copy().add((Cardinal)((Object)dir), 3).add((Cardinal)((Object)((Object)o)), 2).add(Cardinal.UP, 2));
                BoundingBox.of(origin).add((Cardinal)((Object)dir), 3).add((Cardinal)((Object)((Object)o)), 2).add(Cardinal.UP, 3).grow(Cardinal.UP).getShape(Shape.RECTSOLID).fill(editor, rand, walls);
            });
            if (this.getEntrance((Cardinal)((Object)dir)) != Entrance.DOOR) {
                BoundingBox.of(origin).add((Cardinal)((Object)dir), 2).grow(Cardinal.orthogonal(dir)).fill(editor, rand, IronBar.getBroken());
            }
        });
    }

    private void doors(IWorldEditor editor, class_5819 rand, Coord origin) {
        this.getEntrancesFromType(Entrance.DOOR).forEach(dir -> Fragment.generate(Fragment.ARCH, editor, rand, this.theme, origin.copy().add((Cardinal)((Object)dir), 12), dir));
    }

    private void clear(IWorldEditor editor, class_5819 rand, Coord origin) {
        BoundingBox.of(origin).grow(Cardinal.directions, 14).grow(Cardinal.DOWN, 10).grow(Cardinal.UP, 5).fill(editor, rand, Air.get());
        BoundingBox.of(origin).add(Cardinal.DOWN, 11).grow(Cardinal.directions, 15).fill(editor, rand, this.theme.getPrimary().getFloor());
        BoundingBox.of(origin).add(Cardinal.UP, 6).grow(Cardinal.directions, 15).fill(editor, rand, this.theme.getPrimary().getWall(), false, true);
        Cardinal.directions.forEach(dir -> BoundingBox.of(origin).add((Cardinal)((Object)dir), 15).grow(Cardinal.orthogonal(dir), 15).grow(Cardinal.DOWN, 11).grow(Cardinal.UP, 6).fill(editor, rand, this.theme.getPrimary().getWall(), false, true));
    }

    @Override
    public CellManager getCells(Cardinal dir) {
        CellManager cells = super.getCells(dir);
        Coord origin = Coord.ZERO.add(Cardinal.DOWN);
        BoundingBox bb = BoundingBox.of(origin);
        bb.add(dir, 2).grow(Cardinal.directions);
        bb.getShape(Shape.RECTSOLID).get().forEach(pos -> cells.add(Cell.of(pos, CellState.OBSTRUCTED)));
        for (Cardinal d : Cardinal.directions) {
            cells.add(Cell.of(origin.copy().add(dir, 2).add(d, 2), CellState.OBSTRUCTED).addWall(d));
            cells.add(Cell.of(origin.copy().add(dir, 2).add(d, 2).add(Cardinal.left(d), 2), CellState.OBSTRUCTED).addWall(d).addWall(Cardinal.left(d)));
            for (Cardinal o : Cardinal.orthogonal(d)) {
                cells.add(Cell.of(origin.copy().add(dir, 2).add(d, 2).add(o), CellState.OBSTRUCTED).addWall(d));
            }
        }
        return cells;
    }

    @Override
    public BoundingBox getBoundingBox(Coord origin, Cardinal dir) {
        return super.getBoundingBox(origin, dir).grow(Cardinal.DOWN, 10);
    }

    @Override
    public String getName() {
        return Room.PANOPTICON.name();
    }
}

