/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.dungeon.room;

import com.greymerk.roguelike.dungeon.fragment.Fragment;
import com.greymerk.roguelike.dungeon.fragment.parts.CellSupport;
import com.greymerk.roguelike.dungeon.fragment.parts.Pillar;
import com.greymerk.roguelike.dungeon.layout.Entrance;
import com.greymerk.roguelike.dungeon.room.AbstractMediumRoom;
import com.greymerk.roguelike.dungeon.room.IRoom;
import com.greymerk.roguelike.dungeon.room.Room;
import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.blocks.Air;
import com.greymerk.roguelike.editor.blocks.IronBar;
import com.greymerk.roguelike.editor.boundingbox.BoundingBox;
import java.util.List;
import net.minecraft.class_5819;

public class PrisonRoom
extends AbstractMediumRoom
implements IRoom {
    @Override
    public void generate(IWorldEditor editor) {
        Coord origin = this.worldPos.copy().add(this.direction, 6).freeze();
        class_5819 rand = editor.getRandom(origin);
        this.clear(editor, rand, origin);
        this.ceiling(editor, rand, origin);
        this.cornerCells(editor, rand, origin);
        this.entrances(editor, rand, origin);
        this.center(editor, rand, origin);
        this.supports(editor, rand, origin);
    }

    private void supports(IWorldEditor editor, class_5819 rand, Coord origin) {
        CellSupport.generate(editor, rand, this.theme, origin);
        Cardinal.directions.forEach(dir -> {
            CellSupport.generate(editor, rand, this.theme, origin.copy().add((Cardinal)((Object)dir), 6));
            CellSupport.generate(editor, rand, this.theme, origin.copy().add((Cardinal)((Object)dir), 6).add(Cardinal.left(dir), 6));
        });
    }

    private void ceiling(IWorldEditor editor, class_5819 rand, Coord origin) {
        Cardinal.directions.forEach(dir -> {
            BoundingBox.of(origin).add((Cardinal)((Object)dir), 8).add(Cardinal.UP, 3).grow(Cardinal.orthogonal(dir), 8).grow(Cardinal.UP).fill(editor, rand, this.theme.getPrimary().getWall());
            BoundingBox.of(origin).add(Cardinal.UP, 4).add((Cardinal)((Object)dir), 2).grow(Cardinal.orthogonal(dir), 8).grow(Cardinal.UP).fill(editor, rand, this.theme.getPrimary().getWall());
            BoundingBox.of(origin).add(Cardinal.UP, 4).add((Cardinal)((Object)dir), 4).grow(Cardinal.orthogonal(dir), 8).grow(Cardinal.UP).fill(editor, rand, this.theme.getPrimary().getWall());
            Cardinal.orthogonal(dir).forEach(o -> List.of(Integer.valueOf(2), Integer.valueOf(4), Integer.valueOf(8)).forEach(step -> {
                this.theme.getPrimary().getWall().set(editor, rand, origin.add(Cardinal.UP, 6).add((Cardinal)((Object)dir), 2).add((Cardinal)((Object)((Object)o)), (int)step), true, false);
                this.theme.getPrimary().getWall().set(editor, rand, origin.add(Cardinal.UP, 6).add((Cardinal)((Object)dir), 4).add((Cardinal)((Object)((Object)o)), (int)step), true, false);
            }));
            this.theme.getPrimary().getWall().set(editor, rand, origin.add(Cardinal.UP, 5).add((Cardinal)((Object)dir), 8).add(Cardinal.left(dir), 8), true, false);
        });
        BoundingBox.of(origin).add(Cardinal.UP, 5).grow(Cardinal.directions, 8).fill(editor, rand, this.theme.getPrimary().getWall(), false, true);
    }

    private void center(IWorldEditor editor, class_5819 rand, Coord origin) {
        Cardinal.directions.forEach(dir -> {
            if (this.getEntrance((Cardinal)((Object)dir)) == Entrance.WALL && this.getEntrance(Cardinal.left(dir)) != Entrance.WALL) {
                Pillar.generate(editor, rand, origin.add((Cardinal)((Object)dir), 3).add(Cardinal.left(dir), 3), this.theme, 3, List.of(Cardinal.left(dir), Cardinal.reverse(dir), Cardinal.right(dir)));
            }
            if (this.getEntrance((Cardinal)((Object)dir)) == Entrance.WALL && this.getEntrance(Cardinal.left(dir)) == Entrance.WALL) {
                Pillar.generate(editor, rand, origin.add((Cardinal)((Object)dir), 3).add(Cardinal.left(dir), 3), this.theme, 3, List.of(Cardinal.reverse(dir), Cardinal.right(dir)));
            }
            if (this.getEntrance((Cardinal)((Object)dir)) != Entrance.WALL && this.getEntrance(Cardinal.left(dir)) != Entrance.WALL) {
                Pillar.generate(editor, rand, origin.add((Cardinal)((Object)dir), 4).add(Cardinal.left(dir), 4), this.theme, 3, List.of(Cardinal.reverse(dir), Cardinal.right(dir)));
            }
            if (this.getEntrance((Cardinal)((Object)dir)) != Entrance.WALL && this.getEntrance(Cardinal.left(dir)) == Entrance.WALL) {
                Pillar.generate(editor, rand, origin.add((Cardinal)((Object)dir), 3).add(Cardinal.left(dir), 3), this.theme, 3, List.of(dir, Cardinal.reverse(dir), Cardinal.right(dir)));
            }
        });
    }

    private void entrances(IWorldEditor editor, class_5819 rand, Coord origin) {
        Cardinal.directions.forEach(dir -> {
            if (this.getEntrance((Cardinal)((Object)dir)) == Entrance.WALL) {
                this.cellWall(editor, rand, origin, (Cardinal)((Object)dir));
            } else {
                this.entry(editor, rand, origin, (Cardinal)((Object)dir));
            }
        });
    }

    private void entry(IWorldEditor editor, class_5819 rand, Coord origin, Cardinal dir) {
        Cardinal.orthogonal(dir).forEach(o -> {
            Pillar.generate(editor, rand, origin.add(dir, 8).add((Cardinal)((Object)o), 2), this.theme, 2, List.of(Cardinal.reverse(dir), Cardinal.reverse(o)));
            this.theme.getPrimary().getWall().set(editor, rand, origin.add(dir, 7).add((Cardinal)((Object)o), 2).add(Cardinal.UP, 3));
        });
        if (this.getEntrance(dir) == Entrance.DOOR) {
            Fragment.generate(Fragment.ARCH, editor, rand, this.theme, origin.add(dir, 6), dir);
        } else if (this.getEntrance(dir) == Entrance.ALCOVE) {
            BoundingBox.of(origin).add(dir, 9).grow(Cardinal.orthogonal(dir), 2).grow(Cardinal.UP, 2).fill(editor, rand, this.theme.getPrimary().getWall(), false, true);
            this.settings.getAlcove(rand).generate(editor, rand, this.theme, origin.add(dir, 6), dir);
        }
    }

    private void cellWall(IWorldEditor editor, class_5819 rand, Coord origin, Cardinal dir) {
        Cardinal.orthogonal(dir).forEach(o -> {
            BoundingBox.of(origin).add(dir, 4).add((Cardinal)((Object)o), 2).grow((Cardinal)((Object)o)).grow(Cardinal.UP, 4).fill(editor, rand, this.theme.getPrimary().getWall());
            BoundingBox.of(origin).add(dir, 5).add((Cardinal)((Object)o), 2).add(Cardinal.UP, 3).grow(dir, 2).fill(editor, rand, this.theme.getPrimary().getWall());
            BoundingBox.of(origin).add(dir, 8).add((Cardinal)((Object)o), 2).grow(Cardinal.UP, 2).fill(editor, rand, this.theme.getPrimary().getWall());
            this.bars(editor, rand, origin.add(dir, 6).add((Cardinal)((Object)o), 2), (Cardinal)((Object)o));
            this.theme.getPrimary().getStair().setOrientation(Cardinal.reverse(o), true).set(editor, rand, origin.add(dir, 8).add(Cardinal.UP, 2).add((Cardinal)((Object)o)));
            BoundingBox.of(origin).add(dir, 4).add((Cardinal)((Object)o), 4).grow(Cardinal.UP, 4).fill(editor, rand, this.theme.getPrimary().getWall());
        });
        BoundingBox.of(origin).add(dir, 4).add(Cardinal.UP, 3).grow(Cardinal.orthogonal(dir)).grow(Cardinal.UP).fill(editor, rand, this.theme.getPrimary().getWall());
        this.bars(editor, rand, origin.add(dir, 4), dir);
        BoundingBox.of(origin).add(dir, 9).grow(Cardinal.orthogonal(dir), 2).grow(Cardinal.UP, 2).fill(editor, rand, this.theme.getPrimary().getWall(), false, true);
        this.settings.getWallFragment(rand).generate(editor, rand, this.theme, origin.add(dir, 6), dir);
    }

    private void cornerCells(IWorldEditor editor, class_5819 rand, Coord origin) {
        Cardinal.directions.forEach(dir -> {
            Pillar.generate(editor, rand, origin.add((Cardinal)((Object)dir), 8).add(Cardinal.left(dir), 8), this.theme, 2, List.of(Cardinal.reverse(dir), Cardinal.right(dir)));
            Cardinal.orthogonal(dir).forEach(o -> {
                Pillar.generate(editor, rand, origin.add((Cardinal)((Object)dir), 8).add((Cardinal)((Object)((Object)o)), 4), this.theme, 2, List.of(o));
                BoundingBox.of(origin).add((Cardinal)((Object)dir), 5).add((Cardinal)((Object)((Object)o)), 4).add(Cardinal.UP, 3).grow((Cardinal)((Object)dir), 2).fill(editor, rand, this.theme.getPrimary().getWall());
                this.bars(editor, rand, origin.add((Cardinal)((Object)dir), 6).add((Cardinal)((Object)((Object)o)), 4), (Cardinal)((Object)((Object)o)));
                this.settings.getWallFragment(rand).generate(editor, rand, this.theme, origin.add((Cardinal)((Object)dir), 6).add((Cardinal)((Object)((Object)o)), 6), (Cardinal)((Object)((Object)o)));
            });
        });
    }

    private void clear(IWorldEditor editor, class_5819 rand, Coord origin) {
        BoundingBox.of(origin).grow(Cardinal.directions, 8).grow(Cardinal.UP, 4).fill(editor, rand, Air.get());
        BoundingBox.of(origin).add(Cardinal.DOWN).grow(Cardinal.directions, 9).fill(editor, rand, this.theme.getPrimary().getFloor());
        Cardinal.directions.forEach(dir -> Cardinal.orthogonal(dir).forEach(o -> BoundingBox.of(origin).add((Cardinal)((Object)dir), 9).add((Cardinal)((Object)((Object)o)), 3).grow((Cardinal)((Object)((Object)o)), 6).grow(Cardinal.UP, 3).fill(editor, rand, this.theme.getPrimary().getWall(), false, true)));
    }

    private void bars(IWorldEditor editor, class_5819 rand, Coord origin, Cardinal dir) {
        BoundingBox.of(origin).grow(Cardinal.orthogonal(dir)).grow(Cardinal.UP, 2).fill(editor, rand, IronBar.getBroken());
    }

    @Override
    public String getName() {
        return Room.PRISON.name();
    }
}

