/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.dungeon.room;

import com.greymerk.roguelike.dungeon.fragment.Fragment;
import com.greymerk.roguelike.dungeon.fragment.parts.Pillar;
import com.greymerk.roguelike.dungeon.layout.Entrance;
import com.greymerk.roguelike.dungeon.room.AbstractLargeRoom;
import com.greymerk.roguelike.dungeon.room.IRoom;
import com.greymerk.roguelike.dungeon.room.Room;
import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.IBlockFactory;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.MetaBlock;
import com.greymerk.roguelike.editor.blocks.Air;
import com.greymerk.roguelike.editor.blocks.Campfire;
import com.greymerk.roguelike.editor.blocks.Lantern;
import com.greymerk.roguelike.editor.blocks.slab.ISlab;
import com.greymerk.roguelike.editor.blocks.spawners.Spawner;
import com.greymerk.roguelike.editor.blocks.stair.IStair;
import com.greymerk.roguelike.editor.boundingbox.BoundingBox;
import com.greymerk.roguelike.filter.Filter;
import com.greymerk.roguelike.treasure.Treasure;
import com.greymerk.roguelike.util.WeightedChoice;
import com.greymerk.roguelike.util.WeightedRandomizer;
import com.greymerk.roguelike.util.math.RandHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_2246;
import net.minecraft.class_5819;

public class SculkRoom
extends AbstractLargeRoom
implements IRoom {
    List<Coord> spawners = new ArrayList<Coord>();

    @Override
    public void generate(IWorldEditor editor) {
        Coord origin = this.getWorldPos().copy().add(this.direction, 12).freeze();
        class_5819 rand = editor.getRandom(origin);
        this.clear(editor, rand, origin);
        this.ceiling(editor, rand, origin);
        this.floor(editor, rand, origin);
        this.braziers(editor, rand, origin);
        this.pillars(editor, rand, origin);
        this.deco(editor, rand, origin);
        this.tower(editor, rand, origin);
        this.bridges(editor, rand, origin);
        this.placeSpawners(editor, rand, origin);
        this.placeChests(editor, rand, origin);
        Filter.get(Filter.SCULK).apply(editor, rand, this.theme, this.getBoundingBox().get());
    }

    private void placeChests(IWorldEditor editor, class_5819 rand, Coord origin) {
        WeightedRandomizer<Treasure> types = new WeightedRandomizer<Treasure>().add(new WeightedChoice<Treasure>(Treasure.ARMOR, 1)).add(new WeightedChoice<Treasure>(Treasure.TOOL, 1)).add(new WeightedChoice<Treasure>(Treasure.WEAPON, 1));
        List empty = BoundingBox.of(origin).add(Cardinal.DOWN, 2).grow(Cardinal.directions, 9).get().stream().filter(pos -> editor.isAir((Coord)pos)).filter(pos -> this.checkerBoard((Coord)pos)).collect(Collectors.toList());
        RandHelper.shuffle(empty, rand);
        empty.subList(0, rand.method_39332(5, 9)).forEach(pos -> Treasure.generate(editor, rand, pos, (Treasure)((Object)((Object)types.get(rand)))));
    }

    private boolean checkerBoard(Coord pos) {
        int x = pos.getX();
        int z = pos.getZ();
        if (Math.floorMod(x, 2) == 0 && Math.floorMod(z, 2) == 0) {
            return true;
        }
        return Math.floorMod(x, 2) == 1 && Math.floorMod(z, 2) == 1;
    }

    private void bridges(IWorldEditor editor, class_5819 rand, Coord origin) {
        this.getEntrancesFromType(Entrance.DOOR).forEach(dir -> this.bridge(editor, rand, origin, (Cardinal)((Object)dir)));
    }

    private void bridge(IWorldEditor editor, class_5819 rand, Coord origin, Cardinal dir) {
        BoundingBox.of(origin).add(dir, 3).add(Cardinal.DOWN).grow(Cardinal.orthogonal(dir)).grow(dir, 7).fill(editor, rand, this.theme.getPrimary().getFloor());
        BoundingBox.of(origin).add(dir, 4).add(Cardinal.DOWN, 2).grow(Cardinal.orthogonal(dir), 2).grow(dir, 5).fill(editor, rand, this.theme.getPrimary().getWall());
    }

    private void placeSpawners(IWorldEditor editor, class_5819 rand, Coord origin) {
        WeightedRandomizer<Spawner> types = new WeightedRandomizer<Spawner>();
        types.add(new WeightedChoice<Spawner>(Spawner.CAVESPIDER, 1));
        types.add(new WeightedChoice<Spawner>(Spawner.CREEPER, 1));
        types.add(new WeightedChoice<Spawner>(Spawner.ZOMBIE, 3));
        types.add(new WeightedChoice<Spawner>(Spawner.SKELETON, 3));
        types.add(new WeightedChoice<Spawner>(Spawner.SPIDER, 2));
        this.spawners.forEach(pos -> {
            if (rand.method_43056()) {
                Spawner.generate(editor, rand, pos, (Spawner)((Object)((Object)types.get(rand))));
            }
        });
    }

    private void tower(IWorldEditor editor, class_5819 rand, Coord origin) {
        IBlockFactory walls = this.theme.getPrimary().getWall();
        BoundingBox.of(origin).add(Cardinal.DOWN, 2).grow(Cardinal.directions, 3).fill(editor, rand, walls);
        BoundingBox.of(origin).add(Cardinal.DOWN).grow(Cardinal.directions, 2).fill(editor, rand, walls);
        Cardinal.directions.forEach(dir -> {
            Pillar.generate(editor, rand, origin.copy().add((Cardinal)((Object)dir), 2).add(Cardinal.left(dir), 2), this.theme, 3);
            Cardinal.orthogonal(dir).forEach(o -> Pillar.generate(editor, rand, origin.copy().add((Cardinal)((Object)dir), 3).add((Cardinal)((Object)((Object)o)), 2).add(Cardinal.UP, 4), this.theme, 1, List.of(dir, Cardinal.reverse(o))));
            BoundingBox.of(origin).add((Cardinal)((Object)dir), 2).add(Cardinal.UP, 4).grow(Cardinal.orthogonal(dir), 3).grow(Cardinal.UP, 3).fill(editor, rand, walls);
            this.spawners.add(origin.copy().add((Cardinal)((Object)dir), 2).add(Cardinal.UP, 5));
            this.spawners.add(origin.copy().add((Cardinal)((Object)dir)).add(Cardinal.left(dir)).add(Cardinal.DOWN, 2));
        });
        Lantern.set(editor, origin.copy().add(Cardinal.UP, 6), Lantern.SOUL, true);
        BoundingBox.of(origin).add(Cardinal.UP, 7).grow(Cardinal.directions, 2).fill(editor, rand, walls);
        MetaBlock.of(class_2246.field_37570).set(editor, origin);
    }

    private void deco(IWorldEditor editor, class_5819 rand, Coord origin) {
        Cardinal.directions.forEach(dir -> Cardinal.orthogonal(dir).forEach(o -> List.of(Integer.valueOf(6), Integer.valueOf(12)).forEach(step -> this.settings.getWallFragment(rand).generate(editor, rand, this.theme, origin.copy().add((Cardinal)((Object)dir), 12).add((Cardinal)((Object)((Object)o)), (int)step), (Cardinal)((Object)dir)))));
    }

    private void pillars(IWorldEditor editor, class_5819 rand, Coord origin) {
        Cardinal.directions.forEach(dir -> {
            Cardinal.orthogonal(dir).forEach(o -> List.of(Integer.valueOf(3), Integer.valueOf(9)).forEach(step -> this.pillarSet(editor, rand, origin.copy().add((Cardinal)((Object)dir), 12).add((Cardinal)((Object)((Object)o)), (int)step).freeze(), (Cardinal)((Object)dir))));
            Pillar.generate(editor, rand, origin.copy().add((Cardinal)((Object)dir), 14).add(Cardinal.left(dir), 14), this.theme, 4, List.of(Cardinal.right(dir), Cardinal.reverse(dir)));
        });
    }

    private void pillarSet(IWorldEditor editor, class_5819 rand, Coord origin, Cardinal dir) {
        this.theme.getPrimary().getStair().setOrientation(Cardinal.reverse(dir), true).set(editor, rand, origin.copy().add(dir, 2).add(Cardinal.UP, 4));
        Cardinal.orthogonal(dir).forEach(o -> {
            Pillar.generate(editor, rand, origin.copy().add(dir, 2).add((Cardinal)((Object)o)), this.theme, 4, List.of(o, Cardinal.reverse(dir)));
            this.theme.getPrimary().getWall().set(editor, rand, origin.copy().add(dir).add((Cardinal)((Object)o)).add(Cardinal.UP, 5));
        });
    }

    private void braziers(IWorldEditor editor, class_5819 rand, Coord origin) {
        Cardinal.directions.forEach(dir -> this.brazier(editor, rand, origin.add((Cardinal)((Object)dir), 9).add(Cardinal.left(dir), 9).freeze()));
    }

    private void brazier(IWorldEditor editor, class_5819 rand, Coord origin) {
        IBlockFactory walls = this.theme.getPrimary().getWall();
        IStair stair = this.theme.getPrimary().getStair();
        ISlab slab = this.theme.getPrimary().getSlab();
        this.spawners.add(origin);
        walls.set(editor, rand, origin);
        Campfire.generate(editor, origin.copy().add(Cardinal.UP), Campfire.SOUL);
        Cardinal.directions.forEach(dir -> {
            stair.setOrientation((Cardinal)((Object)dir), true).set(editor, rand, origin.copy().add((Cardinal)((Object)dir)));
            stair.setOrientation(Cardinal.reverse(dir), false).set(editor, rand, origin.copy().add((Cardinal)((Object)dir)).add(Cardinal.UP));
            stair.setOrientation((Cardinal)((Object)dir), false).set(editor, rand, origin.copy().add((Cardinal)((Object)dir)).add(Cardinal.DOWN));
            slab.upsideDown(false).set(editor, origin.copy().add(Cardinal.DOWN).add((Cardinal)((Object)dir)).add(Cardinal.left(dir)));
            this.spawners.add(origin.copy().add(Cardinal.DOWN, 2).add((Cardinal)((Object)dir)).add(Cardinal.left(dir)));
        });
        BoundingBox.of(origin).add(Cardinal.DOWN, 2).grow(Cardinal.directions, 2).fill(editor, rand, walls);
    }

    private void floor(IWorldEditor editor, class_5819 rand, Coord origin) {
        Cardinal.directions.forEach(dir -> {
            BoundingBox.of(origin).add(Cardinal.DOWN).add((Cardinal)((Object)dir), 12).grow((Cardinal)((Object)dir), 3).grow(Cardinal.left(dir), 15).grow(Cardinal.right(dir), 11).fill(editor, rand, this.theme.getPrimary().getFloor());
            BoundingBox.of(origin).add(Cardinal.DOWN).add((Cardinal)((Object)dir), 11).grow(Cardinal.orthogonal(dir), 11).fill(editor, rand, this.theme.getPrimary().getWall());
            BoundingBox.of(origin).add(Cardinal.DOWN, 2).add((Cardinal)((Object)dir), 11).grow((Cardinal)((Object)dir), 4).grow(Cardinal.left(dir), 15).grow(Cardinal.right(dir), 11).fill(editor, rand, this.theme.getPrimary().getFloor());
            BoundingBox.of(origin).add(Cardinal.DOWN, 2).add((Cardinal)((Object)dir), 10).grow(Cardinal.orthogonal(dir), 10).fill(editor, rand, this.theme.getPrimary().getWall());
        });
    }

    private void ceiling(IWorldEditor editor, class_5819 rand, Coord origin) {
        Cardinal.directions.forEach(dir -> {
            List.of(Integer.valueOf(2), Integer.valueOf(4), Integer.valueOf(8), Integer.valueOf(10)).forEach(step -> BoundingBox.of(origin).add(Cardinal.UP, 6).add((Cardinal)((Object)dir), (int)step).grow(Cardinal.orthogonal(dir), 15).fill(editor, rand, this.theme.getPrimary().getWall()));
            BoundingBox.of(origin).add((Cardinal)((Object)dir), 14).add(Cardinal.UP, 5).grow(Cardinal.UP, 2).grow(Cardinal.orthogonal(dir), 14).fill(editor, rand, this.theme.getPrimary().getWall());
        });
    }

    private void clear(IWorldEditor editor, class_5819 rand, Coord origin) {
        BoundingBox.of(origin).grow(Cardinal.directions, 14).grow(Cardinal.DOWN, 2).grow(Cardinal.UP, 6).fill(editor, rand, Air.get());
        Cardinal.directions.forEach(dir -> {
            BoundingBox.of(origin).add((Cardinal)((Object)dir), 15).grow(Cardinal.orthogonal(dir), 15).fill(editor, rand, this.theme.getPrimary().getWall(), false, true);
            if (this.getEntrance((Cardinal)((Object)dir)) == Entrance.DOOR) {
                Fragment.generate(Fragment.ARCH, editor, rand, this.theme, origin.copy().add((Cardinal)((Object)dir), 12), dir);
            }
        });
        BoundingBox.of(origin).add(Cardinal.UP, 7).grow(Cardinal.directions, 15).fill(editor, rand, this.theme.getPrimary().getWall(), false, true);
        BoundingBox.of(origin).add(Cardinal.DOWN, 3).grow(Cardinal.directions, 15).fill(editor, rand, this.theme.getPrimary().getWall());
    }

    @Override
    public String getName() {
        return Room.SCULK.name();
    }
}

