/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.editor.shapes;

import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.IBlockFactory;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.boundingbox.BoundingBox;
import com.greymerk.roguelike.editor.shapes.IShape;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_5819;

public class RectPyramid
implements IShape {
    private BoundingBox bb;

    public RectPyramid(BoundingBox bb) {
        this.bb = bb;
    }

    @Override
    public Iterator<Coord> iterator() {
        return new SquarePyramidIterator(this, this.bb);
    }

    @Override
    public void fill(IWorldEditor editor, class_5819 rand, IBlockFactory block) {
        this.fill(editor, rand, block, true, true);
    }

    @Override
    public void fill(IWorldEditor editor, class_5819 rand, IBlockFactory block, boolean fillAir, boolean replaceSolid) {
        for (Coord pos : this) {
            block.set(editor, rand, pos, fillAir, replaceSolid);
        }
    }

    @Override
    public List<Coord> get() {
        ArrayList<Coord> shape = new ArrayList<Coord>();
        for (Coord pos : this) {
            shape.add(pos);
        }
        return shape;
    }

    private class SquarePyramidIterator
    implements Iterator<Coord> {
        Coord start;
        Coord diff;
        Coord cursor;
        Cardinal dir;
        double thetaX;
        double thetaZ;

        public SquarePyramidIterator(RectPyramid rectPyramid, BoundingBox bb) {
            this.start = bb.getStart();
            Coord s = bb.getStart();
            Coord e = bb.getEnd();
            this.cursor = new Coord(0, 0, 0);
            this.dir = Cardinal.NORTH;
            this.diff = e.copy();
            this.diff.sub(s);
            double hx = Math.sqrt(Math.pow(this.diff.getX(), 2.0) + Math.pow(this.diff.getY(), 2.0));
            this.thetaX = Math.acos((double)this.diff.getY() / hx);
            double hz = Math.sqrt(Math.pow(this.diff.getZ(), 2.0) + Math.pow(this.diff.getY(), 2.0));
            this.thetaZ = Math.acos((double)this.diff.getY() / hz);
        }

        @Override
        public boolean hasNext() {
            return this.cursor.getY() < this.diff.getY();
        }

        @Override
        public Coord next() {
            Coord toReturn = this.start.copy();
            toReturn.add(Cardinal.UP, this.cursor.getY());
            if (this.dir == Cardinal.NORTH || this.dir == Cardinal.SOUTH) {
                toReturn.add(Cardinal.left(this.dir), this.cursor.getX());
                toReturn.add(this.dir, this.cursor.getZ());
            } else {
                toReturn.add(this.dir, this.cursor.getX());
                toReturn.add(Cardinal.left(this.dir), this.cursor.getZ());
            }
            if (this.dir != Cardinal.NORTH) {
                this.dir = Cardinal.left(this.dir);
                return toReturn;
            }
            this.cursor.add(Cardinal.SOUTH);
            if (this.inRange(this.cursor)) {
                this.dir = Cardinal.left(this.dir);
                return toReturn;
            }
            this.cursor = new Coord(this.cursor.getX(), this.cursor.getY(), 0);
            this.cursor.add(Cardinal.EAST);
            if (this.inRange(this.cursor)) {
                this.dir = Cardinal.left(this.dir);
                return toReturn;
            }
            this.cursor = new Coord(0, this.cursor.getY(), this.cursor.getZ());
            this.cursor.add(Cardinal.UP);
            this.dir = Cardinal.left(this.dir);
            return toReturn;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private boolean inRange(Coord pos) {
            int y = this.diff.getY() - this.cursor.getY();
            if (!((double)this.cursor.getX() < Math.tan(this.thetaX) * (double)y)) {
                return false;
            }
            return (double)this.cursor.getZ() < Math.tan(this.thetaZ) * (double)y;
        }
    }
}

