/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.filter;

import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.MetaBlock;
import com.greymerk.roguelike.editor.blocks.SculkVein;
import com.greymerk.roguelike.editor.boundingbox.IBounded;
import com.greymerk.roguelike.editor.factories.BlockWeightedRandom;
import com.greymerk.roguelike.filter.IFilter;
import com.greymerk.roguelike.theme.ITheme;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_3481;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_7268;

public class SculkFilter
implements IFilter {
    @Override
    public void apply(IWorldEditor editor, class_5819 rand, ITheme theme, IBounded box) {
        box.getBoundingBox().forEach(pos -> {
            if (rand.method_43048(8) != 0) {
                return;
            }
            if (!editor.isAir((Coord)pos)) {
                return;
            }
            this.generate(editor, rand, pos.copy().add(Cardinal.DOWN).freeze(), 5);
        });
    }

    private void generate(IWorldEditor editor, class_5819 rand, Coord origin, int counter) {
        if (counter <= 0) {
            return;
        }
        if (!editor.isAir(origin.copy().add(Cardinal.UP))) {
            return;
        }
        MetaBlock block = editor.getBlock(origin);
        if (!block.isIn((class_6862<class_2248>)class_3481.field_37400)) {
            return;
        }
        MetaBlock.of(class_2246.field_37568).set(editor, origin);
        MetaBlock shrieker = MetaBlock.of(class_2246.field_37571);
        shrieker.with(class_7268.field_38422, true);
        BlockWeightedRandom blocks = new BlockWeightedRandom().addBlock(MetaBlock.of(class_2246.field_28108), 3).addBlock(MetaBlock.of(class_2246.field_37570), 2).addBlock(shrieker, 1);
        if (rand.method_43048(20) == 0) {
            blocks.set(editor, rand, origin.copy().add(Cardinal.UP));
        } else {
            SculkVein.set(editor, origin.copy().add(Cardinal.UP));
        }
        Cardinal.directions.forEach(dir -> {
            if (rand.method_43056()) {
                this.generate(editor, rand, origin.copy().add((Cardinal)((Object)dir)).freeze(), counter - 1);
            }
        });
    }
}

