/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.treasure.loot;

import com.greymerk.roguelike.dungeon.Difficulty;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.treasure.chest.ITreasureChest;
import com.greymerk.roguelike.treasure.loot.ILoot;
import com.greymerk.roguelike.treasure.loot.LootProvider;
import com.greymerk.roguelike.treasure.loot.LootSettings;
import com.greymerk.roguelike.treasure.loot.Slot;
import com.greymerk.roguelike.treasure.loot.WeightedRandomLoot;
import com.greymerk.roguelike.treasure.loot.provider.ItemArmour;
import com.greymerk.roguelike.treasure.loot.provider.ItemBlock;
import com.greymerk.roguelike.treasure.loot.provider.ItemBrewing;
import com.greymerk.roguelike.treasure.loot.provider.ItemEnchanting;
import com.greymerk.roguelike.treasure.loot.provider.ItemFood;
import com.greymerk.roguelike.treasure.loot.provider.ItemJunk;
import com.greymerk.roguelike.treasure.loot.provider.ItemMusic;
import com.greymerk.roguelike.treasure.loot.provider.ItemOre;
import com.greymerk.roguelike.treasure.loot.provider.ItemPotion;
import com.greymerk.roguelike.treasure.loot.provider.ItemPrecious;
import com.greymerk.roguelike.treasure.loot.provider.ItemSpecialty;
import com.greymerk.roguelike.treasure.loot.provider.ItemSupply;
import com.greymerk.roguelike.treasure.loot.provider.ItemTool;
import com.greymerk.roguelike.treasure.loot.provider.ItemWeapon;
import com.greymerk.roguelike.treasure.loot.rules.RoguelikeLootRules;
import com.greymerk.roguelike.util.IWeighted;
import com.greymerk.roguelike.util.TextFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1814;
import net.minecraft.class_2561;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_7699;
import net.minecraft.class_9290;
import net.minecraft.class_9334;

public enum Loot {
    WEAPON,
    ARMOUR,
    BLOCK,
    JUNK,
    ORE,
    TOOL,
    POTION,
    FOOD,
    ENCHANTING,
    SUPPLY,
    MUSIC,
    SPECIAL,
    BREWING,
    PRECIOUS;


    public static ILoot getLoot(IWorldEditor editor) {
        LootProvider loot = new LootProvider();
        List.of(Difficulty.values()).forEach(diff -> loot.put((Difficulty)((Object)diff), new LootSettings((Difficulty)((Object)diff), editor)));
        return loot;
    }

    public static void fillChest(IWorldEditor editor, ITreasureChest chest, class_5819 rand) {
        RoguelikeLootRules.getLoot(editor).process(rand, chest);
    }

    public static class_1799 getLootItem(IWorldEditor editor, Loot type, class_5819 rand, Difficulty diff) {
        return Loot.getProvider(type, diff, editor).get(rand);
    }

    public static IWeighted<class_1799> getProvider(Loot type, Difficulty diff, IWorldEditor editor) {
        class_7699 features = editor.getFeatureSet();
        class_5455 reg = editor.getRegistryManager();
        switch (type.ordinal()) {
            case 0: {
                return new ItemWeapon(reg, features, 0, diff);
            }
            case 1: {
                return new ItemArmour(0, diff, features, reg);
            }
            case 2: {
                return new ItemBlock(0, diff);
            }
            case 3: {
                return new ItemJunk(reg, 0, diff);
            }
            case 4: {
                return new ItemOre(0, diff);
            }
            case 5: {
                return new ItemTool(reg, features, 0, diff);
            }
            case 6: {
                return new ItemPotion(0, diff);
            }
            case 12: {
                return new ItemBrewing(0, diff);
            }
            case 7: {
                return new ItemFood(reg, 0, diff);
            }
            case 8: {
                return new ItemEnchanting(0, diff);
            }
            case 9: {
                return new ItemSupply(0, diff);
            }
            case 10: {
                return new ItemMusic(0, diff);
            }
            case 11: {
                return new ItemSpecialty(reg, 0, diff);
            }
            case 13: {
                return new ItemPrecious(0, diff);
            }
        }
        return new WeightedRandomLoot(class_1802.field_8600, 1);
    }

    public static class_1799 getEquipmentBySlot(class_7699 features, class_5455 reg, class_5819 rand, class_1304 slot, Difficulty diff, boolean enchant) {
        if (slot == class_1304.field_6173) {
            return ItemWeapon.getRandom(reg, features, rand, diff, enchant);
        }
        return ItemArmour.getRandom(features, reg, rand, diff, Slot.getSlot(slot), enchant);
    }

    public static class_1799 getEquipmentBySlot(class_7699 features, class_5455 reg, class_5819 rand, Slot slot, Difficulty diff, boolean enchant) {
        if (slot == Slot.WEAPON) {
            return ItemWeapon.getRandom(reg, features, rand, diff, enchant);
        }
        return ItemArmour.getRandom(features, reg, rand, diff, slot, enchant);
    }

    public static void setRarity(class_1799 item, class_1814 type) {
        switch (type) {
            case field_8906: {
                item.method_57379(class_9334.field_50073, (Object)class_1814.field_8906);
                return;
            }
            case field_8907: {
                item.method_57379(class_9334.field_50073, (Object)class_1814.field_8907);
                return;
            }
            case field_8903: {
                item.method_57379(class_9334.field_50073, (Object)class_1814.field_8903);
                return;
            }
            case field_8904: {
                item.method_57379(class_9334.field_50073, (Object)class_1814.field_8904);
                return;
            }
        }
    }

    public static void setItemLore(class_1799 item, String loreText) {
        ArrayList<class_2561> lines = new ArrayList<class_2561>();
        lines.add(class_2561.method_30163((String)loreText));
        class_9290 lore = new class_9290(lines);
        item.method_57379(class_9334.field_49632, (Object)lore);
    }

    public static void setItemLore(class_1799 item, String loreText, TextFormat option) {
        Loot.setItemLore(item, TextFormat.apply(loreText, option).getString());
    }

    public static void setItemName(class_1799 item, String name) {
        item.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)name));
    }
}

