/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.treasure.loot.provider;

import com.greymerk.roguelike.dungeon.Difficulty;
import com.greymerk.roguelike.treasure.loot.WeightedRandomLoot;
import com.greymerk.roguelike.treasure.loot.potions.PotionMixture;
import com.greymerk.roguelike.treasure.loot.provider.ItemBase;
import com.greymerk.roguelike.treasure.loot.provider.ItemNovelty;
import com.greymerk.roguelike.util.WeightedRandomizer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_5455;
import net.minecraft.class_5819;

public class ItemFood
extends ItemBase {
    private Map<Difficulty, WeightedRandomizer<class_1799>> loot;
    private class_5455 reg;

    public ItemFood(class_5455 reg, int weight, Difficulty diff) {
        super(weight, diff);
        this.reg = reg;
        this.loot = new HashMap<Difficulty, WeightedRandomizer<class_1799>>();
        List.of(Difficulty.values()).forEach(d -> {
            WeightedRandomizer<class_1799> randomizer = new WeightedRandomizer<class_1799>();
            switch (d) {
                case HARDEST: {
                    randomizer.add(new WeightedRandomLoot(class_1802.field_8463, 1));
                    randomizer.add(new WeightedRandomLoot(class_1802.field_8071, 2, 6, 1));
                    randomizer.add(new WeightedRandomLoot(class_1802.field_8176, 3, 9, 5));
                    randomizer.add(new WeightedRandomLoot(class_1802.field_8261, 3, 9, 3));
                    randomizer.add(new WeightedRandomLoot(class_1802.field_8347, 3, 9, 3));
                    break;
                }
                case HARD: {
                    randomizer.add(new WeightedRandomLoot(class_1802.field_8176, 2, 7, 3));
                    randomizer.add(new WeightedRandomLoot(class_1802.field_8261, 2, 7, 3));
                    randomizer.add(new WeightedRandomLoot(class_1802.field_8347, 2, 7, 3));
                    randomizer.add(new WeightedRandomLoot(class_1802.field_8544, 2, 7, 5));
                    randomizer.add(new WeightedRandomLoot(class_1802.field_8512, 4, 9, 5));
                    break;
                }
                case MEDIUM: {
                    randomizer.add(new WeightedRandomLoot(class_1802.field_8176, 2, 5, 3));
                    randomizer.add(new WeightedRandomLoot(class_1802.field_8261, 2, 5, 3));
                    randomizer.add(new WeightedRandomLoot(class_1802.field_8347, 2, 5, 3));
                    randomizer.add(new WeightedRandomLoot(class_1802.field_8544, 2, 5, 5));
                    randomizer.add(new WeightedRandomLoot(class_1802.field_8512, 2, 5, 5));
                    break;
                }
                case EASY: {
                    randomizer.add(new WeightedRandomLoot(class_1802.field_8229, 2, 5, 5));
                    randomizer.add(new WeightedRandomLoot(class_1802.field_8373, 1, 4, 5));
                    randomizer.add(new WeightedRandomLoot(class_1802.field_8509, 1, 4, 5));
                    randomizer.add(new WeightedRandomLoot(class_1802.field_8279, 1, 1, 1));
                    randomizer.add(new WeightedRandomLoot(class_1802.field_8544, 2, 5, 5));
                    randomizer.add(new WeightedRandomLoot(class_1802.field_8512, 2, 5, 5));
                    break;
                }
                case EASIEST: {
                    randomizer.add(new WeightedRandomLoot(class_1802.field_8229, 1, 4, 4));
                    randomizer.add(new WeightedRandomLoot(class_1802.field_8373, 1, 4, 2));
                    randomizer.add(new WeightedRandomLoot(class_1802.field_8279, 1, 1, 2));
                    randomizer.add(new WeightedRandomLoot(class_1802.field_8544, 1, 4, 1));
                    randomizer.add(new WeightedRandomLoot(class_1802.field_8423, 1, 1, 1));
                    break;
                }
                default: {
                    randomizer.add(new WeightedRandomLoot(class_1802.field_8229, 1));
                }
            }
            this.loot.put((Difficulty)((Object)d), randomizer);
        });
    }

    @Override
    public class_1799 getLootItem(class_5819 rand, Difficulty diff) {
        if (rand.method_43048(2000) == 0) {
            return ItemNovelty.getItem(this.reg, ItemNovelty.GENERIKB);
        }
        if (rand.method_43048(2000) == 0) {
            return ItemNovelty.getItem(this.reg, ItemNovelty.AVIDYA);
        }
        if (rand.method_43048(1000) == 0) {
            return ItemNovelty.getItem(this.reg, ItemNovelty.RLEAHY);
        }
        if (rand.method_43048(1000) == 0) {
            return ItemNovelty.getItem(this.reg, ItemNovelty.FOURLES);
        }
        if (diff.lt(Difficulty.MEDIUM) && rand.method_43048(30) == 0) {
            return PotionMixture.getPotion(rand, PotionMixture.COFFEE);
        }
        if (diff.gt(Difficulty.EASY) && rand.method_43048(60) == 0) {
            return PotionMixture.getPotion(rand, PotionMixture.LAUDANUM);
        }
        return this.loot.get((Object)diff).get(rand);
    }
}

