/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.treasure.loot.rules;

import com.greymerk.roguelike.dungeon.Difficulty;
import com.greymerk.roguelike.treasure.Treasure;
import com.greymerk.roguelike.treasure.TreasureManager;
import com.greymerk.roguelike.treasure.chest.ITreasureChest;
import com.greymerk.roguelike.treasure.loot.rules.LootRule;
import com.greymerk.roguelike.util.IWeighted;
import com.greymerk.roguelike.util.WeightedChoice;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_5819;

public class LootRuleManager {
    private List<LootRule> rules = new ArrayList<LootRule>();

    public void add(Treasure type, IWeighted<class_1799> item, Difficulty diff, int amount) {
        this.rules.add(new LootRule(type, item, diff, amount));
    }

    public void add(Treasure type, class_1799 item, Difficulty diff, int amount) {
        WeightedChoice<class_1799> toAdd = new WeightedChoice<class_1799>(item, 1);
        this.rules.add(new LootRule(type, toAdd, diff, amount));
    }

    public void add(LootRule toAdd) {
        this.rules.add(toAdd);
    }

    public void add(LootRuleManager other) {
        if (other == null) {
            return;
        }
        this.rules.addAll(other.rules);
    }

    public void process(class_5819 rand, TreasureManager treasure) {
        for (LootRule rule : this.rules) {
            rule.process(rand, treasure);
        }
    }

    public void process(class_5819 rand, ITreasureChest chest) {
        for (LootRule rule : this.rules) {
            rule.process(rand, chest);
        }
    }

    public String toString() {
        return Integer.toString(this.rules.size());
    }
}

