/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.util;

import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.util.ChunkSet;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1923;
import net.minecraft.class_2919;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6873;

public enum StructureLocator {
    VILLAGE,
    TRIAL_CHAMBER;


    public static boolean hasVillage(long seed, class_1923 cpos) {
        return StructureLocator.hasStructure(seed, VILLAGE, cpos);
    }

    public static boolean hasStructure(long seed, StructureLocator type, class_1923 cpos) {
        switch (type.ordinal()) {
            case 0: {
                return StructureLocator.hasRandomScatteredStructure(seed, cpos, 34, 8, class_6873.field_36421, 10387312);
            }
            case 1: {
                return StructureLocator.hasRandomScatteredStructure(seed, cpos, 34, 12, class_6873.field_36421, 94251327);
            }
        }
        return false;
    }

    public static boolean hasRandomScatteredStructure(long seed, class_1923 cpos, int spacing, int separation, class_6873 spread, int salt) {
        int i = Math.floorDiv(cpos.field_9181, spacing);
        int j = Math.floorDiv(cpos.field_9180, spacing);
        class_2919 chunkRandom = new class_2919((class_5819)new class_5820(0L));
        chunkRandom.method_12665(seed, i, j, salt);
        int k = spacing - separation;
        int l = spread.method_40173((class_5819)chunkRandom, k);
        int m = spread.method_40173((class_5819)chunkRandom, k);
        class_1923 cp2 = new class_1923(i * spacing + l, j * spacing + m);
        return cp2.field_9181 == cpos.field_9181 && cp2.field_9180 == cpos.field_9180;
    }

    public static boolean hasConcentricRingStructure(long seed, class_1923 cpos) {
        return false;
    }

    public static Set<Coord> scan(long seed, Coord origin, StructureLocator type, int range) {
        HashSet<Coord> locations = new HashSet<Coord>();
        ChunkSet chunks = new ChunkSet(origin, range);
        chunks.forEach(cpos -> {
            if (StructureLocator.hasStructure(seed, type, cpos)) {
                locations.add(Coord.of(cpos.method_33943(0)));
            }
        });
        return locations;
    }
}

