/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.util.math;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import net.minecraft.class_5819;

public class RandHelper {
    private static final int SHUFFLE_THRESHOLD = 5;

    public static <T> T pickFrom(List<T> list, class_5819 rand) {
        if (list.size() == 0) {
            return null;
        }
        return list.get(rand.method_43048(list.size()));
    }

    public static <T> List<T> pickCountFrom(List<T> list, class_5819 rand, int count) {
        ArrayList<T> copy = new ArrayList<T>(list);
        RandHelper.shuffle(copy, rand);
        if (copy.size() < count) {
            return copy;
        }
        return copy.subList(0, count);
    }

    public static void shuffle(List<?> list, class_5819 rnd) {
        int size = list.size();
        if (size < 5 || list instanceof RandomAccess) {
            for (int i = size; i > 1; --i) {
                RandHelper.swap(list, i - 1, rnd.method_43048(i));
            }
        } else {
            Object[] arr = list.toArray();
            for (int i = size; i > 1; --i) {
                RandHelper.swap(arr, i - 1, rnd.method_43048(i));
            }
            ListIterator<?> it = list.listIterator();
            for (int i = 0; i < arr.length; ++i) {
                it.next();
                it.set(arr[i]);
            }
        }
    }

    private static void swap(List<?> list, int i, int j) {
        List<?> l = list;
        l.set(i, l.set(j, l.get(i)));
    }

    private static void swap(Object[] x, int a, int b) {
        Object t = x[a];
        x[a] = x[b];
        x[b] = t;
    }
}

