/*
 * Decompiled with CFR 0.152.
 */
package dev.codedsakura.blossom.lib.text;

import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import java.util.stream.Collector;

public class JoiningCollector<T> {
    private final BinaryOperator<T> add;
    private final Supplier<T> joiner;
    private T previous;
    private T result;

    private JoiningCollector(BinaryOperator<T> add, Supplier<T> joiner) {
        this.add = add;
        this.joiner = joiner;
    }

    public void accumulator(T t) {
        if (this.previous != null) {
            this.result = this.add.apply(this.result, this.joiner.get());
            this.result = this.add.apply(this.result, t);
        } else {
            this.result = t;
        }
        this.previous = t;
    }

    public JoiningCollector<T> combiner(JoiningCollector<T> _b) {
        throw new UnsupportedOperationException("Parallel Stream not supported");
    }

    public T finisher() {
        return this.result;
    }

    public static <T> Collector<T, ?, T> collector(BinaryOperator<T> add, T joiner) {
        return Collector.of(() -> new JoiningCollector<Object>(add, () -> joiner), JoiningCollector::accumulator, JoiningCollector::combiner, JoiningCollector::finisher, new Collector.Characteristics[0]);
    }

    public static <T> Collector<T, ?, T> collector(BinaryOperator<T> add, Supplier<T> joiner) {
        return Collector.of(() -> new JoiningCollector(add, joiner), JoiningCollector::accumulator, JoiningCollector::combiner, JoiningCollector::finisher, new Collector.Characteristics[0]);
    }
}

