/*
 * Decompiled with CFR 0.152.
 */
package dev.codedsakura.blossom.lib.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

public class CubicBezierCurve {
    private static final double TARGET_PRECISION = 1.0E-4;
    private final boolean enabled;
    private final double[] points;
    private final double start;
    private final double end;
    private final int stepCount;
    private final ArrayList<Double> data = new ArrayList();

    public CubicBezierCurve(double[] points, double start, double end, int stepCount, boolean enabled) {
        this.points = points;
        this.start = start;
        this.end = end;
        this.stepCount = stepCount;
        this.enabled = enabled;
        if (enabled) {
            this.generateData();
        }
    }

    private double calculateX(double t) {
        return 3.0 * Math.pow(1.0 - t, 2.0) * t * this.points[0] + 3.0 * (1.0 - t) * Math.pow(t, 2.0) * this.points[2] + Math.pow(t, 3.0);
    }

    private double calculateY(double t) {
        return 3.0 * Math.pow(1.0 - t, 2.0) * t * this.points[1] + 3.0 * (1.0 - t) * Math.pow(t, 2.0) * this.points[3] + Math.pow(t, 3.0);
    }

    private void generateData() {
        double difference = this.end - this.start;
        this.data.add(this.start);
        for (int i = 1; i < this.stepCount; ++i) {
            double targetX = (double)i / (double)this.stepCount;
            double t = 0.5;
            double tX = this.calculateX(t);
            int step = 2;
            while (Math.abs(tX - targetX) > 1.0E-4) {
                tX = this.calculateX(t += (double)(tX > targetX ? -1 : 1) / Math.pow(2.0, step));
                ++step;
            }
            this.data.add(this.start + this.calculateY(t) * difference);
        }
        this.data.add(this.end);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public double[] getPoints() {
        return this.points;
    }

    public double getStart() {
        return this.start;
    }

    public double getEnd() {
        return this.end;
    }

    public int getStepCount() {
        return this.stepCount;
    }

    public ArrayList<Double> getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CubicBezierCurve that = (CubicBezierCurve)o;
        return Double.compare(that.start, this.start) == 0 && Double.compare(that.end, this.end) == 0 && this.stepCount == that.stepCount && Arrays.equals(this.points, that.points);
    }

    public int hashCode() {
        int result = Objects.hash(this.start, this.end, this.stepCount);
        result = 31 * result + Arrays.hashCode(this.points);
        return result;
    }

    public String toString() {
        return "CubicBezierCurve{points=" + Arrays.toString(this.points) + ", start=" + this.start + ", end=" + this.end + ", stepCount=" + this.stepCount + "}";
    }
}

