/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polydex.api.v1.recipe;

import eu.pb4.polydex.api.v1.recipe.PolydexPage;
import eu.pb4.polydex.api.v1.recipe.PolydexStack;
import eu.pb4.polydex.impl.PolydexEntryImpl;
import eu.pb4.polydex.impl.PolydexImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public interface PolydexEntry {
    public static PolydexEntry of(class_1792 item) {
        return new PolydexEntryImpl(class_7923.field_41178.method_10221((Object)item), PolydexStack.of(item), new ArrayList<PolydexPage>(), new ArrayList<PolydexPage>(), PolydexEntryImpl.WEAK_CHECK);
    }

    public static PolydexEntry of(class_1799 stack) {
        return new PolydexEntryImpl(class_7923.field_41178.method_10221((Object)stack.method_7909()), PolydexStack.of(stack), new ArrayList<PolydexPage>(), new ArrayList<PolydexPage>(), PolydexEntryImpl.WEAK_CHECK);
    }

    public static PolydexEntry of(class_2960 identifier, class_1799 stack) {
        return new PolydexEntryImpl(identifier, PolydexStack.of(stack), new ArrayList<PolydexPage>(), new ArrayList<PolydexPage>(), PolydexEntryImpl.STRICT_CHECK);
    }

    public static PolydexEntry of(class_2960 identifier, PolydexStack<?> stack) {
        return new PolydexEntryImpl(identifier, stack, new ArrayList<PolydexPage>(), new ArrayList<PolydexPage>(), PolydexEntryImpl.STRICT_CHECK);
    }

    public static PolydexEntry of(class_2960 identifier, class_1799 stack, BiPredicate<PolydexEntry, PolydexStack<?>> isPartOf) {
        return new PolydexEntryImpl(identifier, PolydexStack.of(stack), new ArrayList<PolydexPage>(), new ArrayList<PolydexPage>(), isPartOf);
    }

    public static PolydexEntry of(class_2960 identifier, PolydexStack<?> stack, BiPredicate<PolydexEntry, PolydexStack<?>> isPartOf) {
        return new PolydexEntryImpl(identifier, stack, new ArrayList<PolydexPage>(), new ArrayList<PolydexPage>(), isPartOf);
    }

    public static void registerEntryCreator(class_1792 item, Function<class_1799, @Nullable PolydexEntry> builder) {
        PolydexImpl.ITEM_ENTRY_CREATOR.put(item, builder);
    }

    public static void registerProvider(BiConsumer<MinecraftServer, EntryConsumer> builder) {
        PolydexImpl.ENTRY_PROVIDERS.add(builder);
    }

    public static void registerBuilder(class_1792 item, Function<class_1792, @Nullable Collection<PolydexEntry>> builder) {
        PolydexImpl.ITEM_ENTRY_BUILDERS.put(item, builder);
    }

    public class_2960 identifier();

    public PolydexStack<?> stack();

    public List<PolydexPage> outputPages();

    public List<PolydexPage> ingredientPages();

    default public int getVisiblePagesSize(class_3222 player) {
        int i = 0;
        for (PolydexPage page : this.outputPages()) {
            if (!page.canDisplay(this, player)) continue;
            ++i;
        }
        return i;
    }

    default public List<PolydexPage> getVisiblePages(class_3222 player) {
        ArrayList<PolydexPage> list = new ArrayList<PolydexPage>();
        for (PolydexPage page : this.outputPages()) {
            if (!page.canDisplay(this, player)) continue;
            list.add(page);
        }
        return list;
    }

    default public List<PolydexPage> getVisibleIngredientPages(class_3222 player) {
        ArrayList<PolydexPage> list = new ArrayList<PolydexPage>();
        for (PolydexPage page : this.ingredientPages()) {
            if (!page.canDisplay(this, player)) continue;
            list.add(page);
        }
        return list;
    }

    default public int getVisibleIngredientPagesSize(class_3222 player) {
        int i = 0;
        for (PolydexPage page : this.ingredientPages()) {
            if (!page.canDisplay(this, player)) continue;
            ++i;
        }
        return i;
    }

    public boolean isPartOf(PolydexStack<?> var1);

    public static interface EntryConsumer
    extends Consumer<PolydexEntry> {
        @Override
        public void accept(PolydexEntry var1);

        public void accept(PolydexEntry var1, class_1761 var2);

        public void acceptAll(Collection<PolydexEntry> var1);

        public void acceptAll(Collection<PolydexEntry> var1, class_1761 var2);
    }
}

