/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polydex.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.SerializedName;
import eu.pb4.polydex.api.v1.hover.HoverDisplayBuilder;
import eu.pb4.polydex.api.v1.hover.HoverSettings;
import eu.pb4.polydex.impl.PolydexImpl;
import eu.pb4.predicate.api.BuiltinPredicates;
import eu.pb4.predicate.api.GsonPredicateSerializer;
import eu.pb4.predicate.api.MinecraftPredicate;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import org.apache.commons.io.IOUtils;

public class PolydexConfigImpl {
    public static final class_2960 DEFAULT_DISPLAY = PolydexImpl.id(PolydexConfigImpl.getDefaultDisplay());
    public boolean displayEnabled = true;
    public int displayUpdateRate = 4;
    public boolean displayCantMine = true;
    public boolean displayModSource = true;
    public boolean displayAdditional = true;
    public boolean displayMiningProgress = true;
    public boolean displayEntity = true;
    public boolean displayEntityHealth = true;
    @SerializedName(value="default_hover_settings")
    public GlobalSettings defaultHoverSettings = new GlobalSettings();
    public MinecraftPredicate displayPredicate = BuiltinPredicates.hasPlayer();

    private static String getDefaultDisplay() {
        if (FabricLoader.getInstance().isModLoaded("wthit") || FabricLoader.getInstance().isModLoaded("jade")) {
            return "disabled";
        }
        return "bossbar";
    }

    private void fillDefaults() {
        for (HoverDisplayBuilder.ComponentType c : HoverDisplayBuilder.ComponentType.getAll()) {
            if (this.defaultHoverSettings.visibilityMap.containsKey(c.identifier())) continue;
            this.defaultHoverSettings.visibilityMap.put(c.identifier(), c.defaultVisibility());
        }
    }

    public static PolydexConfigImpl loadOrCreateConfig(class_7225.class_7874 lookup) {
        try {
            PolydexConfigImpl config;
            Gson GSON = new GsonBuilder().disableHtmlEscaping().setLenient().setPrettyPrinting().registerTypeAdapter(class_2960.class, (Object)new IdentifierSerializer()).registerTypeHierarchyAdapter(MinecraftPredicate.class, (Object)GsonPredicateSerializer.create((class_7225.class_7874)lookup)).create();
            File configFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), "polydex.json");
            if (configFile.exists()) {
                String json = IOUtils.toString((Reader)new InputStreamReader((InputStream)new FileInputStream(configFile), StandardCharsets.UTF_8));
                config = (PolydexConfigImpl)GSON.fromJson(json, PolydexConfigImpl.class);
            } else {
                config = new PolydexConfigImpl();
            }
            config.fillDefaults();
            PolydexConfigImpl.saveConfig(config, lookup);
            return config;
        }
        catch (IOException exception) {
            PolydexImpl.LOGGER.error("Something went wrong while reading config!");
            exception.printStackTrace();
            return new PolydexConfigImpl();
        }
    }

    public static void saveConfig(PolydexConfigImpl config, class_7225.class_7874 lookup) {
        File configFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), "polydex.json");
        try {
            Gson GSON = new GsonBuilder().disableHtmlEscaping().setLenient().setPrettyPrinting().registerTypeAdapter(class_2960.class, (Object)new IdentifierSerializer()).registerTypeHierarchyAdapter(MinecraftPredicate.class, (Object)GsonPredicateSerializer.create((class_7225.class_7874)lookup)).create();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(configFile), StandardCharsets.UTF_8));
            writer.write(GSON.toJson((Object)config));
            writer.close();
        }
        catch (Exception e) {
            PolydexImpl.LOGGER.error("Something went wrong while saving config!");
            e.printStackTrace();
        }
    }

    public static class GlobalSettings
    implements HoverSettings {
        @SerializedName(value="display_type")
        public class_2960 defaultDisplay = DEFAULT_DISPLAY;
        @SerializedName(value="display_mode")
        public HoverSettings.DisplayMode displayMode = HoverSettings.DisplayMode.TARGET;
        @SerializedName(value="visible_components")
        public HashMap<class_2960, HoverDisplayBuilder.ComponentType.Visibility> visibilityMap = new HashMap();

        @Override
        public class_2960 currentType() {
            return this.defaultDisplay;
        }

        @Override
        public HoverSettings.DisplayMode displayMode() {
            return this.displayMode;
        }

        @Override
        public boolean isComponentVisible(class_3222 player, HoverDisplayBuilder.ComponentType type) {
            HoverDisplayBuilder.ComponentType.Visibility value = this.visibilityMap.getOrDefault(type.identifier(), HoverDisplayBuilder.ComponentType.Visibility.DEFAULT);
            if (value == HoverDisplayBuilder.ComponentType.Visibility.DEFAULT) {
                value = type.defaultVisibility();
            }
            return switch (value) {
                default -> throw new MatchException(null, null);
                case HoverDisplayBuilder.ComponentType.Visibility.ALWAYS -> true;
                case HoverDisplayBuilder.ComponentType.Visibility.NEVER, HoverDisplayBuilder.ComponentType.Visibility.DEFAULT -> false;
                case HoverDisplayBuilder.ComponentType.Visibility.SNEAKING -> player.method_5715();
            };
        }
    }

    private static final class IdentifierSerializer
    implements JsonSerializer<class_2960>,
    JsonDeserializer<class_2960> {
        private IdentifierSerializer() {
        }

        public class_2960 deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonPrimitive()) {
                return class_2960.method_12829((String)json.getAsString());
            }
            return null;
        }

        public JsonElement serialize(class_2960 src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.toString());
        }
    }
}

