/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polydex.impl.book;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import eu.pb4.polydex.api.v1.recipe.PolydexIngredient;
import eu.pb4.polydex.api.v1.recipe.PolydexStack;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1856;

public class PolydexIngredientImpl
implements PolydexIngredient<class_1799> {
    private static final Interner<PolydexIngredientImpl> INTERNER = Interners.newWeakInterner();
    private final class_1856 ingredient;
    private final long count;
    private final float chance;
    private final List<class_1799> itemStacks;
    private final List<PolydexStack<class_1799>> polydexStacks;

    public PolydexIngredientImpl(class_1856 ingredient, long count, float chance) {
        this.ingredient = ingredient;
        this.count = count;
        this.chance = chance;
        this.itemStacks = ingredient.getCustomIngredient() != null ? ingredient.getCustomIngredient().getMatchingStacks() : List.of(ingredient.method_8105());
        this.polydexStacks = this.itemStacks.stream().map(x -> PolydexStack.of(x, count, chance)).toList();
    }

    public static PolydexIngredient<class_1799> of(class_1856 ingredient, long count, float chance) {
        return (PolydexIngredient)INTERNER.intern((Object)new PolydexIngredientImpl(ingredient, count, chance));
    }

    @Override
    public boolean isEmpty() {
        return this.ingredient.method_8103();
    }

    @Override
    public List<PolydexStack<class_1799>> asStacks() {
        return this.polydexStacks;
    }

    @Override
    public float chance() {
        return this.chance;
    }

    @Override
    public long amount() {
        return this.count;
    }

    @Override
    public boolean matchesDirect(PolydexStack<class_1799> stack, boolean strict) {
        return this.ingredient.method_8093(stack.getBacking());
    }

    @Override
    public Class<class_1799> getBackingClass() {
        return class_1799.class;
    }
}

