/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polydex.impl.book.ui;

import eu.pb4.polydex.api.v1.recipe.PolydexEntry;
import eu.pb4.polydex.api.v1.recipe.PolydexPageUtils;
import eu.pb4.polydex.impl.PolydexImpl;
import eu.pb4.polydex.impl.book.InternalPageTextures;
import eu.pb4.polydex.impl.book.ui.ExtendedGui;
import eu.pb4.polydex.impl.book.ui.GuiUtils;
import eu.pb4.polydex.impl.book.ui.PageViewerGui;
import eu.pb4.polydex.impl.book.ui.PagedLayer;
import eu.pb4.sgui.api.elements.GuiElement;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.layered.LayerView;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3917;

public class MainIndexGui
extends ExtendedGui {
    private final ItemLayer mainLayer;
    private final NamespaceLayer indexLayer;
    private final LayerView indexLayerView;
    private PolydexImpl.PackedEntries entries;
    private boolean showAll;

    public MainIndexGui(class_3222 player, boolean showAll, int pageItem, int pageSub) {
        super(class_3917.field_17327, player, true);
        this.showAll = showAll;
        this.mainLayer = new ItemLayer(6);
        this.indexLayer = new NamespaceLayer(4);
        this.entries = PolydexImpl.ITEM_ENTRIES;
        this.mainLayer.setPage(pageItem);
        this.indexLayer.setPage(pageSub);
        this.addLayer(this.mainLayer, 0, 0).setZIndex(1);
        this.indexLayerView = this.addLayer(this.indexLayer, 0, 6);
        this.indexLayerView.setZIndex(0);
        this.setOverlayTexture(InternalPageTextures.MAIN_INVENTORY);
        this.setText((class_2561)class_2561.method_43471((String)"text.polydex.index_title"));
    }

    public void onTick() {
        if (!PolydexImpl.isReady()) {
            this.close();
            return;
        }
        super.onTick();
    }

    public class ItemLayer
    extends PagedLayer {
        public ItemLayer(int height) {
            super(MainIndexGui.this.getPlayer(), height, 9, true);
        }

        @Override
        protected int getEntryCount() {
            return MainIndexGui.this.entries.get(MainIndexGui.this.showAll).size();
        }

        protected GuiElement getElement(int id) {
            if (id < MainIndexGui.this.entries.get(MainIndexGui.this.showAll).size()) {
                PolydexEntry item = MainIndexGui.this.entries.get(MainIndexGui.this.showAll).get(id);
                return GuiElementBuilder.from((class_1799)item.stack().toDisplayItemStack(this.player)).setCallback((x, type, z) -> {
                    if (type.isLeft && item.getVisiblePagesSize(MainIndexGui.this.getPlayer()) > 0 || type.isRight && item.getVisibleIngredientPagesSize(MainIndexGui.this.getPlayer()) > 0) {
                        MainIndexGui.this.close(true);
                        PageViewerGui.openEntry(this.player, item, type.isRight, () -> ((MainIndexGui)MainIndexGui.this).open());
                        GuiUtils.playClickSound(this.player);
                    }
                }).build();
            }
            return GuiElement.EMPTY;
        }

        protected GuiElement getNavElement(int id) {
            return switch (id) {
                case 0 -> new GuiElementBuilder(MainIndexGui.this.showAll ? class_1802.field_8777 : class_1802.field_8135).noDefaults().hideDefaultTooltip().setName((class_2561)class_2561.method_43471((String)("text.polydex.button.see_" + (MainIndexGui.this.showAll ? "limited" : "everything")))).setCallback((x, y, z) -> {
                    MainIndexGui.this.showAll = !MainIndexGui.this.showAll;
                    this.setPage(this.getPage());
                    GuiUtils.playClickSound(this.player);
                }).build();
                case 1 -> new GuiElementBuilder(class_1802.field_8361).noDefaults().hideDefaultTooltip().setName((class_2561)class_2561.method_43471((String)("text.polydex.category." + MainIndexGui.this.indexLayer.type.name().toLowerCase(Locale.ROOT)))).setCallback((x, y, z) -> {
                    GuiUtils.playClickSound(this.player);
                    MainIndexGui.this.indexLayer.type = MainIndexGui.this.indexLayer.type.getNext();
                    MainIndexGui.this.indexLayer.updateDisplay();
                    this.updateDisplay();
                    MainIndexGui.this.setOverlayTexture(MainIndexGui.this.indexLayer.type == NamespaceLayer.Type.INVENTORY ? InternalPageTextures.MAIN_INVENTORY : InternalPageTextures.MAIN);
                }).build();
                case 3 -> {
                    if (this.getPageAmount() > 1) {
                        yield GuiUtils.previousPage(this.player, this);
                    }
                    yield MainIndexGui.this.filler();
                }
                case 4 -> {
                    if (this.getPageAmount() > 1) {
                        yield GuiUtils.page(this.player, this.page + 1, this.getPageAmount()).build();
                    }
                    yield MainIndexGui.this.filler();
                }
                case 5 -> {
                    if (this.getPageAmount() > 1) {
                        yield GuiUtils.nextPage(this.player, this);
                    }
                    yield MainIndexGui.this.filler();
                }
                case 8 -> GuiUtils.backButton(this.player, () -> ((MainIndexGui)MainIndexGui.this).close(), false);
                default -> MainIndexGui.this.filler();
            };
        }
    }

    public class NamespaceLayer
    extends PagedLayer {
        private Type type;

        public NamespaceLayer(int height) {
            super(MainIndexGui.this.getPlayer(), height, 9, true);
            this.type = Type.INVENTORY;
        }

        @Override
        protected int getEntryCount() {
            return this.type == Type.INVENTORY ? 1 : this.type.entries.size();
        }

        @Override
        public int getPageAmount() {
            return this.type == Type.INVENTORY ? 1 : class_3532.method_15384((double)(((double)this.type.entries.size() + 1.0) / (double)this.pageSize));
        }

        @Override
        protected void updateDisplay() {
            if (this.type == Type.INVENTORY) {
                int i;
                class_1661 inventory = this.player.method_31548();
                for (i = 0; i < 3; ++i) {
                    for (int j = 0; j < 9; ++j) {
                        this.setSlot(i * 9 + j, (GuiElementInterface)this.createSlot(inventory.method_5438(j + (i + 1) * 9)));
                    }
                }
                for (i = 0; i < 9; ++i) {
                    this.setSlot(i + 27, (GuiElementInterface)this.createSlot(inventory.method_5438(i)));
                }
            } else {
                super.updateDisplay();
            }
        }

        private GuiElement createSlot(class_1799 stack) {
            return new GuiElement(stack, (x, type, z) -> {
                PolydexEntry page = PolydexPageUtils.getItemEntryFor(stack);
                if (page != null && (type.isLeft && page.getVisiblePagesSize(MainIndexGui.this.getPlayer()) > 0 || type.isRight && page.getVisibleIngredientPagesSize(MainIndexGui.this.getPlayer()) > 0)) {
                    MainIndexGui.this.close(true);
                    PageViewerGui.openEntry(this.player, page, type.isRight, () -> ((MainIndexGui)MainIndexGui.this).open());
                    GuiUtils.playClickSound(this.player);
                }
            });
        }

        protected GuiElement getElement(int id) {
            if (id == 0) {
                GuiElementBuilder builder = new GuiElementBuilder(class_1802.field_8361).setName((class_2561)class_2561.method_43471((String)"text.polydex.display_all_items")).noDefaults().hideDefaultTooltip().setCallback((x, y, z) -> {
                    MainIndexGui.this.entries = PolydexImpl.ITEM_ENTRIES;
                    MainIndexGui.this.indexLayer.updateDisplay();
                    MainIndexGui.this.mainLayer.setPage(0);
                    GuiUtils.playClickSound(this.player);
                    MainIndexGui.this.indexLayerView.setZIndex(0);
                });
                if (MainIndexGui.this.entries == PolydexImpl.ITEM_ENTRIES) {
                    builder.glow();
                }
                return builder.build();
            }
            if (id < this.type.entries.size() + 1) {
                PolydexImpl.NamespacedEntry item = this.type.entries.get(id - 1);
                GuiElementBuilder builder = GuiElementBuilder.from((class_1799)item.icon().apply(this.player)).setName(item.display()).noDefaults().hideDefaultTooltip().setCallback((x, y, z) -> {
                    MainIndexGui.this.entries = item.entries();
                    MainIndexGui.this.indexLayer.updateDisplay();
                    MainIndexGui.this.mainLayer.setPage(0);
                    GuiUtils.playClickSound(this.player);
                    MainIndexGui.this.indexLayerView.setZIndex(0);
                });
                if (item.entries() == MainIndexGui.this.entries) {
                    builder.glow();
                }
                return builder.build();
            }
            return GuiElement.EMPTY;
        }

        protected GuiElement getNavElement(int id) {
            return switch (id) {
                case 3 -> {
                    if (this.getPageAmount() > 1) {
                        yield GuiUtils.previousPage(this.player, this);
                    }
                    yield MainIndexGui.this.filler();
                }
                case 4 -> {
                    if (this.getPageAmount() > 1) {
                        yield GuiUtils.page(this.player, this.page + 1, this.getPageAmount()).build();
                    }
                    yield MainIndexGui.this.filler();
                }
                case 5 -> {
                    if (this.getPageAmount() > 1) {
                        yield GuiUtils.nextPage(this.player, this);
                    }
                    yield MainIndexGui.this.filler();
                }
                default -> MainIndexGui.this.filler();
            };
        }

        private static enum Type {
            INVENTORY(null),
            ITEM_GROUP(PolydexImpl.ITEM_GROUP_ENTRIES),
            NAMESPACES(PolydexImpl.NAMESPACED_ENTRIES);

            public final List<PolydexImpl.NamespacedEntry> entries;

            private Type(List<PolydexImpl.NamespacedEntry> list) {
                this.entries = list;
            }

            public Type getNext() {
                return Type.values()[(this.ordinal() + 1) % Type.values().length];
            }
        }
    }
}

