/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polydex.impl.book.ui;

import eu.pb4.polydex.api.v1.recipe.PolydexCategory;
import eu.pb4.polydex.api.v1.recipe.PolydexEntry;
import eu.pb4.polydex.api.v1.recipe.PolydexPage;
import eu.pb4.polydex.impl.PolydexImpl;
import eu.pb4.polydex.impl.book.InternalPageTextures;
import eu.pb4.polydex.impl.book.ui.ExtendedGui;
import eu.pb4.polydex.impl.book.ui.GuiUtils;
import eu.pb4.polydex.impl.book.ui.LayerBuilder;
import eu.pb4.polydex.impl.book.ui.PageAware;
import eu.pb4.polydex.impl.book.ui.PagedLayer;
import eu.pb4.sgui.api.elements.AnimatedGuiElement;
import eu.pb4.sgui.api.elements.GuiElement;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class PageViewerGui
extends ExtendedGui
implements PageAware {
    public static final int PAGE_SIZE = 45;
    protected final Runnable closeCallback;
    protected final List<PolydexPage> pages;
    protected final List<GroupedPages> groupedPages;
    @Nullable
    protected final PolydexEntry entry;
    private final LayerBuilder displayLayer;
    private final SubRecipeLayer subPages;
    private final IconGetter iconGetter;
    protected int page = 0;

    public PageViewerGui(class_3222 player, class_2561 title, @Nullable PolydexEntry entry, List<PolydexPage> pages, IconGetter iconGetter, @Nullable Runnable closeCallback) {
        super(class_3917.field_17327, player, true);
        this.closeCallback = closeCallback;
        this.iconGetter = iconGetter;
        this.displayLayer = new LayerBuilder(player);
        this.pages = pages;
        this.groupedPages = GroupedPages.of(this.pages);
        this.entry = entry;
        this.addLayer(this.displayLayer, 0, 0);
        this.setOverlayTexture(InternalPageTextures.MAIN);
        this.setText(title);
        this.subPages = new SubRecipeLayer(4);
        this.addLayer(this.subPages, 0, 6);
        this.setupNavigator();
        this.updateDisplay();
        this.subPages.updateDisplay();
        this.open();
    }

    public static void openCustom(class_3222 player, class_2561 title, List<PolydexPage> pages, boolean useTypeIcon, @Nullable Runnable closeCallback) {
        new PageViewerGui(player, title, null, pages, useTypeIcon ? PolydexPage::typeIcon : PolydexPage::entryIcon, closeCallback);
    }

    public static void openCategory(class_3222 player, PolydexCategory category, List<PolydexPage> pages, @Nullable Runnable closeCallback) {
        class_5250 title = class_2561.method_43469((String)"text.polydex.recipes_title_category", (Object[])new Object[]{category.name()});
        new PageViewerGui(player, (class_2561)title, null, pages, PolydexPage::entryIcon, closeCallback);
    }

    public static void openEntry(class_3222 player, PolydexEntry entry, boolean ingredients, @Nullable Runnable closeCallback) {
        List<PolydexPage> pages = ingredients ? entry.getVisibleIngredientPages(player) : entry.getVisiblePages(player);
        class_5250 title = class_2561.method_43469((String)(ingredients ? "text.polydex.recipes_title_input" : "text.polydex.recipes_title_output"), (Object[])new Object[]{entry.stack().getName()});
        new PageViewerGui(player, (class_2561)title, entry, pages, ingredients ? PolydexPage::entryIcon : PolydexPage::typeIcon, closeCallback);
    }

    protected void setupNavigator() {
        GuiElement filler = this.filler();
        boolean addNav = this.pages.size() > 1;
        this.setSlot(46, (GuiElementInterface)filler);
        this.setSlot(47, (GuiElementInterface)filler);
        this.setSlot(48, (GuiElementInterface)(addNav ? GuiUtils.previousPage(this.getPlayer(), this) : filler));
        this.setSlot(49, (GuiElementInterface)filler);
        this.setSlot(50, (GuiElementInterface)(addNav ? GuiUtils.nextPage(this.getPlayer(), this) : filler));
        this.setSlot(51, (GuiElementInterface)filler);
        this.setSlot(52, (GuiElementInterface)filler);
        this.setSlot(53, (GuiElementInterface)GuiUtils.backButton(this.getPlayer(), () -> {
            if (this.closeCallback != null) {
                this.closeCallback.run();
            } else {
                this.close();
            }
        }, this.closeCallback != null));
    }

    public void onTick() {
        if (!PolydexImpl.isReady()) {
            this.close();
            return;
        }
        super.onTick();
    }

    protected void updateDisplay() {
        if (!PolydexImpl.isReady()) {
            return;
        }
        this.lock();
        PolydexPage pageEntry = this.pages.get(this.page);
        class_2561 t = pageEntry.texture(this.getPlayer());
        this.setTexture(t);
        this.displayLayer.clear(t != null ? this.filler() : GuiUtils.FILLER);
        pageEntry.createPage(this.entry, this.getPlayer(), this.displayLayer);
        this.setSlot(45, pageEntry.typeIcon(this.entry, this.getPlayer()));
        if (this.pages.size() > 1) {
            this.setSlot(49, (GuiElementBuilderInterface)GuiUtils.page(this.getPlayer(), this.page + 1, this.getPageAmount()));
        }
        this.unlock();
    }

    @Override
    public int getPage() {
        return this.page;
    }

    @Override
    public void setPage(int i) {
        this.page = i;
        this.updateDisplay();
    }

    @Override
    public int getPageAmount() {
        return this.pages.size();
    }

    @FunctionalInterface
    public static interface IconGetter {
        public class_1799 getIcon(PolydexPage var1, @Nullable PolydexEntry var2, class_3222 var3);
    }

    public record GroupedPages(String group, List<PolydexPage> pages, int index) {
        public static List<GroupedPages> of(List<PolydexPage> pages) {
            ArrayList<GroupedPages> out = new ArrayList<GroupedPages>();
            GroupedPages group = null;
            for (int i = 0; i < pages.size(); ++i) {
                PolydexPage page = pages.get(i);
                if (page.getGroup().isEmpty()) {
                    if (group != null) {
                        out.add(group);
                        group = null;
                    }
                    out.add(new GroupedPages("", List.of(page), i));
                    continue;
                }
                if (group == null) {
                    group = new GroupedPages(page.getGroup(), new ArrayList<PolydexPage>(), i);
                    group.pages.add(page);
                    continue;
                }
                if (group.group.equals(page.getGroup())) {
                    group.pages.add(page);
                    continue;
                }
                out.add(group);
                group = new GroupedPages(page.getGroup(), new ArrayList<PolydexPage>(), i);
                group.pages.add(page);
            }
            if (group != null) {
                out.add(group);
            }
            return out;
        }
    }

    public class SubRecipeLayer
    extends PagedLayer {
        public SubRecipeLayer(int height) {
            super(PageViewerGui.this.getPlayer(), height, 9, true);
        }

        @Override
        protected int getEntryCount() {
            return PageViewerGui.this.groupedPages.size();
        }

        @Override
        protected GuiElementInterface getElement(int id) {
            if (id < PageViewerGui.this.groupedPages.size()) {
                GroupedPages group = PageViewerGui.this.groupedPages.get(id);
                ArrayList<class_1799> list = new ArrayList<class_1799>(group.pages.size());
                for (PolydexPage page : group.pages) {
                    list.add(PageViewerGui.this.iconGetter.getIcon(page, PageViewerGui.this.entry, this.player));
                }
                return new AnimatedGuiElement(list.toArray(new class_1799[0]), 10, false, (x, type, z) -> {
                    PageViewerGui.this.setPage(group.index);
                    GuiUtils.playClickSound(this.player);
                });
            }
            return GuiElement.EMPTY;
        }
    }
}

