/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polydex.impl.display;

import eu.pb4.polydex.api.v1.hover.HoverDisplay;
import eu.pb4.polydex.api.v1.hover.HoverDisplayBuilder;
import eu.pb4.polydex.api.v1.hover.PolydexTarget;
import eu.pb4.polydex.impl.display.PolydexTargetImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public class DisplayImpl
implements HoverDisplayBuilder {
    private final PolydexTargetImpl target;
    private final Map<HoverDisplayBuilder.ComponentType, class_2561> components = new HashMap<HoverDisplayBuilder.ComponentType, class_2561>();

    public DisplayImpl(PolydexTargetImpl target) {
        this.target = target;
    }

    @Override
    public boolean isSmall() {
        return this.target.getDisplay().isSmall();
    }

    @Override
    public HoverDisplay.Type getDisplayType() {
        return this.target.getDisplay().getType();
    }

    @Override
    public PolydexTarget getTarget() {
        return this.target;
    }

    @Override
    public void setComponent(HoverDisplayBuilder.ComponentType type, class_2561 text) {
        if (this.target.settings().isComponentVisible(this.target.player(), type)) {
            this.components.put(type, text);
        }
    }

    @Override
    public class_2561 getComponent(HoverDisplayBuilder.ComponentType type) {
        return this.components.get(type);
    }

    @Override
    public boolean removeComponent(HoverDisplayBuilder.ComponentType type) {
        return this.removeAndGetComponent(type) != null;
    }

    @Override
    @Nullable
    public class_2561 removeAndGetComponent(HoverDisplayBuilder.ComponentType type) {
        return this.components.remove(type);
    }

    @Override
    public Collection<HoverDisplayBuilder.ComponentType> getComponentTypes() {
        return this.components.keySet();
    }

    @Override
    public List<class_2561> getOutput() {
        ArrayList<Map.Entry<HoverDisplayBuilder.ComponentType, class_2561>> list = new ArrayList<Map.Entry<HoverDisplayBuilder.ComponentType, class_2561>>(this.components.entrySet());
        list.sort(Comparator.comparing(t -> ((HoverDisplayBuilder.ComponentType)t.getKey()).index()));
        ArrayList<class_2561> out = new ArrayList<class_2561>();
        for (Map.Entry<HoverDisplayBuilder.ComponentType, class_2561> entry : list) {
            out.add(entry.getValue());
        }
        return out;
    }

    public void clear() {
        this.components.clear();
    }
}

